/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data.save;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.net.UpdatePlayerProfileS2CPacket;
import abeshutt.staracademy.proxy.ProxyGameProfile;
import abeshutt.staracademy.world.data.save.WorldData;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class PlayerProfileData
extends WorldData {
    public static final PlayerProfileData CLIENT = new PlayerProfileData();
    private final Map<UUID, GameProfile> profiles = new ConcurrentHashMap<UUID, GameProfile>();
    private final Map<UUID, CompletableFuture<GameProfile>> futures = new LinkedHashMap<UUID, CompletableFuture<GameProfile>>();

    public Map<UUID, GameProfile> getProfiles() {
        return this.profiles;
    }

    public Optional<GameProfile> getProfile(UUID uuid) {
        return Optional.ofNullable(this.profiles.get(uuid));
    }

    public synchronized CompletableFuture<GameProfile> getProfileAsync(MinecraftServer server, UUID uuid) {
        if (this.profiles.containsKey(uuid)) {
            return CompletableFuture.completedFuture(this.profiles.get(uuid));
        }
        CompletableFuture<GameProfile> future = this.futures.get(uuid);
        if (future == null) {
            future = CompletableFuture.supplyAsync(() -> {
                ProfileResult result = server.method_3844().fetchProfile(uuid, true);
                GameProfile profile = result == null ? new GameProfile(uuid, "Unknown") : result.profile();
                this.profiles.put(uuid, profile);
                this.futures.remove(uuid);
                this.method_80();
                NetworkManager.sendToPlayers((Iterable)server.method_3760().method_14571(), (class_8710)new UpdatePlayerProfileS2CPacket(uuid, profile));
                return profile;
            });
            this.futures.put(uuid, future);
        }
        return future;
    }

    private void onJoin(class_3222 player) {
        this.profiles.remove(player.method_5667());
        this.getProfileAsync(player.method_5682(), player.method_5667());
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdatePlayerProfileS2CPacket(this.profiles));
    }

    private void onTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            GameProfile profile = this.profiles.get(player.method_5667());
            if (profile == null || !profile.getName().equals("Unknown")) continue;
            ProxyGameProfile.of(profile).ifPresent(proxy -> {
                proxy.setName(player.method_7334().getName());
                this.method_80();
                NetworkManager.sendToPlayers((Iterable)server.method_3760().method_14571(), (class_8710)new UpdatePlayerProfileS2CPacket(player.method_5667(), profile));
            });
        }
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            this.profiles.forEach((uuid, profile) -> Adapters.GAME_PROFILE.writeNbt((GameProfile)profile).ifPresent(tag -> nbt.method_10566(uuid.toString(), tag)));
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.profiles.clear();
        for (String key : nbt.method_10541()) {
            Adapters.GAME_PROFILE.readNbt(nbt.method_10580(key)).ifPresent(profile -> this.profiles.put(UUID.fromString(key), (GameProfile)profile));
        }
    }

    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            PlayerProfileData data = ModWorldData.PLAYER_PROFILE.getGlobal(player.method_37908());
            data.onJoin(player);
        });
        TickEvent.SERVER_POST.register(server -> {
            PlayerProfileData data = ModWorldData.PLAYER_PROFILE.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }
}

