/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data.save;

import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.net.UpdateNickS2CPacket;
import abeshutt.staracademy.world.data.save.WorldData;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class NickData
extends WorldData {
    public static final NickData CLIENT = new NickData();
    private final Map<UUID, String> entries = new LinkedHashMap<UUID, String>();
    private final Set<UUID> changes = new HashSet<UUID>();

    public Map<UUID, String> getEntries() {
        return this.entries;
    }

    public Optional<String> get(UUID uuid) {
        return Optional.ofNullable(this.entries.get(uuid));
    }

    public void set(UUID uuid, String nick) {
        this.changes.add(uuid);
        if (nick == null) {
            this.entries.remove(uuid);
        } else {
            this.entries.put(uuid, nick);
        }
        this.method_80();
    }

    public void onTick(MinecraftServer server) {
        HashMap<UUID, String> entries = new HashMap<UUID, String>();
        for (UUID change : this.changes) {
            entries.put(change, this.entries.get(change));
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateNickS2CPacket(entries));
        }
    }

    public void onJoin(class_3222 player) {
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateNickS2CPacket(null));
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateNickS2CPacket(this.entries));
    }

    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            NickData data = ModWorldData.NICK.getGlobal(player.method_37908());
            data.onJoin(player);
        });
        TickEvent.SERVER_POST.register(server -> {
            NickData data = ModWorldData.NICK.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2487 entries = new class_2487();
            this.entries.forEach((uuid, nick) -> entries.method_10582(uuid.toString(), nick));
            nbt.method_10566("entries", (class_2520)entries);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.entries.clear();
        class_2487 entries = nbt.method_10562("entries");
        for (String key : entries.method_10541()) {
            this.entries.put(UUID.fromString(key), entries.method_10558(key));
        }
    }
}

