/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data.save;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.math.random.RandomSource;
import abeshutt.staracademy.world.data.save.WorldData;
import com.google.gson.JsonObject;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class LegendaryItemData
extends WorldData {
    private final List<Entry> entries = new ArrayList<Entry>();

    public void add(MinecraftServer server, class_2960 id, UUID player, class_2338 pos, class_2960 dimension) {
        class_3222 target = server.method_3760().method_14602(player);
        if (target != null) {
            for (class_3222 other : server.method_3760().method_14571()) {
                other.method_43496((class_2561)class_2561.method_43473().method_10852(target.method_5476()).method_10852((class_2561)class_2561.method_43470((String)" found the ").method_27692(class_124.field_1080)).method_10852(((class_1792)class_7923.field_41178.method_10223(id)).method_7848()).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
            }
        }
        this.entries.add(new Entry(id, ZonedDateTime.now(ZoneId.of("UTC")).toInstant().toEpochMilli(), player, pos, dimension));
        this.method_78(true);
    }

    public Optional<class_1792> getRemainingItem(RandomSource random) {
        HashSet<class_2960> remainingItems = new HashSet<class_2960>(ModConfigs.LEGENDARY_ITEMS.getOccurrences());
        for (Entry entry : this.entries) {
            remainingItems.remove(entry.item);
        }
        ArrayList<class_2960> result = new ArrayList<class_2960>(remainingItems);
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((class_2960)result.get(random.nextInt(result.size()))).flatMap(id -> class_7923.field_41178.method_55841(id).map(class_6880.class_6883::comp_349));
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2499 entries = new class_2499();
            for (Entry entry : this.entries) {
                entry.writeNbt().ifPresent(arg_0 -> entries.add(arg_0));
            }
            nbt.method_10566("entries", (class_2520)entries);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        class_2499 entries = nbt.method_10554("entries", 10);
        this.entries.clear();
        for (int i = 0; i < entries.size(); ++i) {
            Entry entry = new Entry();
            entry.readNbt(entries.method_10602(i));
            this.entries.add(entry);
        }
    }

    public static class Entry
    implements ISerializable<class_2487, JsonObject> {
        private class_2960 item;
        private long time;
        private UUID owner;
        private class_2338 pos;
        private class_2960 dimension;

        public Entry() {
        }

        public Entry(class_2960 item, long time, UUID owner, class_2338 pos, class_2960 dimension) {
            this.item = item;
            this.time = time;
            this.owner = owner;
            this.pos = pos;
            this.dimension = dimension;
        }

        @Override
        public Optional<class_2487> writeNbt() {
            return Optional.of(new class_2487()).map(nbt -> {
                Adapters.IDENTIFIER.writeNbt(this.item).ifPresent(tag -> nbt.method_10566("item", tag));
                Adapters.LONG.writeNbt(this.time).ifPresent(tag -> nbt.method_10566("time", tag));
                Adapters.UUID.writeNbt(this.owner).ifPresent(tag -> nbt.method_10566("owner", tag));
                Adapters.BLOCK_POS.writeNbt(this.pos).ifPresent(tag -> nbt.method_10566("pos", tag));
                Adapters.IDENTIFIER.writeNbt(this.dimension).ifPresent(tag -> nbt.method_10566("dimension", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.item = Adapters.IDENTIFIER.readNbt(nbt.method_10580("item")).orElseThrow();
            this.time = (Long)Adapters.LONG.readNbt(nbt.method_10580("time")).orElseThrow();
            this.owner = Adapters.UUID.readNbt(nbt.method_10580("owner")).orElseThrow();
            this.pos = Adapters.BLOCK_POS.readNbt(nbt.method_10580("pos")).orElse(null);
            this.dimension = Adapters.IDENTIFIER.readNbt(nbt.method_10580("dimension")).orElse(null);
        }
    }
}

