/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data.save;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.net.UpdateHousesS2CPacket;
import abeshutt.staracademy.world.data.AcademyHouse;
import abeshutt.staracademy.world.data.save.WorldData;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class HouseData
extends WorldData {
    public static final HouseData CLIENT = new HouseData();
    private final Map<String, AcademyHouse> houses = new LinkedHashMap<String, AcademyHouse>();
    private final Map<String, AcademyHouse> changes = new LinkedHashMap<String, AcademyHouse>();

    public Map<String, AcademyHouse> getHouses() {
        return this.houses;
    }

    public boolean method_79() {
        return true;
    }

    public Optional<AcademyHouse> get(String id) {
        return Optional.ofNullable(this.houses.get(id));
    }

    public AcademyHouse add(String id, String name, int color) {
        AcademyHouse house = new AcademyHouse(id);
        house.setName(name);
        house.setColor(color);
        this.houses.put(house.getId(), house);
        this.changes.put(house.getId(), house);
        return house;
    }

    public AcademyHouse remove(String id) {
        AcademyHouse house = this.houses.remove(id);
        if (house == null) {
            this.changes.put(id, null);
        }
        return house;
    }

    public Optional<AcademyHouse> getFor(UUID uuid) {
        for (AcademyHouse house : this.houses.values()) {
            if (!house.getPlayers().containsKey(uuid)) continue;
            return Optional.of(house);
        }
        return Optional.empty();
    }

    private void onJoin(class_3222 player) {
        LinkedHashMap<String, UpdateHousesS2CPacket.House> changes = new LinkedHashMap<String, UpdateHousesS2CPacket.House>();
        this.houses.forEach((id, house) -> changes.put((String)id, house.getFullPacket()));
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateHousesS2CPacket(null));
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateHousesS2CPacket(changes));
    }

    private void onTick(MinecraftServer server) {
        LinkedHashMap<String, UpdateHousesS2CPacket.House> changes = new LinkedHashMap<String, UpdateHousesS2CPacket.House>();
        this.houses.forEach((id, house) -> house.getChangesPacket().ifPresent(packet -> changes.put((String)id, (UpdateHousesS2CPacket.House)packet)));
        if (changes.isEmpty()) {
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateHousesS2CPacket(changes));
        }
        this.houses.values().forEach(AcademyHouse::clearChanges);
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2499 teams = new class_2499();
            for (AcademyHouse house : this.houses.values()) {
                Adapters.HOUSE.writeNbt(house).ifPresent(arg_0 -> teams.add(arg_0));
            }
            nbt.method_10566("houses", (class_2520)teams);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        class_2499 houses = nbt.method_10554("houses", 10);
        for (class_2520 team : houses) {
            Adapters.HOUSE.readNbt(team).ifPresent(house -> this.houses.put(house.getId(), (AcademyHouse)house));
        }
    }

    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            HouseData data = ModWorldData.HOUSE.getGlobal(player.method_37908());
            data.onJoin(player);
        });
        TickEvent.SERVER_POST.register(server -> {
            HouseData data = ModWorldData.HOUSE.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }
}

