/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data.save;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.net.UpdateCardGradingS2CPacket;
import abeshutt.staracademy.world.data.save.WorldData;
import com.google.gson.JsonObject;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class CardGradingData
extends WorldData {
    public static final CardGradingData CLIENT = new CardGradingData();
    private final Map<UUID, Entry> entries = new LinkedHashMap<UUID, Entry>();
    private final Set<UUID> changes = new HashSet<UUID>();

    public Map<UUID, Entry> getEntries() {
        return this.entries;
    }

    public boolean has(UUID uuid) {
        return this.entries.containsKey(uuid);
    }

    public void add(UUID uuid, class_1799 stack) {
        this.entries.put(uuid, new Entry(ZonedDateTime.now(ZoneId.of("UTC")).toInstant().toEpochMilli(), stack));
        this.changes.add(uuid);
        this.method_80();
    }

    public void remove(UUID uuid) {
        this.entries.remove(uuid);
        this.changes.add(uuid);
        this.method_80();
    }

    public long getTimeLeft(UUID uuid) {
        Entry entry = this.entries.get(uuid);
        if (entry == null) {
            return 0L;
        }
        long now = ZonedDateTime.now(ZoneId.of("UTC")).toInstant().toEpochMilli();
        return entry.time + (long)ModConfigs.NPC.getGradingTimeMillis() - now;
    }

    public class_1799 getStack(UUID uuid) {
        Entry entry = this.entries.get(uuid);
        if (entry == null) {
            return class_1799.field_8037;
        }
        return entry.stack;
    }

    private void onJoin(class_3222 player) {
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateCardGradingS2CPacket(null));
        Entry entry = this.entries.get(player.method_5667());
        if (entry != null) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateCardGradingS2CPacket(player.method_5667(), entry));
        }
    }

    public void onTick(MinecraftServer server) {
        for (UUID change : this.changes) {
            class_3222 player = server.method_3760().method_14602(change);
            if (player == null) continue;
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateCardGradingS2CPacket(player.method_5667(), this.entries.get(change)));
        }
        this.changes.clear();
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2487 entries = new class_2487();
            this.entries.forEach((uuid, entry) -> entry.writeNbt().ifPresent(tag -> entries.method_10566(uuid.toString(), (class_2520)tag)));
            nbt.method_10566("entries", (class_2520)entries);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.entries.clear();
        class_2487 entries = nbt.method_10562("entries");
        for (String key : entries.method_10541()) {
            Entry entry = new Entry();
            entry.readNbt(entries.method_10562(key));
            this.entries.put(UUID.fromString(key), entry);
        }
    }

    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            CardGradingData data = ModWorldData.CARD_GRADING.getGlobal(player.method_37908());
            data.onJoin(player);
        });
        TickEvent.SERVER_POST.register(server -> {
            CardGradingData data = ModWorldData.CARD_GRADING.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }

    public static class Entry
    implements ISerializable<class_2487, JsonObject> {
        private long time;
        private class_1799 stack;

        public Entry() {
        }

        public Entry(long time, class_1799 stack) {
            this.time = time;
            this.stack = stack;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.LONG.writeBits(this.time, buffer);
            Adapters.ITEM_STACK.writeBits(this.stack, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.time = (Long)Adapters.LONG.readBits(buffer).orElseThrow();
            this.stack = Adapters.ITEM_STACK.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<class_2487> writeNbt() {
            return Optional.of(new class_2487()).map(nbt -> {
                Adapters.LONG.writeNbt(this.time).ifPresent(tag -> nbt.method_10566("time", tag));
                Adapters.ITEM_STACK.writeNbt(this.stack).ifPresent(tag -> nbt.method_10566("stack", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.time = (Long)Adapters.LONG.readNbt(nbt.method_10580("time")).orElseThrow();
            this.stack = Adapters.ITEM_STACK.readNbt(nbt.method_10580("stack")).orElseThrow();
        }
    }
}

