/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data.save;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.net.UpdateArmorDisplayS2CPacket;
import abeshutt.staracademy.world.data.save.WorldData;
import com.google.gson.JsonObject;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class ArmorDisplayData
extends WorldData {
    public static final ArmorDisplayData CLIENT = new ArmorDisplayData();
    private final Map<UUID, Entry> entries = new LinkedHashMap<UUID, Entry>();

    public Map<UUID, Entry> getEntries() {
        return this.entries;
    }

    public boolean isHidden(UUID uuid, class_1304 slot) {
        Entry entry = this.entries.get(uuid);
        if (entry == null) {
            return false;
        }
        return entry.getHidden().contains(slot);
    }

    public void toggle(UUID uuid, class_1304 slot) {
        Entry entry = this.entries.computeIfAbsent(uuid, key -> new Entry());
        if (entry.getHidden().contains(slot)) {
            entry.getHidden().remove(slot);
        } else {
            entry.getHidden().add(slot);
        }
        entry.setDirty(true);
        this.method_80();
    }

    private void onJoin(class_3222 player) {
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateArmorDisplayS2CPacket(null));
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateArmorDisplayS2CPacket(this.entries));
    }

    public void onTick(MinecraftServer server) {
        HashMap<UUID, Entry> updated = new HashMap<UUID, Entry>();
        this.entries.forEach((uuid, entry) -> {
            if (entry.isDirty()) {
                updated.put((UUID)uuid, (Entry)entry);
                entry.setDirty(false);
            }
        });
        for (class_3222 player : server.method_3760().method_14571()) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new UpdateArmorDisplayS2CPacket(updated));
        }
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2487 entries = new class_2487();
            this.entries.forEach((uuid, entry) -> entry.writeNbt().ifPresent(tag -> entries.method_10566(uuid.toString(), (class_2520)tag)));
            nbt.method_10566("entries", (class_2520)entries);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.entries.clear();
        class_2487 entries = nbt.method_10562("entries");
        for (String key : entries.method_10541()) {
            Entry entry = new Entry();
            entry.readNbt(entries.method_10562(key));
            this.entries.put(UUID.fromString(key), entry);
        }
    }

    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            ArmorDisplayData data = ModWorldData.ARMOR_DISPLAY.getGlobal(player.method_37908());
            data.onJoin(player);
        });
        TickEvent.SERVER_POST.register(server -> {
            ArmorDisplayData data = ModWorldData.ARMOR_DISPLAY.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }

    public static class Entry
    implements ISerializable<class_2487, JsonObject> {
        private final Set<class_1304> hidden;
        private boolean dirty;

        public Entry() {
            this.hidden = new LinkedHashSet<class_1304>();
        }

        public Entry(Collection<class_1304> hidden) {
            this.hidden = new LinkedHashSet<class_1304>(hidden);
        }

        public Set<class_1304> getHidden() {
            return this.hidden;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_3.writeBits(this.hidden.size(), buffer);
            for (class_1304 slot : this.hidden) {
                Adapters.UTF_8.writeBits(slot.method_5923(), buffer);
            }
        }

        @Override
        public void readBits(BitBuffer buffer) {
            int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            this.hidden.clear();
            for (int i = 0; i < size; ++i) {
                this.hidden.add(class_1304.method_5924((String)Adapters.UTF_8.readBits(buffer).orElseThrow()));
            }
        }

        @Override
        public Optional<class_2487> writeNbt() {
            return Optional.of(new class_2487()).map(nbt -> {
                class_2499 hidden = new class_2499();
                for (class_1304 slot : this.hidden) {
                    Adapters.UTF_8.writeNbt(slot.method_5923()).ifPresent(arg_0 -> hidden.add(arg_0));
                }
                nbt.method_10566("hidden", (class_2520)hidden);
                return nbt;
            });
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.hidden.clear();
            class_2520 class_25202 = nbt.method_10580("hidden");
            if (class_25202 instanceof class_2499) {
                class_2499 options = (class_2499)class_25202;
                for (class_2520 option : options) {
                    Adapters.UTF_8.readNbt(option).map(class_1304::method_5924).ifPresent(this.hidden::add);
                }
            }
        }
    }
}

