/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data.save;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.world.data.save.WorldData;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class AcceptanceLetterData
extends WorldData {
    private final Map<UUID, Entry> entries = new LinkedHashMap<UUID, Entry>();

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2487 entries = new class_2487();
            this.entries.forEach((uuid, entry) -> entry.writeNbt().ifPresent(tag -> entries.method_10566(uuid.toString(), (class_2520)tag)));
            nbt.method_10566("entries", (class_2520)entries);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.entries.clear();
        class_2487 entries = nbt.method_10562("entries");
        for (String key : entries.method_10541()) {
            Entry entry = new Entry();
            entry.readNbt(entries.method_10562(key));
            this.entries.put(UUID.fromString(key), entry);
        }
    }

    public static class Entry
    implements ISerializable<class_2487, JsonObject> {
        private boolean open;
        private boolean accepted;
        private final Set<String> options;

        public Entry() {
            this.options = new LinkedHashSet<String>();
        }

        public Entry(Collection<String> options) {
            this.options = new LinkedHashSet<String>(options);
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.BOOLEAN.writeBits(this.open, buffer);
            Adapters.BOOLEAN.writeBits(this.accepted, buffer);
            Adapters.INT_SEGMENTED_3.writeBits(this.options.size(), buffer);
            for (String option : this.options) {
                Adapters.UTF_8.writeBits(option, buffer);
            }
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.open = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
            this.accepted = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
            int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            this.options.clear();
            for (int i = 0; i < size; ++i) {
                this.options.add(Adapters.UTF_8.readBits(buffer).orElseThrow());
            }
        }

        @Override
        public Optional<class_2487> writeNbt() {
            return Optional.of(new class_2487()).map(nbt -> {
                Adapters.BOOLEAN.writeNbt(this.open).ifPresent(tag -> nbt.method_10566("open", tag));
                Adapters.BOOLEAN.writeNbt(this.accepted).ifPresent(tag -> nbt.method_10566("accepted", tag));
                class_2499 options = new class_2499();
                for (String option : this.options) {
                    Adapters.UTF_8.writeNbt(option).ifPresent(arg_0 -> options.add(arg_0));
                }
                nbt.method_10566("options", (class_2520)options);
                return nbt;
            });
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.open = Adapters.BOOLEAN.readNbt(nbt.method_10580("open")).orElseThrow();
            this.accepted = Adapters.BOOLEAN.readNbt(nbt.method_10580("accepted")).orElseThrow();
            this.options.clear();
            class_2520 class_25202 = nbt.method_10580("options");
            if (class_25202 instanceof class_2499) {
                class_2499 options = (class_2499)class_25202;
                for (class_2520 option : options) {
                    Adapters.UTF_8.readNbt(option).ifPresent(this.options::add);
                }
            }
        }
    }
}

