/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.world.data.StarterPokemon;
import abeshutt.staracademy.world.data.save.PokemonStarterData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class StarterId
implements ISerializable<class_2487, JsonObject> {
    private final String category;
    private final int index;

    public StarterId(String category, int index) {
        this.category = category;
        this.index = index;
    }

    public String getCategory() {
        return this.category;
    }

    public int getIndex() {
        return this.index;
    }

    public Optional<StarterPokemon> resolve() {
        List<StarterPokemon> starters = PokemonStarterData.CLIENT.getStarters();
        for (StarterPokemon starter : starters) {
            if (!starter.getId().equals(this)) continue;
            return Optional.of(starter);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return this.category.hashCode() + this.index * 31;
    }

    public boolean equals(Object other) {
        if (other instanceof StarterId) {
            StarterId id = (StarterId)other;
            return this.index == id.index && this.category.equals(id.category);
        }
        return false;
    }

    public static class Adapter
    implements ISimpleAdapter<StarterId, class_2520, JsonElement> {
        private final boolean nullable;

        public Adapter(boolean nullable) {
            this.nullable = nullable;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public Adapter asNullable() {
            return new Adapter(true);
        }

        @Override
        public void writeBits(StarterId value, BitBuffer buffer) {
            if (this.nullable) {
                Adapters.BOOLEAN.writeBits(value == null, buffer);
            }
            if (value != null) {
                Adapters.UTF_8.writeBits(value.getCategory(), buffer);
                Adapters.INT_SEGMENTED_3.writeBits(value.getIndex(), buffer);
            }
        }

        @Override
        public Optional<StarterId> readBits(BitBuffer buffer) {
            if (this.nullable && Adapters.BOOLEAN.readBits(buffer).orElseThrow().booleanValue()) {
                return Optional.empty();
            }
            return Optional.of(new StarterId(Adapters.UTF_8.readBits(buffer).orElseThrow(), (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow()));
        }

        @Override
        public Optional<class_2520> writeNbt(StarterId value) {
            if (value == null) {
                return Optional.empty();
            }
            return Optional.of(new class_2487()).map(nbt -> {
                Adapters.UTF_8.writeNbt(value.getCategory()).ifPresent(tag -> nbt.method_10566("category", tag));
                Adapters.INT_SEGMENTED_3.writeNbt(value.getIndex()).ifPresent(tag -> nbt.method_10566("index", tag));
                return nbt;
            });
        }

        @Override
        public Optional<StarterId> readNbt(class_2520 nbt) {
            if (!(nbt instanceof class_2487)) {
                return Optional.empty();
            }
            class_2487 compound = (class_2487)nbt;
            return Optional.of(new StarterId(Adapters.UTF_8.readNbt(compound.method_10580("category")).orElseThrow(), (Integer)Adapters.INT_SEGMENTED_3.readNbt(compound.method_10580("index")).orElseThrow()));
        }
    }
}

