/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.serializable.ISerializable;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class StarOwnership
implements ISerializable<class_2487, JsonObject> {
    private final List<Entry> entries = new ArrayList<Entry>();

    public List<Entry> getEntries() {
        return this.entries;
    }

    public static Entry ofNow(UUID uuid) {
        long time = Instant.now().toEpochMilli();
        return new Entry(uuid, time);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.INT_SEGMENTED_3.writeBits(this.entries.size(), buffer);
        for (Entry entry : this.entries) {
            entry.writeBits(buffer);
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.entries.clear();
        for (int i = 0; i < size; ++i) {
            Entry entry = new Entry(null, 0L);
            entry.readBits(buffer);
            this.entries.add(entry);
        }
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2499 entries = new class_2499();
            for (Entry entry : this.entries) {
                entry.writeNbt().ifPresent(arg_0 -> entries.add(arg_0));
            }
            nbt.method_10566("entries", (class_2520)entries);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.entries.clear();
        class_2520 class_25202 = nbt.method_10580("entries");
        if (class_25202 instanceof class_2499) {
            class_2499 entries = (class_2499)class_25202;
            for (class_2520 element : entries) {
                if (!(element instanceof class_2487)) continue;
                class_2487 compound = (class_2487)element;
                Entry entry = new Entry(null, 0L);
                entry.readNbt(compound);
                this.entries.add(entry);
            }
        }
    }

    public static class Entry
    implements ISerializable<class_2487, JsonObject> {
        private UUID uuid;
        private long time;

        public Entry(UUID uuid, long time) {
            this.uuid = uuid;
            this.time = time;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public long getTime() {
            return this.time;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.UUID.writeBits(this.uuid, buffer);
            Adapters.LONG.writeBits(this.time, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.uuid = Adapters.UUID.readBits(buffer).orElseThrow();
            this.time = (Long)Adapters.LONG.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<class_2487> writeNbt() {
            return Optional.of(new class_2487()).map(nbt -> {
                Adapters.UUID.writeNbt(this.uuid).ifPresent(tag -> nbt.method_10566("uuid", tag));
                Adapters.LONG.writeNbt(this.time).ifPresent(tag -> nbt.method_10566("time", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(class_2487 nbt) {
            this.uuid = Adapters.UUID.readNbt(nbt.method_10580("uuid")).orElseThrow();
            this.time = (Long)Adapters.LONG.readNbt(nbt.method_10580("time")).orElseThrow();
        }
    }
}

