/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.serializable.ISerializable;
import com.cobblemon.mod.common.api.pokedex.AbstractPokedexManager;
import com.cobblemon.mod.common.api.pokedex.SpeciesDexRecord;
import com.cobblemon.mod.common.api.storage.player.InstancedPlayerData;
import com.cobblemon.mod.common.api.storage.player.client.ClientPokedexManager;
import com.cobblemon.mod.common.pokedex.scanner.PokedexEntityData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class HousePokedexManager
extends AbstractPokedexManager
implements InstancedPlayerData,
ISerializable<class_2487, JsonObject> {
    private UUID uuid;
    private Map<class_2960, SpeciesDexRecord> changes;

    public HousePokedexManager() {
        this(UUID.randomUUID());
    }

    public HousePokedexManager(UUID uuid) {
        this.uuid = uuid;
        this.changes = new LinkedHashMap<class_2960, SpeciesDexRecord>();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public Map<class_2960, SpeciesDexRecord> getChanges() {
        return this.changes;
    }

    public void clearChanges() {
        this.changes.clear();
    }

    public void initialize() {
        this.getSpeciesRecords().forEach((identifier, speciesDexRecord) -> speciesDexRecord.initialize((AbstractPokedexManager)this, identifier));
    }

    public void onSpeciesRecordUpdated(SpeciesDexRecord record) {
        super.onSpeciesRecordUpdated(record);
        this.changes.put(record.getId(), record);
    }

    public void onEncounter(Pokemon pokemon) {
        class_2960 speciesId = pokemon.getSpecies().resourceIdentifier;
        String formName = pokemon.getForm().getName();
        this.getOrCreateSpeciesRecord(speciesId).getOrCreateFormRecord(formName).encountered(new PokedexEntityData(pokemon, null));
        this.onSpeciesRecordUpdated(this.getSpeciesRecord(speciesId));
    }

    public void onEncounter(PokedexEntityData data) {
        class_2960 speciesId = data.getApparentSpecies().resourceIdentifier;
        String formName = data.getApparentForm().getName();
        this.getOrCreateSpeciesRecord(speciesId).getOrCreateFormRecord(formName).encountered(data);
        this.onSpeciesRecordUpdated(this.getSpeciesRecord(speciesId));
    }

    public void onCapture(Pokemon pokemon) {
        class_2960 speciesId = pokemon.getSpecies().resourceIdentifier;
        String formName = pokemon.getForm().getName();
        this.getOrCreateSpeciesRecord(speciesId).getOrCreateFormRecord(formName).caught(new PokedexEntityData(pokemon, null));
        this.onSpeciesRecordUpdated(this.getSpeciesRecord(speciesId));
    }

    public ClientPokedexManager toClientData() {
        LinkedHashMap copied = new LinkedHashMap();
        this.getSpeciesRecords().forEach((id, record) -> copied.put(id, record.clone()));
        return new ClientPokedexManager(copied);
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            Adapters.UUID.writeNbt(this.uuid).ifPresent(tag -> nbt.method_10566("uuid", tag));
            class_2487 records = new class_2487();
            this.getSpeciesRecords().forEach((id, record) -> Adapters.SPECIES_DEX_RECORD.writeNbt((SpeciesDexRecord)record, this).ifPresent(tag -> records.method_10566(id.toString(), (class_2520)tag)));
            nbt.method_10566("records", (class_2520)records);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.uuid = Adapters.UUID.readNbt(nbt.method_10580("uuid")).orElseThrow();
        this.getSpeciesRecords().clear();
        class_2487 records = nbt.method_10562("records");
        for (String key : records.method_10541()) {
            Adapters.SPECIES_DEX_RECORD.readNbt(records.method_10562(key), this).ifPresent(record -> this.getSpeciesRecords().put(class_2960.method_12829((String)key), record));
        }
    }
}

