/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.net.UpdateHousesS2CPacket;
import abeshutt.staracademy.world.data.HousePlayer;
import abeshutt.staracademy.world.data.HousePokedexManager;
import com.cobblemon.mod.common.api.pokedex.SpeciesDexRecord;
import com.google.gson.JsonObject;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class AcademyHouse
implements ISerializable<class_2487, JsonObject> {
    private String id;
    private String name;
    private int color;
    private final Map<UUID, HousePlayer> players;
    private HousePokedexManager pokedex;
    private boolean propertiesDirty;
    private final Map<UUID, HousePlayer> playerChanges;

    public AcademyHouse() {
        this(null);
    }

    public AcademyHouse(String id) {
        this.id = id;
        this.players = new LinkedHashMap<UUID, HousePlayer>();
        this.pokedex = new HousePokedexManager();
        this.name = "Unknown";
        this.color = 0xFFFFFF;
        this.propertiesDirty = false;
        this.playerChanges = new LinkedHashMap<UUID, HousePlayer>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean setName(String name) {
        this.name = name;
        if (!this.name.equals(this.name)) {
            this.propertiesDirty = true;
            return true;
        }
        return false;
    }

    public int getColor() {
        return this.color;
    }

    public boolean setColor(int color) {
        this.color = color;
        if (this.color != this.color) {
            this.propertiesDirty = true;
            return true;
        }
        return false;
    }

    public Map<UUID, HousePlayer> getPlayers() {
        return this.players;
    }

    public HousePokedexManager getPokedex() {
        return this.pokedex;
    }

    public boolean addPlayer(UUID uuid) {
        if (this.players.containsKey(uuid)) {
            return false;
        }
        long time = ZonedDateTime.now(ZoneId.of("UTC")).toInstant().toEpochMilli();
        HousePlayer housePlayer = new HousePlayer(uuid, time);
        this.players.put(housePlayer.getUuid(), housePlayer);
        this.playerChanges.put(uuid, housePlayer);
        return true;
    }

    public boolean removePlayer(UUID uuid) {
        if (!this.players.containsKey(uuid)) {
            return false;
        }
        this.players.remove(uuid);
        this.playerChanges.put(uuid, null);
        return true;
    }

    public UpdateHousesS2CPacket.House getFullPacket() {
        UpdateHousesS2CPacket.House payload = new UpdateHousesS2CPacket.House();
        payload.name = this.name;
        payload.color = this.color;
        payload.players = new LinkedHashMap<UUID, HousePlayer>(this.players);
        payload.pokedex = new LinkedHashMap<class_2960, SpeciesDexRecord>(this.pokedex.getSpeciesRecords());
        return payload;
    }

    public Optional<UpdateHousesS2CPacket.House> getChangesPacket() {
        if (!this.propertiesDirty && this.playerChanges.isEmpty() && this.pokedex.getChanges().isEmpty()) {
            return Optional.empty();
        }
        UpdateHousesS2CPacket.House payload = new UpdateHousesS2CPacket.House();
        payload.name = this.name;
        payload.color = this.color;
        payload.players = new LinkedHashMap<UUID, HousePlayer>(this.playerChanges);
        payload.pokedex = new LinkedHashMap<class_2960, SpeciesDexRecord>(this.pokedex.getChanges());
        return Optional.of(payload);
    }

    public void clearChanges() {
        this.propertiesDirty = false;
        this.playerChanges.clear();
        this.pokedex.clearChanges();
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            Adapters.UTF_8.writeNbt(this.id).ifPresent(tag -> nbt.method_10566("id", tag));
            Adapters.UTF_8.writeNbt(this.name).ifPresent(tag -> nbt.method_10566("name", tag));
            Adapters.INT.writeNbt(this.color).ifPresent(tag -> nbt.method_10566("color", tag));
            class_2499 players = new class_2499();
            for (HousePlayer entry : this.players.values()) {
                Adapters.HOUSE_PLAYER.writeNbt(entry).ifPresent(arg_0 -> players.add(arg_0));
            }
            nbt.method_10566("players", (class_2520)players);
            Adapters.HOUSE_POKEDEX_MANAGER.writeNbt(this.pokedex).ifPresent(tag -> nbt.method_10566("pokedex", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.id = Adapters.UTF_8.readNbt(nbt.method_10580("id")).orElseThrow();
        this.name = Adapters.UTF_8.readNbt(nbt.method_10580("name")).orElseThrow();
        this.color = (Integer)Adapters.INT.readNbt(nbt.method_10580("color")).orElseThrow();
        this.players.clear();
        class_2499 players = nbt.method_10554("players", 10);
        for (class_2520 player : players) {
            Adapters.HOUSE_PLAYER.readNbt(player).ifPresent(entry -> this.players.put(entry.getUuid(), (HousePlayer)entry));
        }
        this.pokedex = Adapters.HOUSE_POKEDEX_MANAGER.readNbt(nbt.method_10580("pokedex")).orElseGet(HousePokedexManager::new);
        this.pokedex.initialize();
    }
}

