/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.util;

import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_4076;

public class FastBlockCheck {
    public static final DistanceCheck EUCLIDEAN_DISTANCE = class_2382::method_19771;
    public static final DistanceCheck MANHATTAN_DISTANCE = (origin, currentPos, radius) -> origin.method_19455((class_2382)currentPos) <= radius;

    public static boolean findBlockFastEuclideanDistance(int radius, boolean forceChunkLoads, class_1937 world, class_2338 origin, Predicate<class_2680> stateTest) {
        return FastBlockCheck.countBlocksFast(radius, Integer.MAX_VALUE, forceChunkLoads, world, origin, stateTest, EUCLIDEAN_DISTANCE) > 0;
    }

    public static boolean findBlockFastManhattanDistance(int radius, boolean forceChunkLoads, class_1937 world, class_2338 origin, Predicate<class_2680> stateTest) {
        return FastBlockCheck.countBlocksFast(radius, Integer.MAX_VALUE, forceChunkLoads, world, origin, stateTest, MANHATTAN_DISTANCE) > 0;
    }

    public static int countBlocksFast(int radius, int maxCount, boolean forceChunkLoads, class_1937 world, class_2338 origin, Predicate<class_2680> stateTest, DistanceCheck distanceCheck) {
        int hits = 0;
        int minChunkX = class_4076.method_18675((int)(origin.method_10263() - radius));
        int minChunkZ = class_4076.method_18675((int)(origin.method_10260() - radius));
        int maxChunkX = class_4076.method_18675((int)(origin.method_10263() + radius));
        int maxChunkZ = class_4076.method_18675((int)(origin.method_10260() + radius));
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                if (forceChunkLoads && !world.method_8393(chunkX, chunkZ)) continue;
                class_2818 chunk = world.method_8497(chunkX, chunkZ);
                int minSectionIDX = chunk.method_31602(origin.method_10264() - radius);
                int maxSectionIDX = chunk.method_31602(origin.method_10264() + radius);
                for (int sectionIDX = minSectionIDX; sectionIDX <= maxSectionIDX; ++sectionIDX) {
                    class_2826 section = chunk.method_38259(sectionIDX);
                    if (section == null || section.method_38292()) continue;
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            for (int z = 0; z < 16; ++z) {
                                class_2680 state;
                                mutable.method_10103(class_4076.method_32205((int)chunkX, (int)x), class_4076.method_32205((int)chunk.method_31604(sectionIDX), (int)x), class_4076.method_32205((int)chunkZ, (int)z));
                                if (!distanceCheck.test(origin, (class_2338)mutable, radius) || !stateTest.test(state = section.method_12254(x, y, z)) || ++hits < maxCount) continue;
                                return hits;
                            }
                        }
                    }
                }
            }
        }
        return hits;
    }

    @FunctionalInterface
    public static interface DistanceCheck {
        public boolean test(class_2338 var1, class_2338 var2, int var3);
    }
}

