/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.util;

import java.util.ArrayList;
import java.util.List;
import org.joml.Math;
import oshi.util.tuples.Pair;

public class ColorBlender {
    private final float speed;
    private final List<Pair<Integer, Float>> sequence = new ArrayList<Pair<Integer, Float>>();
    private float totalTime;

    public ColorBlender(float speed) {
        this.speed = speed;
    }

    public ColorBlender add(int color, float interval) {
        this.sequence.add((Pair<Integer, Float>)new Pair((Object)color, (Object)Float.valueOf(interval)));
        this.totalTime += interval;
        return this;
    }

    public int getColor(double time) {
        if (this.totalTime == 0.0f) {
            return 0xFFFFFF;
        }
        double value = time * (double)this.speed % (double)this.totalTime;
        double ratio = 0.0;
        int color1 = 0;
        int color2 = 0;
        for (int j = 0; j < this.sequence.size(); ++j) {
            Pair<Integer, Float> pair = this.sequence.get(j);
            int color = (Integer)pair.getA();
            float interval = ((Float)pair.getB()).floatValue();
            if (value < (double)interval) {
                color1 = color;
                color2 = (Integer)this.sequence.get((j + 1) % this.sequence.size()).getA();
                ratio = value / (double)interval;
                break;
            }
            value -= (double)interval;
        }
        return ColorBlender.blendColors(color2, color1, ratio);
    }

    public static int blendColors(int color1, int color2, double color1Ratio) {
        double ratio1 = Math.clamp((double)color1Ratio, (double)0.0, (double)1.0);
        double ratio2 = 1.0 - ratio1;
        int a1 = (color1 & 0xFF000000) >> 24;
        int r1 = (color1 & 0xFF0000) >> 16;
        int g1 = (color1 & 0xFF00) >> 8;
        int b1 = color1 & 0xFF;
        int a2 = (color2 & 0xFF000000) >> 24;
        int r2 = (color2 & 0xFF0000) >> 16;
        int g2 = (color2 & 0xFF00) >> 8;
        int b2 = color2 & 0xFF;
        int a = Math.clamp((int)((int)Math.round((double)((double)a1 * ratio1 + (double)a2 * ratio2))), (int)0, (int)255);
        int r = Math.clamp((int)((int)Math.round((double)((double)r1 * ratio1 + (double)r2 * ratio2))), (int)0, (int)255);
        int g = Math.clamp((int)((int)Math.round((double)((double)g1 * ratio1 + (double)g2 * ratio2))), (int)0, (int)255);
        int b = Math.clamp((int)((int)Math.round((double)((double)b1 * ratio1 + (double)b2 * ratio2))), (int)0, (int)255);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

