/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.screen;

import abeshutt.staracademy.screen.EntriesScrollingWidget;
import abeshutt.staracademy.screen.InfoWidget;
import com.bedrockk.molang.runtime.MoLangRuntime;
import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.api.pokedex.AbstractPokedexManager;
import com.cobblemon.mod.common.api.pokedex.CaughtCount;
import com.cobblemon.mod.common.api.pokedex.Dexes;
import com.cobblemon.mod.common.api.pokedex.PokedexValueCalculator;
import com.cobblemon.mod.common.api.pokedex.SeenCount;
import com.cobblemon.mod.common.api.pokedex.def.PokedexDef;
import com.cobblemon.mod.common.api.pokedex.entry.PokedexEntry;
import com.cobblemon.mod.common.api.pokedex.entry.PokedexForm;
import com.cobblemon.mod.common.api.pokedex.filter.EntryFilter;
import com.cobblemon.mod.common.api.pokedex.filter.SearchByType;
import com.cobblemon.mod.common.api.pokedex.filter.SearchFilter;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.ClientMoLangFunctions;
import com.cobblemon.mod.common.client.CobblemonResources;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.gui.pokedex.ScaledButton;
import com.cobblemon.mod.common.client.gui.pokedex.widgets.AbilitiesWidget;
import com.cobblemon.mod.common.client.gui.pokedex.widgets.DescriptionWidget;
import com.cobblemon.mod.common.client.gui.pokedex.widgets.DropsScrollingWidget;
import com.cobblemon.mod.common.client.gui.pokedex.widgets.SearchWidget;
import com.cobblemon.mod.common.client.gui.pokedex.widgets.SizeWidget;
import com.cobblemon.mod.common.client.gui.pokedex.widgets.StatsWidget;
import com.cobblemon.mod.common.client.pokedex.PokedexType;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.net.messages.server.block.AdjustBlockEntityViewerCountPacket;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.pokemon.abilities.HiddenAbility;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import org.apache.commons.lang3.stream.Streams;

public class PokedexScreen
extends class_437
implements CobblemonRenderable {
    private static final class_2960 BACKGROUND = MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/pokedex_screen.png");
    private static final class_2960 GLOBE_ICON = MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/globe_icon.png");
    private static final class_2960 CAUGHT_SEEN_ICON = MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/caught_seen_icon.png");
    private static final class_2960 ARROW_UP_ICON = MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/arrow_up.png");
    private static final class_2960 ARROW_DOWN_ICON = MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/arrow_down.png");
    private static final class_2960 TOOLTIP_EDGE = MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/tooltip_edge.png");
    private static final class_2960 TOOLTIP_BACKGROUND = MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/tooltip_background.png");
    private static final class_2960 TAB_SELECT_ARROW = MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/select_arrow.png");
    private static final class_2960[] TAB_ICONS = new class_2960[]{MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/tab_info.png"), MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/tab_abilities.png"), MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/tab_size.png"), MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/tab_stats.png"), MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/tab_drops.png")};
    private final AbstractPokedexManager pokedex;
    private final PokedexType type;
    private final class_2960 initSpecies;
    private final class_2338 blockPos;
    private double oldDragPosX;
    private boolean canDragRender = false;
    private Collection<PokedexDef> filteredPokedex = new ArrayList<PokedexDef>();
    private String seenCount = "0000";
    private String ownedCount = "0000";
    private final MoLangRuntime runtime = MoLangFunctions.INSTANCE.setup(ClientMoLangFunctions.INSTANCE.setupClient(new MoLangRuntime()));
    private PokedexEntry selectedEntry;
    private PokedexForm selectedForm;
    private List<class_2960> availableRegions = new ArrayList<class_2960>();
    private int selectedRegionIndex = 0;
    private ScaledButton regionSelectWidgetUp;
    private ScaledButton regionSelectWidgetDown;
    private ScaledButton searchByTypeButton;
    private EntriesScrollingWidget scrollScreen;
    private InfoWidget pokemonInfoWidget;
    private SearchWidget searchWidget;
    private SearchByType selectedSearchByType = SearchByType.SPECIES;
    private final List<ScaledButton> tabButtons = new ArrayList<ScaledButton>();
    private class_364 tabInfoElement;
    private int tabInfoIndex = 0;

    public PokedexScreen(AbstractPokedexManager pokedex, PokedexType type, class_2960 initSpecies, class_2338 blockPos) {
        super((class_2561)class_2561.method_43471((String)"cobblemon.ui.pokedex.title"));
        this.pokedex = pokedex;
        this.type = type;
        this.initSpecies = initSpecies;
        this.blockPos = blockPos;
        this.runtime.getEnvironment().query.addFunction("get_pokedex", params -> this.pokedex.getStruct());
    }

    public static void open(AbstractPokedexManager manager, PokedexType type, class_2960 species, class_2338 blockPos) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)CobblemonSounds.POKEDEX_OPEN, (float)1.0f));
        class_310.method_1551().method_1507((class_437)new PokedexScreen(manager, type, species, blockPos));
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.availableRegions = new ArrayList(Dexes.INSTANCE.getDexEntryMap().keySet());
        this.selectedRegionIndex = 0;
        int ownedAmount = (Integer)this.pokedex.getDexCalculatedValue(MiscUtilsKt.cobblemonResource((String)"national"), (PokedexValueCalculator)CaughtCount.INSTANCE);
        this.ownedCount = String.format("%04d", ownedAmount);
        int seenAmount = (Integer)this.pokedex.getDexCalculatedValue(MiscUtilsKt.cobblemonResource((String)"national"), (PokedexValueCalculator)SeenCount.INSTANCE);
        this.seenCount = String.format("%04d", seenAmount);
        int x = (this.field_22789 - 345) / 2;
        int y = (this.field_22790 - 207) / 2;
        if (this.pokemonInfoWidget != null) {
            this.method_37066((class_364)this.pokemonInfoWidget);
        }
        this.pokemonInfoWidget = new InfoWidget(this.pokedex, x + 180, y + 28, pokedexForm -> {
            this.updateSelectedForm((PokedexForm)pokedexForm);
            return Unit.INSTANCE;
        });
        this.method_37063((class_364)this.pokemonInfoWidget);
        this.setUpTabs();
        this.displaytabInfoElement(this.tabInfoIndex, false);
        if (this.searchWidget != null) {
            this.method_37066((class_364)this.searchWidget);
        }
        this.searchWidget = new SearchWidget((Number)(x + 26), (Number)(y + 28), 128, 11, (class_2561)TextKt.text((String)"Search"), () -> {
            this.updateFilters();
            return Unit.INSTANCE;
        });
        this.method_37063((class_364)this.searchWidget);
        if (this.regionSelectWidgetUp != null) {
            this.method_37066((class_364)this.regionSelectWidgetUp);
        }
        this.regionSelectWidgetUp = new ScaledButton((float)(x + 95), (float)((double)y + 14.5), (Number)8, (Number)6, ARROW_UP_ICON, 0.5f, false, button -> this.updatePokedexRegion(false));
        this.method_37063((class_364)this.regionSelectWidgetUp);
        if (this.regionSelectWidgetDown != null) {
            this.method_37066((class_364)this.regionSelectWidgetDown);
        }
        this.regionSelectWidgetDown = new ScaledButton((float)(x + 95), (float)((double)y + 19.5), (Number)8, (Number)6, ARROW_DOWN_ICON, 0.5f, false, button -> this.updatePokedexRegion(true));
        this.method_37063((class_364)this.regionSelectWidgetDown);
        if (this.searchByTypeButton != null) {
            this.method_37066((class_364)this.searchByTypeButton);
        }
        this.searchByTypeButton = new ScaledButton((float)((double)x + 154.5), (float)((double)y + 29.5), (Number)16, (Number)16, MiscUtilsKt.cobblemonResource((String)("textures/gui/pokedex/tab_" + this.selectedSearchByType.name().toLowerCase(Locale.ROOT) + ".png")), 0.5f, false, button -> {
            List<SearchByType> types = Arrays.asList(SearchByType.values());
            int index = types.indexOf(this.selectedSearchByType);
            this.selectedSearchByType = types.get((index + 1) % types.size());
            this.searchByTypeButton.setResource(MiscUtilsKt.cobblemonResource((String)("textures/gui/pokedex/tab_" + this.selectedSearchByType.name().toLowerCase(Locale.ROOT) + ".png")));
            this.updateFilters();
        });
        this.method_37063((class_364)this.searchByTypeButton);
        this.updateFilters(true);
    }

    protected void method_57734(float delta) {
    }

    protected void method_57736(class_332 context, int x, int y, int width, int height) {
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrices = context.method_51448();
        this.method_25420(context, mouseX, mouseY, delta);
        int x = (this.field_22789 - 345) / 2;
        int y = (this.field_22790 - 207) / 2;
        GuiUtilsKt.blitk((class_4587)matrices, (class_2960)this.type.getTexturePath(), (Number)x, (Number)y, (Number)207, (Number)345);
        GuiUtilsKt.blitk((class_4587)matrices, (class_2960)BACKGROUND, (Number)x, (Number)y, (Number)207, (Number)345);
        GuiUtilsKt.blitk((class_4587)matrices, (class_2960)GLOBE_ICON, (Number)Float.valueOf((float)(x + 26) / 0.5f), (Number)Float.valueOf((float)(y + 15) / 0.5f), (Number)14, (Number)14, (Number)0, (Number)0, (Number)14, (Number)14, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)true, (float)0.5f);
        RenderHelperKt.drawScaledText((class_332)context, (class_2960)CobblemonResources.INSTANCE.getDEFAULT_LARGE(), (class_5250)class_2561.method_43471((String)("cobblemon.ui.pokedex.region." + this.availableRegions.get(this.selectedRegionIndex).method_12832())).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))), (Number)(x + 36), (Number)(y + 14), (float)1.0f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)-1, (boolean)false, (boolean)true, null, null);
        GuiUtilsKt.blitk((class_4587)matrices, (class_2960)CAUGHT_SEEN_ICON, (Number)Float.valueOf((float)(x + 252) / 0.5f), (Number)Float.valueOf((float)(y + 15) / 0.5f), (Number)14, (Number)14, (Number)0, (Number)0, (Number)14, (Number)28, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)true, (float)0.5f);
        GuiUtilsKt.blitk((class_4587)matrices, (class_2960)CAUGHT_SEEN_ICON, (Number)Float.valueOf((float)(x + 290) / 0.5f), (Number)Float.valueOf((float)(y + 15) / 0.5f), (Number)14, (Number)14, (Number)0, (Number)14, (Number)14, (Number)28, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)true, (float)0.5f);
        RenderHelperKt.drawScaledText((class_332)context, (class_2960)CobblemonResources.INSTANCE.getDEFAULT_LARGE(), (class_5250)TextKt.bold((class_5250)TextKt.text((String)this.seenCount)), (Number)(x + 262), (Number)(y + 14), (float)1.0f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)-1, (boolean)false, (boolean)true, null, null);
        RenderHelperKt.drawScaledText((class_332)context, (class_2960)CobblemonResources.INSTANCE.getDEFAULT_LARGE(), (class_5250)TextKt.bold((class_5250)TextKt.text((String)this.ownedCount)), (Number)(x += 300), (Number)(y += 14), (float)1.0f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)-1, (boolean)false, (boolean)true, null, null);
        if (this.selectedEntry != null && this.pokedex.getCaughtForms(this.selectedEntry).contains(this.selectedForm)) {
            GuiUtilsKt.blitk((class_4587)matrices, (class_2960)TAB_SELECT_ARROW, (Number)Float.valueOf((float)(x + 198 + 25 * this.tabInfoIndex) / 0.5f), (Number)Float.valueOf((float)(y + 177) / 0.5f), (Number)6, (Number)12, (Number)0, (Number)14, (Number)12, (Number)6, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)true, (float)0.5f);
        }
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.searchByTypeButton.isButtonHovered((Number)mouseX, (Number)mouseY)) {
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 1000.0);
            class_5250 searchTypeText = LocalizationUtilsKt.lang((String)"ui.pokedex.search.search_by", (Object[])new Object[]{LocalizationUtilsKt.lang((String)("ui.pokedex.search.type." + this.selectedSearchByType.name().toLowerCase()), (Object[])new Object[0])});
            searchTypeText.method_10862(searchTypeText.method_10866().method_10982(Boolean.valueOf(true)));
            int searchTypeTextWidth = class_310.method_1551().field_1772.method_27525((class_5348)searchTypeText.method_10862(searchTypeText.method_10866().method_27704(CobblemonResources.INSTANCE.getDEFAULT_LARGE())));
            int tooltipWidth = searchTypeTextWidth + 6;
            GuiUtilsKt.blitk((class_4587)matrices, (class_2960)TOOLTIP_EDGE, (Number)(mouseX - tooltipWidth / 2 - 1), (Number)(mouseY - 16), (Number)11, (Number)1);
            GuiUtilsKt.blitk((class_4587)matrices, (class_2960)TOOLTIP_BACKGROUND, (Number)(mouseX - tooltipWidth / 2), (Number)(mouseY - 16), (Number)11, (Number)tooltipWidth);
            GuiUtilsKt.blitk((class_4587)matrices, (class_2960)TOOLTIP_EDGE, (Number)(mouseX + tooltipWidth / 2), (Number)(mouseY - 16), (Number)11, (Number)1);
            RenderHelperKt.drawScaledText((class_332)context, (class_2960)CobblemonResources.INSTANCE.getDEFAULT_LARGE(), (class_5250)searchTypeText, (Number)mouseX, (Number)(mouseY - 15), (float)1.0f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)-1, (boolean)true, (boolean)true, null, null);
            matrices.method_22909();
        }
    }

    public void method_25419() {
        if (this.blockPos != null) {
            new AdjustBlockEntityViewerCountPacket(this.blockPos, false).sendToServer();
        }
        this.playSound(CobblemonSounds.POKEDEX_CLOSE);
        super.method_25419();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean canDisplayEntry = true;
        if (this.pokemonInfoWidget != null && this.pokemonInfoWidget.isWithinPortraitSpace(mouseX, mouseY) && canDisplayEntry) {
            this.canDragRender = true;
            this.method_25398(true);
            this.oldDragPosX = mouseX;
            this.playSound(CobblemonSounds.POKEDEX_CLICK_SHORT);
        }
        try {
            return super.method_25402(mouseX, mouseY, button);
        }
        catch (ConcurrentModificationException e) {
            return false;
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.canDragRender = false;
        this.method_25398(false);
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.method_25397() && this.canDragRender) {
            float dragOffsetY = (float)(this.oldDragPosX - mouseX);
            this.pokemonInfoWidget.rotationY = ((this.pokemonInfoWidget.rotationY + dragOffsetY) % 360.0f + 360.0f) % 360.0f;
        }
        this.oldDragPosX = mouseX;
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void method_25393() {
        if (this.pokemonInfoWidget != null) {
            this.pokemonInfoWidget.tick();
        }
    }

    public void updatePokedexRegion(Boolean nextIndex) {
        this.selectedRegionIndex = nextIndex != null ? (this.selectedRegionIndex < this.availableRegions.size() - 1 ? ++this.selectedRegionIndex : 0) : (this.selectedRegionIndex > 0 ? --this.selectedRegionIndex : this.availableRegions.size() - 1);
        this.updateFilters();
    }

    public void updateFilters() {
        this.updateFilters(false);
    }

    public void updateFilters(Boolean init) {
        int x = (this.field_22789 - 345) / 2;
        int y = (this.field_22790 - 207) / 2;
        this.filteredPokedex = CollectionsKt.listOfNotNull((PokedexDef)Dexes.INSTANCE.getDexEntryMap().get(this.availableRegions.get(this.selectedRegionIndex)));
        if (this.scrollScreen != null) {
            this.method_37066((class_364)this.scrollScreen);
        }
        this.scrollScreen = new EntriesScrollingWidget(this.pokedex, x + 26, y + 39, pokedexEntry -> {
            this.setSelectedEntry((PokedexEntry)pokedexEntry);
            return Unit.INSTANCE;
        });
        Stream<Object> entries = this.filteredPokedex.stream().flatMap(pokedexDef -> pokedexDef.getEntries().stream());
        if (Cobblemon.config.getHideUnimplementedPokemonInThePokedex()) {
            entries = entries.filter(entry -> {
                Species species = PokemonSpecies.INSTANCE.getByIdentifier(entry.getSpeciesId());
                return species != null && species.getImplemented();
            });
        }
        for (EntryFilter filter : this.getFilters()) {
            entries = entries.filter(arg_0 -> ((EntryFilter)filter).test(arg_0));
        }
        List<PokedexEntry> entriesList = entries.collect(Collectors.toList());
        this.scrollScreen.createEntries(entriesList);
        this.method_37063((class_364)this.scrollScreen);
        if (!entriesList.isEmpty()) {
            if (init.booleanValue() && this.initSpecies != null) {
                PokedexEntry entry2 = entriesList.stream().filter(pokedexEntry -> pokedexEntry.getSpeciesId().equals((Object)this.initSpecies)).findFirst().orElse(null);
                if (entry2 == null) {
                    entry2 = entriesList.getFirst();
                }
                this.setSelectedEntry(entry2);
                this.scrollScreen.method_25307((double)entriesList.indexOf(entry2) / (double)entriesList.size() * (double)this.scrollScreen.method_25331());
            } else {
                this.setSelectedEntry(entriesList.getFirst());
            }
        }
    }

    public Collection<EntryFilter> getFilters() {
        ArrayList<EntryFilter> filters = new ArrayList<EntryFilter>();
        filters.add((EntryFilter)new SearchFilter(this.pokedex, this.searchWidget.method_1882(), this.selectedSearchByType));
        return filters;
    }

    public void setSelectedEntry(PokedexEntry newSelectedEntry) {
        this.selectedEntry = newSelectedEntry;
        List forms = this.pokedex.getEncounteredForms(newSelectedEntry);
        this.selectedForm = forms.isEmpty() ? null : (PokedexForm)forms.getFirst();
        this.pokemonInfoWidget.setDexEntry(this.selectedEntry);
        this.displaytabInfoElement(this.tabInfoIndex);
    }

    public void setUpTabs() {
        int x = (this.field_22789 - 345) / 2;
        int y = (this.field_22790 - 207) / 2;
        if (!this.tabButtons.isEmpty()) {
            this.tabButtons.clear();
        }
        for (int i = 0; i < TAB_ICONS.length; ++i) {
            int finalI = i;
            this.tabButtons.add(new ScaledButton((float)x + 197.0f + (float)i * 25.0f, (float)y + 181.5f, (Number)16, (Number)16, TAB_ICONS[i], 0.5f, false, button -> {
                if (this.canSelectTab(finalI)) {
                    this.displaytabInfoElement(finalI);
                }
            }));
        }
        for (ScaledButton tab : this.tabButtons) {
            this.method_37063((class_364)tab);
        }
    }

    public void displaytabInfoElement(Integer tabIndex) {
        this.displaytabInfoElement(tabIndex, true);
    }

    public void displaytabInfoElement(Integer tabIndex, Boolean update) {
        class_364 tab;
        boolean showActiveTab;
        boolean bl = showActiveTab = this.selectedEntry != null && this.pokedex.getCaughtForms(this.selectedEntry).contains(this.selectedForm);
        if (!this.tabButtons.isEmpty() && this.tabButtons.size() > tabIndex) {
            for (int i = 0; i < this.tabButtons.size(); ++i) {
                tab = this.tabButtons.get(i);
                tab.setWidgetActive(showActiveTab && i == tabIndex);
            }
        }
        if (this.tabInfoIndex == 1 && (tab = this.tabInfoElement) instanceof AbilitiesWidget) {
            AbilitiesWidget abilities = (AbilitiesWidget)tab;
            this.method_37066((class_364)abilities.getLeftButton());
            this.method_37066((class_364)abilities.getRightButton());
        }
        this.tabInfoIndex = tabIndex;
        if (this.tabInfoElement != null) {
            this.method_37066(this.tabInfoElement);
        }
        int x = (this.field_22789 - 345) / 2;
        int y = (this.field_22790 - 207) / 2;
        switch (tabIndex) {
            case 0: {
                this.tabInfoElement = new DescriptionWidget(x + 180, y + 135);
                break;
            }
            case 1: {
                this.tabInfoElement = new AbilitiesWidget(x + 180, y + 135);
                break;
            }
            case 2: {
                this.tabInfoElement = new SizeWidget(x + 180, y + 135);
                break;
            }
            case 3: {
                this.tabInfoElement = new StatsWidget(x + 180, y + 135);
                break;
            }
            case 4: {
                this.tabInfoElement = new DropsScrollingWidget(x + 189, y + 135);
            }
        }
        class_364 element = this.tabInfoElement;
        if (element instanceof class_4068 && element instanceof class_6379) {
            this.method_37063((class_364)this.cast(element));
        }
        if (update.booleanValue()) {
            this.updateTabInfoElement();
        }
    }

    public void updateTabInfoElement() {
        class_364 class_3642;
        ArrayList textToShowInDescription;
        block13: {
            block12: {
                Species species = this.selectedEntry != null ? PokemonSpecies.INSTANCE.getByIdentifier(this.selectedEntry.getSpeciesId()) : null;
                String formName = this.selectedForm != null ? this.selectedForm.getDisplayForm() : null;
                boolean canDisplay = this.selectedEntry != null && this.pokedex.getCaughtForms(this.selectedEntry).contains(this.selectedForm);
                textToShowInDescription = new ArrayList();
                if (!canDisplay || species == null) break block12;
                FormData form = species.getForms().stream().filter(f -> f.getName().equalsIgnoreCase(formName)).findFirst().orElse(species.getStandardForm());
                switch (this.tabInfoIndex) {
                    case 0: {
                        textToShowInDescription.addAll(form.getPokedex());
                        ((DescriptionWidget)this.tabInfoElement).setShowPlaceholder(false);
                        break;
                    }
                    case 1: {
                        class_364 class_3643 = this.tabInfoElement;
                        if (class_3643 instanceof AbilitiesWidget) {
                            AbilitiesWidget abilities = (AbilitiesWidget)class_3643;
                            abilities.setAbilitiesList(Streams.of((Iterable)form.getAbilities()).sorted(Comparator.comparing(a -> !(a instanceof HiddenAbility))).map(PotentialAbility::getTemplate).collect(Collectors.toList()));
                            abilities.setSelectedAbilitiesIndex(0);
                            abilities.setAbility();
                            abilities.method_25307(0.0);
                            if (abilities.getAbilitiesList().size() > 1) {
                                this.method_37063((class_364)abilities.getLeftButton());
                                this.method_37063((class_364)abilities.getRightButton());
                                break;
                            }
                        }
                        break block13;
                    }
                    case 2: {
                        class_364 class_3644;
                        if (this.pokemonInfoWidget != null && this.pokemonInfoWidget.renderablePokemon != null && (class_3644 = this.tabInfoElement) instanceof SizeWidget) {
                            SizeWidget size = (SizeWidget)class_3644;
                            size.setPokemonHeight(form.getHeight());
                            size.setWeight(form.getWeight());
                            size.setBaseScale(form.getBaseScale());
                            size.setRenderablePokemon(this.pokemonInfoWidget.renderablePokemon);
                            break;
                        }
                        break block13;
                    }
                    case 3: {
                        ((StatsWidget)this.tabInfoElement).setBaseStats(form.getBaseStats());
                        break;
                    }
                    case 4: {
                        ((DropsScrollingWidget)this.tabInfoElement).setDropTable(form.getDrops());
                        ((DropsScrollingWidget)this.tabInfoElement).setEntries();
                    }
                }
                break block13;
            }
            if (this.tabInfoIndex != 0) {
                this.displaytabInfoElement(0);
            }
            ((DescriptionWidget)this.tabInfoElement).setShowPlaceholder(true);
        }
        if (this.tabInfoIndex == 0 && (class_3642 = this.tabInfoElement) instanceof DescriptionWidget) {
            DescriptionWidget description = (DescriptionWidget)class_3642;
            description.setText(textToShowInDescription);
            description.method_25307(0.0);
        }
    }

    public void updateSelectedForm(PokedexForm newForm) {
        this.selectedForm = newForm;
        this.displaytabInfoElement(this.tabInfoIndex);
    }

    public boolean canSelectTab(Integer tabIndex) {
        if (this.selectedForm == null || this.selectedEntry == null) {
            return false;
        }
        boolean encounteredForm = this.pokedex.getEncounteredForms(this.selectedEntry).contains(this.selectedForm);
        return encounteredForm && tabIndex != this.tabInfoIndex;
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (MiscUtilsKt.isInventoryKeyPressed((class_437)this, (class_310)class_310.method_1551(), (int)keyCode, (int)scanCode) && !(this.method_25399() instanceof SearchWidget)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void playSound(class_3414 soundEvent) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)soundEvent, (float)1.0f));
    }

    public <T extends class_364 & class_4068> T cast(Object object) {
        return (T)((class_364)object);
    }
}

