/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.screen;

import abeshutt.staracademy.screen.ScrollingWidget;
import com.bedrockk.molang.runtime.MoLangRuntime;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.api.pokedex.AbstractPokedexManager;
import com.cobblemon.mod.common.api.pokedex.PokedexEntryProgress;
import com.cobblemon.mod.common.api.pokedex.entry.PokedexEntry;
import com.cobblemon.mod.common.api.pokedex.entry.PokedexForm;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.client.ClientMoLangFunctions;
import com.cobblemon.mod.common.client.gui.PokemonGuiUtilsKt;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.client.render.models.blockbench.FloatingState;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import com.cobblemon.mod.common.util.math.QuaternionUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class EntriesScrollingWidget
extends ScrollingWidget<PokemonScrollSlotRow> {
    private AbstractPokedexManager pokedex;
    private int x;
    private int y;
    private Function1<PokedexEntry, Unit> setPokedexEntry;

    public EntriesScrollingWidget(AbstractPokedexManager pokedex, int x, int y, Function1<PokedexEntry, Unit> setPokedexEntry) {
        super(y - 141, x, 139, 141, 27, 5);
        this.pokedex = pokedex;
        this.x = x;
        this.y = y;
        this.setPokedexEntry = setPokedexEntry;
    }

    public void createEntries(Collection<PokedexEntry> filteredPokedex) {
        List<List<PokedexEntry>> collection = CollectionsKt.chunked(filteredPokedex, 5);
        for (List<PokedexEntry> listChunk : collection) {
            List<PokedexEntryProgress> discoveryList = listChunk.stream().map(arg_0 -> ((AbstractPokedexManager)this.pokedex).getHighestKnowledgeFor(arg_0)).collect(Collectors.toList());
            PokemonScrollSlotRow newEntry = new PokemonScrollSlotRow(this.pokedex, listChunk, discoveryList, this.setPokedexEntry);
            this.addEntry(newEntry);
        }
    }

    public int addEntry(PokemonScrollSlotRow entry) {
        return super.method_25321((class_350.class_351)entry);
    }

    @Override
    protected int method_25329() {
        return this.x + this.width - 3;
    }

    @Override
    public void renderScrollbar(class_332 context, int mouseX, int mouseY, float delta) {
        int xLeft = this.method_25329();
        int xRight = xLeft + 3;
        int barHeight = this.method_55443() - this.y;
        int yBottom = (int)((float)barHeight * (float)barHeight / (float)this.method_25317());
        yBottom = class_3532.method_15340((int)yBottom, (int)32, (int)(barHeight - 8));
        int yTop = (int)this.method_25341() * (barHeight - yBottom) / this.method_25331() + this.y;
        if (yTop < this.y) {
            yTop = this.y;
        }
        context.method_25294(xLeft, this.y + 3, xRight, this.method_55443() - 3, class_5253.class_5254.method_27764((int)255, (int)58, (int)150, (int)182));
        context.method_25294(xLeft, yTop + 3, xRight, yTop + yBottom - 3, class_5253.class_5254.method_27764((int)255, (int)252, (int)252, (int)252));
    }

    @Override
    public void renderItem(class_332 context, int mouseX, int mouseY, float delta, int index, int x, int y, int entryWidth, int entryHeight) {
        PokemonScrollSlotRow entry = this.getEntry(index);
        entry.x = x;
        entry.y = y;
        entry.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, this.method_25336() == entry, delta);
    }

    public PokemonScrollSlotRow getEntry(int index) {
        return (PokemonScrollSlotRow)((Object)this.method_25396().get(index));
    }

    public static class PokemonScrollSlotRow
    extends ScrollingWidget.Slot<PokemonScrollSlotRow> {
        private static final class_2960 slotResource = MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/pokedex_slot.png");
        private static final class_2960 slotHighlight = MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/slot_select.png");
        private static final class_2960 caughtIcon = MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/caught_icon_small.png");
        private static final class_2960 unknownIcon = MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/pokedex_slot_unknown.png");
        private static final class_2960 unimplementedIcon = MiscUtilsKt.cobblemonResource((String)"textures/gui/pokedex/pokedex_slot_unimplemented.png");
        private final AbstractPokedexManager pokedex;
        private final List<PokedexEntry> dexDataList;
        private final List<PokedexEntryProgress> discoveryLevelList;
        private final Function1<PokedexEntry, Unit> setPokedexEntry;
        private final MoLangRuntime runtime = MoLangFunctions.INSTANCE.setup(ClientMoLangFunctions.INSTANCE.setupClient(new MoLangRuntime()));
        private int x = 0;
        private int y = 0;

        public PokemonScrollSlotRow(AbstractPokedexManager pokedex, List<PokedexEntry> dexDataList, List<PokedexEntryProgress> discoveryLevelList, Function1<PokedexEntry, Unit> setPokedexEntry) {
            this.pokedex = pokedex;
            this.dexDataList = dexDataList;
            this.discoveryLevelList = discoveryLevelList;
            this.setPokedexEntry = setPokedexEntry;
            this.runtime.getEnvironment().query.addFunction("get_pokedex", params -> this.pokedex.getStruct());
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            for (int i = 0; i < this.dexDataList.size(); ++i) {
                boolean shouldDrawMon;
                PokedexEntry dexData = this.dexDataList.get(i);
                FloatingState state = new FloatingState();
                Species species = PokemonSpecies.INSTANCE.getByIdentifier(dexData.getSpeciesId());
                String pokemonNumber = species != null ? "" + species.getNationalPokedexNumber() : "0";
                pokemonNumber = StringsKt.padStart(pokemonNumber, 4, '0');
                class_5250 speciesNumber = TextKt.text((String)pokemonNumber);
                PokedexEntryProgress discoveryLevel = this.discoveryLevelList.get(i);
                List forms = this.pokedex.getEncounteredForms(dexData);
                PokedexForm firstVisibleForm = forms.isEmpty() ? null : (PokedexForm)forms.getFirst();
                boolean bl = shouldDrawMon = firstVisibleForm != null;
                if (species == null) continue;
                class_4587 matrices = context.method_51448();
                int startPosX = x + 27 * i;
                int startPosY = y + 2 + 1;
                GuiUtilsKt.blitk((class_4587)matrices, (class_2960)slotResource, (Number)startPosX, (Number)startPosY, (Number)25, (Number)25);
                if (this.getHoveredSlotIndex(mouseX, mouseY) == i) {
                    GuiUtilsKt.blitk((class_4587)matrices, (class_2960)slotHighlight, (Number)startPosX, (Number)startPosY, (Number)25, (Number)25, (Number)0, (Number)25, (Number)25, (Number)50);
                }
                if (shouldDrawMon) {
                    ArrayList genders = new ArrayList(this.pokedex.getSeenGenders(dexData, firstVisibleForm));
                    Gender firstVisibleGender = genders.isEmpty() ? null : (Gender)genders.getFirst();
                    ArrayList shinyStates = new ArrayList(this.pokedex.getSeenShinyStates(dexData, firstVisibleForm));
                    boolean firstVisibleShiny = shinyStates.size() == 1 && ((String)shinyStates.getFirst()).equals("shiny");
                    List formAspects = species.getForms().stream().filter(form -> form.getName().equalsIgnoreCase(firstVisibleForm.getDisplayForm())).findFirst().orElseGet(() -> ((Species)species).getStandardForm()).getAspects();
                    Set seenAspects = this.pokedex.getSeenAspects(dexData);
                    List<String> variationAspects = dexData.getVariations().stream().map(var -> var.getAspects().stream().filter(seenAspects::contains).findFirst().orElse(null)).filter(Objects::nonNull).toList();
                    context.method_44379(startPosX + 1, startPosY + 1, startPosX + 25 - 1, startPosY + 25 - 2);
                    ArrayList<String> aspectsToDraw = new ArrayList<String>();
                    aspectsToDraw.addAll(dexData.getDisplayAspects());
                    aspectsToDraw.addAll(variationAspects);
                    aspectsToDraw.addAll(formAspects);
                    aspectsToDraw.add((firstVisibleGender != null ? firstVisibleGender : Gender.GENDERLESS).name().toLowerCase());
                    if (firstVisibleShiny) {
                        aspectsToDraw.add("shiny");
                    }
                    matrices.method_22903();
                    matrices.method_22904((double)startPosX + 12.5, (double)startPosY + 1.0, 0.0);
                    matrices.method_22905(2.5f, 2.5f, 1.0f);
                    PokemonGuiUtilsKt.drawProfilePokemon((RenderablePokemon)new RenderablePokemon(species, new LinkedHashSet(aspectsToDraw)), (class_4587)matrices, (Quaternionf)QuaternionUtilsKt.fromEulerXYZDegrees((Quaternionf)new Quaternionf(), (Vector3f)new Vector3f(13.0f, 35.0f, 0.0f)), (PoseType)PoseType.PROFILE, (PosableState)state, (float)0.0f, (float)4.5f, (boolean)true, (boolean)false, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    matrices.method_22909();
                    context.method_44380();
                } else {
                    GuiUtilsKt.blitk((class_4587)matrices, (class_2960)unknownIcon, (Number)((double)startPosX + 8.5), (Number)(startPosY + 9), (Number)10, (Number)8);
                    if (!species.getImplemented()) {
                        GuiUtilsKt.blitk((class_4587)matrices, (class_2960)unimplementedIcon, (Number)Float.valueOf((float)(startPosX + 14) / 0.5f), (Number)(((double)startPosY + 15.5) / 0.5), (Number)7, (Number)7, (Number)0, (Number)0, (Number)7, (Number)7, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)true, (float)0.5f);
                    }
                }
                matrices.method_22903();
                matrices.method_22904(0.0, 0.0, 100.0);
                RenderHelperKt.drawScaledText((class_332)context, null, (class_5250)speciesNumber, (Number)((double)startPosX + 1.5), (Number)((double)startPosY + 2.5), (float)0.5f, (Number)Float.valueOf(1.0f), (int)Integer.MAX_VALUE, (int)-1, (boolean)false, (boolean)true, null, null);
                if (discoveryLevel == PokedexEntryProgress.CAUGHT) {
                    GuiUtilsKt.blitk((class_4587)matrices, (class_2960)caughtIcon, (Number)Float.valueOf((float)(startPosX + 18) / 0.5f), (Number)(((double)startPosY + 1.5) / 0.5), (Number)11, (Number)11, (Number)0, (Number)0, (Number)11, (Number)11, (Number)0, (Number)1, (Number)1, (Number)1, (Number)1, (boolean)true, (float)0.5f);
                }
                matrices.method_22909();
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int hoverIndex = this.getHoveredSlotIndex((int)mouseX, (int)mouseY);
            if (hoverIndex > -1 && hoverIndex < this.dexDataList.size()) {
                this.setPokedexEntry.invoke(this.dexDataList.get(hoverIndex));
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)CobblemonSounds.POKEDEX_CLICK, (float)1.0f));
            }
            return true;
        }

        private int getHoveredSlotIndex(int mouseX, int mouseY) {
            for (int i = 0; i < this.dexDataList.size(); ++i) {
                int startPosX = this.x + 27 * i;
                int startPosY = this.y + 2 + 1;
                if (mouseX < startPosX || mouseX > startPosX + 25 || mouseY < startPosY || mouseY > startPosY + 25) continue;
                return i;
            }
            return -1;
        }

        public class_2561 method_37006() {
            if (!this.dexDataList.isEmpty()) {
                return TextKt.text((String)(String.valueOf(this.dexDataList.getFirst()) + "-" + String.valueOf(this.dexDataList.getLast())));
            }
            return TextKt.text((String)"");
        }
    }
}

