/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.net;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.net.ModPacket;
import abeshutt.staracademy.world.data.save.SafariData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_634;
import net.minecraft.class_8710;

public class UpdateSafariS2CPacket
extends ModPacket<class_634> {
    public static final class_8710.class_9154<UpdateSafariS2CPacket> ID = new class_8710.class_9154(StarAcademyMod.id("update_safari_s2c"));
    private long timeLeft;
    private boolean paused;
    private Map<UUID, SafariData.Entry> entries;

    public UpdateSafariS2CPacket() {
    }

    public UpdateSafariS2CPacket(long timeLeft, boolean paused, Map<UUID, SafariData.Entry> entries) {
        this.timeLeft = timeLeft;
        this.paused = paused;
        this.entries = entries;
    }

    public UpdateSafariS2CPacket(long timeLeft, boolean paused, UUID uuid, SafariData.Entry profile) {
        this.timeLeft = timeLeft;
        this.paused = paused;
        this.entries = new HashMap<UUID, SafariData.Entry>();
        this.entries.put(uuid, profile);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    @Override
    public void onReceive(class_634 listener) {
        SafariData.CLIENT.setTimeLeft(this.timeLeft);
        SafariData.CLIENT.setPaused(this.paused);
        Map<UUID, SafariData.Entry> entries = SafariData.CLIENT.getEntries();
        if (this.entries == null) {
            entries.clear();
        } else {
            this.entries.forEach((uuid, profile) -> {
                if (profile == null) {
                    entries.remove(uuid);
                } else {
                    entries.put((UUID)uuid, (SafariData.Entry)profile);
                }
            });
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.LONG.writeBits(this.timeLeft, buffer);
        Adapters.BOOLEAN.writeBits(this.paused, buffer);
        Adapters.BOOLEAN.writeBits(this.entries == null, buffer);
        if (this.entries != null) {
            Adapters.INT_SEGMENTED_3.writeBits(this.entries.size(), buffer);
            this.entries.forEach((uuid, entry) -> {
                Adapters.UUID.writeBits((UUID)uuid, buffer);
                entry.writeBits(buffer);
            });
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.timeLeft = (Long)Adapters.LONG.readBits(buffer).orElseThrow();
        this.paused = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
        if (Adapters.BOOLEAN.readBits(buffer).orElseThrow().booleanValue()) {
            this.entries = null;
        } else {
            this.entries = new HashMap<UUID, SafariData.Entry>();
            int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            UUID uuid = Adapters.UUID.readBits(buffer).orElseThrow();
            SafariData.Entry entry = new SafariData.Entry();
            entry.readBits(buffer);
            for (int i = 0; i < size; ++i) {
                this.entries.put(uuid, entry);
            }
        }
    }
}

