/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.mixin.mythsandlegends;

import com.bawnorton.mixinsquared.TargetHandler;
import com.cobblemon.mod.common.api.spawning.condition.AppendageCondition;
import com.cobblemon.mod.common.api.spawning.detail.SingleEntitySpawnAction;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.items.ItemCondition;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.keyitem.KeyItemConditions;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.keyitem.custom.CustomKeyItemCondition;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.keyitem.custom.CustomSecondaryItemCondition;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.utils.DebtUtils;
import com.github.d0ctorleon.mythsandlegends.utils.InventoryUtils;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import dev.architectury.platform.Platform;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Mixin(value={SingleEntitySpawnAction.class}, priority=1500)
public class MixinSingleEntitySpawnAction {
    @TargetHandler(mixin="com.github.d0ctorleon.mythsandlegends.cobblemon.mixins.SingleEntitySpawnActionMixin", name="MythsAndLegends$processConditions")
    @Inject(method={"@MixinSquared:Handler"}, at={@At(value="HEAD")}, cancellable=true)
    private void processConditions(List<AppendageCondition> appendages, class_3222 player, boolean itemConditionMet, CallbackInfo ci) {
        ModConfigs config = MythsAndLegends.getConfigManager().getConfig();
        MythsAndLegends.getLogger().debug("SingleEntitySpawnActionMixin processConditions-Started");
        boolean configConsume = config.consume_items_on_successful_spawn;
        boolean consumeOnlyItems = config.ignore_key_items;
        for (AppendageCondition appendage : appendages) {
            if (appendage instanceof CustomKeyItemCondition) {
                CustomKeyItemCondition condition = (CustomKeyItemCondition)appendage;
                if (condition.getItemConditions() == null) continue;
                for (CustomKeyItemCondition.CustomConditionItem entry : condition.getItemConditions()) {
                    if (!entry.consume && (!configConsume || consumeOnlyItems && itemConditionMet)) continue;
                    this.academy$removeCustomItemFromPlayer(player, entry.id, entry.count, config);
                }
                continue;
            }
            if (appendage instanceof CustomSecondaryItemCondition) {
                CustomSecondaryItemCondition condition = (CustomSecondaryItemCondition)appendage;
                CustomKeyItemCondition.CustomConditionItem item = condition.getItemConditionIdentifier();
                if (item == null || !configConsume && !item.consume) continue;
                this.academy$removeCustomItemFromPlayer(player, item.id, item.count, config);
                continue;
            }
            if (appendage instanceof KeyItemConditions.KeyItem) {
                KeyItemConditions.KeyItem condition = (KeyItemConditions.KeyItem)appendage;
                if (!configConsume || condition.getItemCondtionIdentifier() == null || itemConditionMet && config.ignore_key_items) continue;
                this.academy$removeKeyItemFromPlayer(player, condition.getItemCondtionIdentifier(), config);
                continue;
            }
            if (!(appendage instanceof ItemCondition)) continue;
            ItemCondition condition = (ItemCondition)appendage;
            if (!configConsume || condition.getItemConditionIdentifier() == null) continue;
            this.academy$removeItemFromPlayer(player, condition.getItemConditionIdentifier(), condition.getItemNamespace(), condition.getItemPath(), config);
        }
        ci.cancel();
    }

    @Unique
    private void academy$removeItemFromPlayer(class_3222 player, class_2960 id, String namespace, String path, ModConfigs config) {
        if (id != null) {
            int requiredCount;
            class_2960 ItemIdentifier = class_2960.method_60655((String)namespace, (String)path);
            class_1792 item = (class_1792)player.method_56673().method_30530(class_7924.field_41197).method_10223(ItemIdentifier);
            if (!InventoryUtils.removeItemFromInventory((class_3222)player, (class_1792)item, (int)(requiredCount = MythsAndLegendsConditions.parseRequiredCount((String)id.method_12832())), (boolean)config.inventory_check_bundles, (boolean)config.inventory_check_shulker_boxes)) {
                DebtUtils debtUtils = new DebtUtils(Platform.getConfigFolder().resolve("MythsAndLegends"));
                debtUtils.addDebt(player.method_5667(), ItemIdentifier, requiredCount);
            }
            PlayerDataUtils.checkPlayerInventory((class_1657)player);
        }
    }

    @Unique
    private void academy$removeCustomItemFromPlayer(class_3222 player, class_2960 customItemId, int count, ModConfigs config) {
        class_1792 item = (class_1792)player.method_56673().method_30530(class_7924.field_41197).method_10223(customItemId);
        if (!InventoryUtils.removeItemFromInventory((class_3222)player, (class_1792)item, (int)count, (boolean)config.inventory_check_bundles, (boolean)config.inventory_check_shulker_boxes)) {
            DebtUtils debtUtils = new DebtUtils(Platform.getConfigFolder().resolve("MythsAndLegends"));
            debtUtils.addDebt(player.method_5667(), customItemId, count);
        }
        PlayerDataUtils.checkPlayerInventory((class_1657)player);
    }

    @Unique
    private void academy$removeKeyItemFromPlayer(class_3222 player, class_2960 keyItem, ModConfigs config) {
        class_1792 item = (class_1792)player.method_56673().method_30530(class_7924.field_41197).method_10223(keyItem);
        if (!InventoryUtils.removeItemFromInventory((class_3222)player, (class_1792)item, (int)1, (boolean)config.inventory_check_bundles, (boolean)config.inventory_check_shulker_boxes)) {
            DebtUtils debtUtils = new DebtUtils(Platform.getConfigFolder().resolve("MythsAndLegends"));
            debtUtils.addDebt(player.method_5667(), keyItem, 1);
        }
        PlayerDataUtils.checkPlayerInventory((class_1657)player);
    }
}

