/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.mixin.moonrise;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.ExplosionBlockCache;
import ca.spottedleaf.moonrise.patches.collisions.block.CollisionBlockState;
import ca.spottedleaf.moonrise.patches.getblock.GetBlockChunk;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_5134;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1927.class})
abstract class MixinExplosion {
    @Shadow
    @Final
    private class_1937 field_9187;
    @Shadow
    @Final
    private class_1297 field_9185;
    @Shadow
    @Final
    private double field_9195;
    @Shadow
    @Final
    private double field_9192;
    @Shadow
    @Final
    private double field_9189;
    @Shadow
    @Final
    private class_5362 field_25400;
    @Shadow
    @Final
    private float field_9190;
    @Shadow
    @Final
    private ObjectArrayList<class_2338> field_9188;
    @Shadow
    @Final
    private Map<class_1657, class_243> field_9194;
    @Shadow
    @Final
    private boolean field_9186;
    @Shadow
    @Final
    private class_1282 field_9193;
    @Unique
    private static final double[] CACHED_RAYS;
    @Unique
    private static final int CHUNK_CACHE_SHIFT = 2;
    @Unique
    private static final int CHUNK_CACHE_MASK = 3;
    @Unique
    private static final int CHUNK_CACHE_WIDTH = 4;
    @Unique
    private static final int BLOCK_EXPLOSION_CACHE_SHIFT = 3;
    @Unique
    private static final int BLOCK_EXPLOSION_CACHE_MASK = 7;
    @Unique
    private static final int BLOCK_EXPLOSION_CACHE_WIDTH = 8;
    @Unique
    private static final Float ZERO_RESISTANCE;
    @Unique
    private Long2ObjectOpenHashMap<ExplosionBlockCache> blockCache = null;
    @Unique
    private long[] chunkPosCache = null;
    @Unique
    private class_2818[] chunkCache = null;

    MixinExplosion() {
    }

    @Unique
    private ExplosionBlockCache getOrCacheExplosionBlock(int x, int y, int z, long key, boolean calculateResistance) {
        ExplosionBlockCache ret = (ExplosionBlockCache)this.blockCache.get(key);
        if (ret != null) {
            return ret;
        }
        class_2338 pos = new class_2338(x, y, z);
        if (!this.field_9187.method_24794(pos)) {
            ret = new ExplosionBlockCache(key, pos, (class_2680)null, (class_3610)null, 0.0f, true);
        } else {
            class_2818 chunk;
            int chunkCacheKey = x >> 4 & 3 | z >> 4 << 2 & 0xC;
            long chunkKey = CoordinateUtils.getChunkKey((int)(x >> 4), (int)(z >> 4));
            if (this.chunkPosCache[chunkCacheKey] == chunkKey) {
                chunk = this.chunkCache[chunkCacheKey];
            } else {
                this.chunkPosCache[chunkCacheKey] = chunkKey;
                this.chunkCache[chunkCacheKey] = chunk = this.field_9187.method_8497(x >> 4, z >> 4);
            }
            class_2680 blockState = ((GetBlockChunk)chunk).moonrise$getBlock(x, y, z);
            class_3610 fluidState = blockState.method_26227();
            Optional resistance = !calculateResistance ? Optional.empty() : this.field_25400.method_29555((class_1927)this, (class_1922)this.field_9187, pos, blockState, fluidState);
            ret = new ExplosionBlockCache(key, pos, blockState, fluidState, (resistance.orElse(ZERO_RESISTANCE).floatValue() + 0.3f) * 0.3f, false);
        }
        this.blockCache.put(key, (Object)ret);
        return ret;
    }

    @Unique
    private boolean clipsAnything(class_243 from, class_243 to, CollisionUtil.LazyEntityCollisionContext context, ExplosionBlockCache[] blockCache, class_2338.class_2339 currPos) {
        double adjX = 1.0E-7 * (from.field_1352 - to.field_1352);
        double adjY = 1.0E-7 * (from.field_1351 - to.field_1351);
        double adjZ = 1.0E-7 * (from.field_1350 - to.field_1350);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return false;
        }
        double toXAdj = to.field_1352 - adjX;
        double toYAdj = to.field_1351 - adjY;
        double toZAdj = to.field_1350 - adjZ;
        double fromXAdj = from.field_1352 + adjX;
        double fromYAdj = from.field_1351 + adjY;
        double fromZAdj = from.field_1350 + adjZ;
        int currX = class_3532.method_15357((double)fromXAdj);
        int currY = class_3532.method_15357((double)fromYAdj);
        int currZ = class_3532.method_15357((double)fromZAdj);
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - class_3532.method_15385((double)fromXAdj) : class_3532.method_15385((double)fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - class_3532.method_15385((double)fromYAdj) : class_3532.method_15385((double)fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - class_3532.method_15385((double)fromZAdj) : class_3532.method_15385((double)fromZAdj));
        while (true) {
            class_2680 blockState;
            currPos.method_10103(currX, currY, currZ);
            long key = class_2338.method_10064((int)currX, (int)currY, (int)currZ);
            int cacheKey = currX & 7 | (currY & 7) << 3 | (currZ & 7) << 6;
            ExplosionBlockCache cachedBlock = blockCache[cacheKey];
            if (cachedBlock == null || cachedBlock.key != key) {
                blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(currX, currY, currZ, key, false);
            }
            if ((blockState = cachedBlock.blockState) != null && !((CollisionBlockState)blockState).moonrise$emptyContextCollisionShape()) {
                class_265 collision = cachedBlock.cachedCollisionShape;
                if (collision == null) {
                    collision = ((CollisionBlockState)blockState).moonrise$getConstantContextCollisionShape();
                    if (collision == null) {
                        collision = blockState.method_26194((class_1922)this.field_9187, (class_2338)currPos, (class_3726)context);
                        if (!context.isDelegated()) {
                            cachedBlock.cachedCollisionShape = collision;
                        }
                    } else {
                        cachedBlock.cachedCollisionShape = collision;
                    }
                }
                if (!collision.method_1110() && collision.method_1092(from, to, (class_2338)currPos) != null) {
                    return true;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return false;
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    @Unique
    private float getSeenFraction(class_243 source2, class_1297 target, ExplosionBlockCache[] blockCache, class_2338.class_2339 blockPos) {
        class_238 boundingBox = target.method_5829();
        double diffX = boundingBox.field_1320 - boundingBox.field_1323;
        double diffY = boundingBox.field_1325 - boundingBox.field_1322;
        double diffZ = boundingBox.field_1324 - boundingBox.field_1321;
        double incX = 1.0 / (diffX * 2.0 + 1.0);
        double incY = 1.0 / (diffY * 2.0 + 1.0);
        double incZ = 1.0 / (diffZ * 2.0 + 1.0);
        if (!(incX < 0.0 || incY < 0.0 || incZ < 0.0)) {
            double offX = (1.0 - Math.floor(1.0 / incX) * incX) * 0.5 + boundingBox.field_1323;
            double offY = boundingBox.field_1322;
            double offZ = (1.0 - Math.floor(1.0 / incZ) * incZ) * 0.5 + boundingBox.field_1321;
            CollisionUtil.LazyEntityCollisionContext context = new CollisionUtil.LazyEntityCollisionContext(target);
            int totalRays = 0;
            int missedRays = 0;
            for (double dx = 0.0; dx <= 1.0; dx += incX) {
                double fromX = Math.fma(dx, diffX, offX);
                for (double dy = 0.0; dy <= 1.0; dy += incY) {
                    double fromY = Math.fma(dy, diffY, offY);
                    for (double dz = 0.0; dz <= 1.0; dz += incZ) {
                        ++totalRays;
                        class_243 from = new class_243(fromX, fromY, Math.fma(dz, diffZ, offZ));
                        if (this.clipsAnything(from, source2, context, blockCache, blockPos)) continue;
                        ++missedRays;
                    }
                }
            }
            return (float)missedRays / (float)totalRays;
        }
        return 0.0f;
    }

    @Inject(method={"collectBlocksAndDamageEntities"}, at={@At(value="HEAD")}, cancellable=true)
    public void collectBlocksAndDamageEntities(CallbackInfo ci) {
        this.field_9187.method_43275(this.field_9185, (class_6880)class_5712.field_28178, new class_243(this.field_9195, this.field_9192, this.field_9189));
        this.blockCache = new Long2ObjectOpenHashMap();
        this.chunkPosCache = new long[16];
        Arrays.fill(this.chunkPosCache, class_1923.field_17348);
        this.chunkCache = new class_2818[16];
        ExplosionBlockCache[] blockCache = new ExplosionBlockCache[512];
        int blockX = class_3532.method_15357((double)this.field_9195);
        int blockY = class_3532.method_15357((double)this.field_9192);
        int blockZ = class_3532.method_15357((double)this.field_9189);
        long key = class_2338.method_10064((int)blockX, (int)blockY, (int)blockZ);
        ExplosionBlockCache initialCache = this.getOrCacheExplosionBlock(blockX, blockY, blockZ, key, true);
        int ray = 0;
        int len = CACHED_RAYS.length;
        block0: while (ray < len) {
            ExplosionBlockCache cachedBlock = initialCache;
            double currX = this.field_9195;
            double currY = this.field_9192;
            double currZ = this.field_9189;
            double incX = CACHED_RAYS[ray];
            double incY = CACHED_RAYS[ray + 1];
            double incZ = CACHED_RAYS[ray + 2];
            ray += 3;
            float power = this.field_9190 * (0.7f + this.field_9187.field_9229.method_43057() * 0.6f);
            do {
                int cacheKey;
                int blockZ2;
                int blockY2;
                int blockX2;
                long key2;
                if (cachedBlock.key != (key2 = class_2338.method_10064((int)(blockX2 = class_3532.method_15357((double)currX)), (int)(blockY2 = class_3532.method_15357((double)currY)), (int)(blockZ2 = class_3532.method_15357((double)currZ)))) && ((cachedBlock = blockCache[cacheKey = blockX2 & 7 | (blockY2 & 7) << 3 | (blockZ2 & 7) << 6]) == null || cachedBlock.key != key2)) {
                    blockCache[cacheKey] = cachedBlock = this.getOrCacheExplosionBlock(blockX2, blockY2, blockZ2, key2, true);
                }
                if (cachedBlock.outOfWorld) continue block0;
                if ((power -= cachedBlock.resistance) > 0.0f && cachedBlock.shouldExplode == null) {
                    boolean shouldExplode = this.field_25400.method_29554((class_1927)this, (class_1922)this.field_9187, cachedBlock.immutablePos, cachedBlock.blockState, power);
                    Boolean bl = cachedBlock.shouldExplode = shouldExplode ? Boolean.TRUE : Boolean.FALSE;
                    if (shouldExplode && (this.field_9186 || !cachedBlock.blockState.method_26215())) {
                        this.field_9188.add((Object)cachedBlock.immutablePos);
                    }
                }
                currX += incX;
                currY += incY;
                currZ += incZ;
            } while ((power -= 0.22500001f) > 0.0f);
        }
        double diameter = (double)this.field_9190 * 2.0;
        List entities = this.field_9187.method_8335(this.field_9185, new class_238((double)class_3532.method_15357((double)(this.field_9195 - (diameter + 1.0))), (double)class_3532.method_15357((double)(this.field_9192 - (diameter + 1.0))), (double)class_3532.method_15357((double)(this.field_9189 - (diameter + 1.0))), (double)class_3532.method_15357((double)(this.field_9195 + (diameter + 1.0))), (double)class_3532.method_15357((double)(this.field_9192 + (diameter + 1.0))), (double)class_3532.method_15357((double)(this.field_9189 + (diameter + 1.0)))));
        class_243 center = new class_243(this.field_9195, this.field_9192, this.field_9189);
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        PlatformHooks platformHooks = PlatformHooks.get();
        platformHooks.onExplosion(this.field_9187, (class_1927)this, entities, diameter);
        int len2 = entities.size();
        for (int i = 0; i < len2; ++i) {
            class_1657 player;
            double knockbackFraction;
            double distZ;
            double distY;
            double normalizedDistanceToCenter;
            class_1297 entity = (class_1297)entities.get(i);
            if (entity.method_5659((class_1927)this) || (normalizedDistanceToCenter = Math.sqrt(entity.method_5707(center)) / diameter) > 1.0) continue;
            double distX = entity.method_23317() - this.field_9195;
            double distMag = Math.sqrt(distX * distX + (distY = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.field_9192) * distY + (distZ = entity.method_23321() - this.field_9189) * distZ);
            if (distMag == 0.0) continue;
            distX /= distMag;
            distY /= distMag;
            distZ /= distMag;
            double seenFraction = this.getSeenFraction(center, entity, blockCache, blockPos);
            if (this.field_25400.method_55504((class_1927)this, entity)) {
                double factor = (1.0 - normalizedDistanceToCenter) * seenFraction;
                entity.method_5643(this.field_9193, (float)((factor * factor + factor) / 2.0 * 7.0 * diameter + 1.0));
            }
            double intensityFraction = (1.0 - normalizedDistanceToCenter) * seenFraction * (double)this.field_25400.method_57007(entity);
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                knockbackFraction = intensityFraction * (1.0 - livingEntity.method_45325(class_5134.field_51580));
            } else {
                knockbackFraction = intensityFraction;
            }
            class_243 knockback = new class_243(distX * knockbackFraction, distY * knockbackFraction, distZ * knockbackFraction);
            knockback = platformHooks.modifyExplosionKnockback(this.field_9187, (class_1927)this, entity, knockback);
            entity.method_18799(entity.method_18798().method_1019(knockback));
            if (!(!(entity instanceof class_1657) || (player = (class_1657)entity).method_7325() || player.method_7337() && player.method_31549().field_7479)) {
                this.field_9194.put(player, knockback);
            }
            entity.method_56918(this.field_9185);
        }
        this.blockCache = null;
        this.chunkPosCache = null;
        this.chunkCache = null;
        ci.cancel();
    }

    static {
        DoubleArrayList rayCoords = new DoubleArrayList();
        for (int x = 0; x <= 15; ++x) {
            for (int y = 0; y <= 15; ++y) {
                for (int z = 0; z <= 15; ++z) {
                    if (x != 0 && x != 15 && y != 0 && y != 15 && z != 0 && z != 15) continue;
                    double xDir = (float)x / 15.0f * 2.0f - 1.0f;
                    double yDir = (float)y / 15.0f * 2.0f - 1.0f;
                    double zDir = (float)z / 15.0f * 2.0f - 1.0f;
                    double mag = Math.sqrt(xDir * xDir + yDir * yDir + zDir * zDir);
                    rayCoords.add(xDir / mag * (double)0.3f);
                    rayCoords.add(yDir / mag * (double)0.3f);
                    rayCoords.add(zDir / mag * (double)0.3f);
                }
            }
        }
        CACHED_RAYS = rayCoords.toDoubleArray();
        ZERO_RESISTANCE = Float.valueOf(-0.3f);
    }
}

