/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.mixin.cobblemon;

import abeshutt.staracademy.compat.cobblemon.GameStarterHandler;
import abeshutt.staracademy.proxy.ProxySelectionButton;
import abeshutt.staracademy.proxy.ProxySelectionScreen;
import abeshutt.staracademy.world.data.StarterEntry;
import abeshutt.staracademy.world.data.StarterId;
import abeshutt.staracademy.world.data.StarterMode;
import abeshutt.staracademy.world.data.save.PokemonStarterData;
import com.cobblemon.mod.common.client.gui.startselection.StarterSelectionScreen;
import com.cobblemon.mod.common.client.gui.startselection.widgets.CategoryList;
import com.cobblemon.mod.common.client.gui.startselection.widgets.preview.SelectionButton;
import com.cobblemon.mod.common.config.starter.RenderableStarterCategory;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StarterSelectionScreen.class})
public abstract class MixinStarterSelectionScreen
extends class_437
implements ProxySelectionScreen {
    @Shadow
    private int currentSelection;
    @Shadow
    private RenderableStarterCategory currentCategory;
    @Unique
    private SelectionButton button;
    @Unique
    private CategoryList list;
    @Unique
    private boolean initialized;
    @Unique
    private List<RenderableStarterCategory> categories;

    protected MixinStarterSelectionScreen(class_2561 title) {
        super(title);
    }

    @Shadow
    protected abstract void method_25426();

    @Shadow
    protected abstract void updateSelection();

    @Shadow
    public abstract void changeCategory(@NotNull RenderableStarterCategory var1);

    @Override
    public int getSelection() {
        return this.currentSelection;
    }

    @Override
    public void setSelection(int selection) {
        this.currentSelection = class_3532.method_15340((int)selection, (int)0, (int)(this.currentCategory.getPokemon().size() - 1));
        this.updateSelection();
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void init(CallbackInfo ci) {
        for (class_364 child : this.method_25396()) {
            if (child instanceof SelectionButton) {
                SelectionButton button;
                this.button = button = (SelectionButton)child;
                continue;
            }
            if (!(child instanceof CategoryList)) continue;
            CategoryList list = (CategoryList)child;
            try {
                Field field = StarterSelectionScreen.class.getDeclaredField("categories");
                field.setAccessible(true);
                this.categories = (List)field.get(this);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
            this.list = list;
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void render(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        PokemonStarterData data = PokemonStarterData.CLIENT;
        StarterEntry entry = data.getEntries().get(player.method_5667());
        if (entry == null) {
            return;
        }
        boolean isRaffle = data.getMode() == StarterMode.RAFFLE_ENABLED || data.getMode() == StarterMode.RAFFLE_PAUSED;
        StarterId current = new StarterId(this.currentCategory.getName(), this.currentSelection);
        this.button.field_22764 = isRaffle ? entry.isAvailable() && data.getRemainingAllocations(current) > 0 : true;
        ProxySelectionButton.of(this.button).ifPresent(proxy -> {
            if (!isRaffle) {
                proxy.setText(null);
                return;
            }
            StarterId pick = data.getPick(player.method_5667());
            if (pick == null) {
                return;
            }
            if (current.equals(pick)) {
                proxy.setText("ui.starter.choosebutton.same");
            } else {
                proxy.setText(null);
            }
        });
        if (!this.initialized) {
            if (GameStarterHandler.SCROLL_AMOUNT >= 0.0) {
                this.list.method_25307(GameStarterHandler.SCROLL_AMOUNT);
            }
            if (GameStarterHandler.SELECTED_CATEGORY >= 0) {
                int index = class_3532.method_15340((int)GameStarterHandler.SELECTED_CATEGORY, (int)0, (int)(this.method_25396().size() - 1));
                this.list.method_25313((class_350.class_351)((CategoryList.Category)this.list.method_25396().get(index)));
                this.changeCategory(this.categories.get(index));
            }
            if (GameStarterHandler.SELECTED_POKEMON >= 0) {
                this.setSelection(GameStarterHandler.SELECTED_POKEMON);
            }
            this.initialized = true;
        }
        GameStarterHandler.SCROLL_AMOUNT = this.list.method_25341();
        GameStarterHandler.SELECTED_CATEGORY = IntStream.range(0, this.list.method_25396().size()).filter(i -> Objects.equals(this.list.method_25334(), this.list.method_25396().get(i))).findFirst().orElse(-1);
        GameStarterHandler.SELECTED_POKEMON = this.getSelection();
    }

    @Overwrite
    public boolean method_25421() {
        return false;
    }
}

