/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.mixin.alphas;

import abeshutt.staracademy.math.random.JavaRandom;
import dev.cudzer.cobblemonalphas.CobblemonAlphasMod;
import dev.cudzer.cobblemonalphas.config.ModConfig;
import dev.cudzer.cobblemonalphas.data.AlphaJsonDataManager;
import dev.cudzer.cobblemonalphas.entity.Alpha;
import dev.cudzer.cobblemonalphas.entity.spawner.AlphaSpawner;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.location.ISpawnLocation;
import dev.cudzer.cobblemonalphas.entity.spawner.spawnData.safety.ISpawnCondition;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AlphaSpawner.class})
public abstract class MixinAlphaSpawner {
    @Shadow
    private MinecraftServer server;
    @Shadow
    private ISpawnLocation spawnLocationSelector;
    @Shadow
    private List<ISpawnCondition> spawnConditions;

    @Shadow
    public abstract void spawnAlphaEntity(Alpha var1, class_1937 var2, class_2382 var3, boolean var4);

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void tick(CallbackInfo ci) {
        if (this.server.method_3780() % 20 == 0) {
            for (class_3222 player : this.server.method_3760().method_14571()) {
                JavaRandom random = JavaRandom.ofNanoTime();
                if (random.nextFloat() >= ModConfig.alphaSpawnChance) continue;
                this.academy$doSpawnAttempt(player);
            }
        }
        ci.cancel();
    }

    @Unique
    private void academy$doSpawnAttempt(class_3222 player) {
        Alpha tempAlpha;
        class_2338 finalSpawnPos;
        class_2382 spawnPos;
        class_1937 world;
        Alpha chosenAlpha = AlphaJsonDataManager.getRandomAlphaObj((class_1937)this.server.method_30002());
        int attemptedSpawns = 0;
        while (true) {
            if (++attemptedSpawns > ModConfig.spawnAttempts) {
                CobblemonAlphasMod.LOGGER.info("Maximum spawn attempts reached. Skipping this alpha spawn");
                return;
            }
            world = player.method_37908();
            spawnPos = this.spawnLocationSelector.getSpawnLocation(world, player.method_19538());
            if (spawnPos == null) continue;
            finalSpawnPos = new class_2338(spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260());
            if (this.spawnConditions.stream().allMatch(condition -> condition.isSafe(world, finalSpawnPos))) break;
        }
        class_5321 biomeKey = world.method_23753(finalSpawnPos).method_40230().orElse(null);
        if (biomeKey != null && (tempAlpha = (Alpha)AlphaJsonDataManager.getRandomAlphaForBiome((class_1937)player.method_37908(), (class_5321)biomeKey, (!world.method_8311(finalSpawnPos) ? 1 : 0) != 0).values().stream().toList().getFirst()) != null) {
            chosenAlpha = tempAlpha;
        }
        this.spawnAlphaEntity(chosenAlpha, world, spawnPos, ModConfig.doHerdSpawning);
        Object announcement = ModConfig.spawnAnnouncementMessage;
        if (ModConfig.showCoordinatesInAnnouncement) {
            announcement = (String)announcement + " (" + spawnPos.method_10263() + ", " + spawnPos.method_10264() + ", " + spawnPos.method_10260() + ")";
        }
        this.server.method_3760().method_43514((class_2561)class_2561.method_43470((String)announcement), false);
    }
}

