/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.mixin;

import abeshutt.staracademy.block.SafariPortalBlock;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.proxy.ProxyEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class MixinEntity
implements ProxyEntity {
    @Unique
    private boolean inSafariPortal;
    @Unique
    private boolean safariPortalCooldown;
    @Unique
    private List<Runnable> scheduledPortalTicks = new ArrayList<Runnable>();

    @Shadow
    public abstract class_1937 method_37908();

    @Shadow
    public abstract UUID method_5667();

    @Shadow
    public abstract boolean method_30230();

    @Shadow
    public abstract class_238 method_5829();

    @Shadow
    public abstract void method_5651(class_2487 var1);

    @Shadow
    public abstract void method_5650(class_1297.class_5529 var1);

    @Shadow
    public abstract void method_31472();

    @Override
    public boolean isInSafariPortal() {
        return this.inSafariPortal;
    }

    @Override
    public boolean hasSafariPortalCooldown() {
        return this.safariPortalCooldown;
    }

    @Override
    public void setInSafariPortal(boolean inSafariPortal) {
        this.inSafariPortal = inSafariPortal;
    }

    @Override
    public void setSafariPortalCooldown(boolean safariPortalCooldown) {
        this.safariPortalCooldown = safariPortalCooldown;
    }

    @Override
    public void schedulePortalTick(Runnable runnable2) {
        this.scheduledPortalTicks.add(runnable2);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void tickHead(CallbackInfo ci) {
        if (ModConfigs.ENTITY_YEETER.contains((class_1297)this) && !this.method_37908().field_9236) {
            this.method_31472();
            ci.cancel();
        }
        this.setInSafariPortal(false);
        if (this.hasSafariPortalCooldown() && !this.method_30230() && !this.isCollidingWithPortal()) {
            this.setSafariPortalCooldown(false);
        }
    }

    @Inject(method={"tickPortalCooldown"}, at={@At(value="HEAD")})
    public void tickPortal(CallbackInfo ci) {
        if (this.method_37908() instanceof class_3218) {
            this.scheduledPortalTicks.forEach(Runnable::run);
            this.scheduledPortalTicks.clear();
        }
    }

    @Inject(method={"writeNbt"}, at={@At(value="RETURN")})
    public void writeNbt(class_2487 nbt, CallbackInfoReturnable<class_2487> ci) {
        Adapters.BOOLEAN.writeNbt(this.inSafariPortal).ifPresent(tag -> nbt.method_10566("inSafariPortal", tag));
        Adapters.BOOLEAN.writeNbt(this.safariPortalCooldown).ifPresent(tag -> nbt.method_10566("safariPortalCooldown", tag));
    }

    @Inject(method={"readNbt"}, at={@At(value="RETURN")})
    public void readNbt(class_2487 nbt, CallbackInfo ci) {
        this.inSafariPortal = Adapters.BOOLEAN.readNbt(nbt.method_10580("inSafariPortal")).orElse(false);
        this.safariPortalCooldown = Adapters.BOOLEAN.readNbt(nbt.method_10580("safariPortalCooldown")).orElse(false);
    }

    private boolean isCollidingWithPortal() {
        class_238 box = this.method_5829();
        class_2338 blockPos = class_2338.method_49637((double)(box.field_1323 + 1.0E-7), (double)(box.field_1322 + 1.0E-7), (double)(box.field_1321 + 1.0E-7));
        class_2338 blockPos2 = class_2338.method_49637((double)(box.field_1320 - 1.0E-7), (double)(box.field_1325 - 1.0E-7), (double)(box.field_1324 - 1.0E-7));
        if (this.method_37908().method_22343(blockPos, blockPos2)) {
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int i = blockPos.method_10263(); i <= blockPos2.method_10263(); ++i) {
                for (int j = blockPos.method_10264(); j <= blockPos2.method_10264(); ++j) {
                    for (int k = blockPos.method_10260(); k <= blockPos2.method_10260(); ++k) {
                        mutable.method_10103(i, j, k);
                        class_2680 blockState = this.method_37908().method_8320((class_2338)mutable);
                        if (!(blockState.method_26204() instanceof SafariPortalBlock)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

