/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.math.roll;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.math.Rational;
import abeshutt.staracademy.math.random.RandomSource;
import abeshutt.staracademy.math.roll.ConstantNumberRoll;
import abeshutt.staracademy.math.roll.NumberRoll;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigInteger;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class UniformNumberRoll
extends NumberRoll {
    public final NumberRoll minimum;
    public final NumberRoll maximum;
    public final NumberRoll resolution;
    public final NumberRoll granularity;
    public final boolean minimumInclusive;
    public final boolean maximumInclusive;

    protected UniformNumberRoll(NumberRoll minimum, NumberRoll maximum, NumberRoll resolution, NumberRoll granularity, boolean minimumInclusive, boolean maximumInclusive) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.resolution = resolution;
        this.granularity = granularity;
        this.minimumInclusive = minimumInclusive;
        this.maximumInclusive = maximumInclusive;
    }

    public static UniformNumberRoll of(NumberRoll minimum, NumberRoll maximum, NumberRoll resolution, NumberRoll granularity, boolean minimumInclusive, boolean maximumInclusive) {
        return new UniformNumberRoll(minimum, maximum, resolution, granularity, minimumInclusive, maximumInclusive);
    }

    @Override
    public Rational get(RandomSource random) {
        Rational granularity;
        Rational resolution;
        Rational maximum;
        Rational minimum = this.minimum.get(random);
        if (minimum.equals(maximum = this.maximum.get(random))) {
            return minimum;
        }
        if (this.resolution != null && this.granularity != null) {
            resolution = this.resolution.get(random);
            granularity = this.granularity.get(random);
        } else if (this.resolution != null) {
            resolution = this.resolution.get(random);
            granularity = maximum.subtract(minimum).divide(resolution);
        } else if (this.granularity != null) {
            granularity = this.granularity.get(random);
            resolution = maximum.subtract(minimum).divide(granularity);
        } else {
            throw new UnsupportedOperationException();
        }
        Rational bound = granularity.floor();
        if (this.maximumInclusive && bound.equals(granularity)) {
            bound = bound.add(Rational.ONE);
        }
        if (!this.minimumInclusive) {
            bound = bound.subtract(Rational.ONE);
        }
        BigInteger index = random.nextBigInteger(bound.getNumerator());
        if (!this.minimumInclusive) {
            index = index.add(BigInteger.ONE);
        }
        return minimum.add(resolution.multiply(index));
    }

    protected static class Adapter
    implements ISimpleAdapter<UniformNumberRoll, class_2487, JsonObject> {
        public static final Adapter INSTANCE = new Adapter();

        protected Adapter() {
        }

        @Override
        public void writeBits(UniformNumberRoll value, BitBuffer buffer) {
            Adapters.NUMBER_ROLL.writeBits(value.minimum, buffer);
            Adapters.NUMBER_ROLL.writeBits(value.maximum, buffer);
            Adapters.NUMBER_ROLL.asNullable().writeBits(value.resolution, buffer);
            Adapters.NUMBER_ROLL.asNullable().writeBits(value.granularity, buffer);
            Adapters.BOOLEAN.writeBits(value.minimumInclusive, buffer);
            Adapters.BOOLEAN.writeBits(value.maximumInclusive, buffer);
        }

        @Override
        public Optional<UniformNumberRoll> readBits(BitBuffer buffer) {
            return Optional.of(UniformNumberRoll.of(Adapters.NUMBER_ROLL.readBits(buffer).orElseThrow(), Adapters.NUMBER_ROLL.readBits(buffer).orElseThrow(), Adapters.NUMBER_ROLL.asNullable().readBits(buffer).orElseThrow(), Adapters.NUMBER_ROLL.asNullable().readBits(buffer).orElseThrow(), Adapters.BOOLEAN.readBits(buffer).orElseThrow(), Adapters.BOOLEAN.readBits(buffer).orElseThrow()));
        }

        @Override
        public Optional<class_2487> writeNbt(UniformNumberRoll value) {
            if (value == null) {
                return Optional.empty();
            }
            return Optional.of(new class_2487()).map(nbt -> {
                Adapters.NUMBER_ROLL.writeNbt(value.minimum).ifPresent(tag -> nbt.method_10566(value.minimumInclusive ? "minimum_inclusive" : "minimum_exclusive", tag));
                Adapters.NUMBER_ROLL.writeNbt(value.maximum).ifPresent(tag -> nbt.method_10566(value.minimumInclusive ? "maximum_inclusive" : "maximum_exclusive", tag));
                if (value.resolution != null) {
                    Rational number;
                    NumberRoll patt0$temp = value.resolution;
                    if (patt0$temp instanceof ConstantNumberRoll) {
                        ConstantNumberRoll constant = (ConstantNumberRoll)patt0$temp;
                        v0 = constant.value;
                    } else {
                        v0 = number = null;
                    }
                    if (Rational.ONE.equals(number)) {
                        nbt.method_10566("resolution", (class_2520)class_2519.method_23256((String)"integer"));
                    } else if (Rational.FLOAT_EPSILON.equals(number)) {
                        nbt.method_10566("resolution", (class_2520)class_2519.method_23256((String)"float"));
                    } else if (Rational.DOUBLE_EPSILON.equals(number)) {
                        nbt.method_10566("resolution", (class_2520)class_2519.method_23256((String)"double"));
                    } else {
                        Adapters.NUMBER_ROLL.writeNbt(value.resolution).ifPresent(tag -> nbt.method_10566("resolution", tag));
                    }
                }
                if (value.granularity != null) {
                    Adapters.NUMBER_ROLL.writeNbt(value.granularity).ifPresent(tag -> nbt.method_10566("granularity", tag));
                }
                return nbt;
            });
        }

        @Override
        public Optional<UniformNumberRoll> readNbt(class_2487 nbt) {
            NumberRoll granularity;
            NumberRoll resolution;
            boolean maximumInclusive;
            NumberRoll maximum;
            boolean minimumInclusive;
            NumberRoll minimum;
            if (nbt.method_10545("minimum_inclusive") && nbt.method_10545("minimum_exclusive")) {
                throw new RuntimeException("roll cannot contain both 'minimum_inclusive' and 'minimum_exclusive'");
            }
            if (nbt.method_10545("minimum_inclusive")) {
                minimum = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("minimum_inclusive")).orElseThrow();
                minimumInclusive = true;
            } else if (nbt.method_10545("minimum_exclusive")) {
                minimum = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("minimum_exclusive")).orElseThrow();
                minimumInclusive = false;
            } else {
                throw new RuntimeException("roll needs either 'minimum_inclusive' or 'minimum_exclusive'");
            }
            if (nbt.method_10545("maximum_inclusive") && nbt.method_10545("maximum_exclusive")) {
                throw new RuntimeException("roll cannot contain both 'maximum_inclusive' and 'maximum_exclusive'");
            }
            if (nbt.method_10545("maximum_inclusive")) {
                maximum = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("maximum_inclusive")).orElseThrow();
                maximumInclusive = true;
            } else if (nbt.method_10545("maximum_exclusive")) {
                maximum = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("maximum_exclusive")).orElseThrow();
                maximumInclusive = false;
            } else {
                throw new RuntimeException("roll needs either 'maximum_inclusive' or 'maximum_exclusive'");
            }
            if (nbt.method_10545("resolution") && nbt.method_10545("granularity")) {
                throw new RuntimeException("roll cannot contain both 'resolution' and 'granularity'");
            }
            if (nbt.method_10545("resolution")) {
                Object object = nbt.method_10580("resolution");
                if (object instanceof class_2519) {
                    class_2519 primitive = (class_2519)object;
                    resolution = switch (primitive.method_10714()) {
                        case "integer" -> NumberRoll.constant(Rational.ONE);
                        case "float" -> NumberRoll.constant(Rational.FLOAT_EPSILON);
                        case "double" -> NumberRoll.constant(Rational.DOUBLE_EPSILON);
                        default -> Adapters.NUMBER_ROLL.readNbt((class_2520)primitive).orElseThrow();
                    };
                } else {
                    resolution = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("resolution")).orElseThrow();
                }
                granularity = null;
            } else if (nbt.method_10545("granularity")) {
                granularity = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("granularity")).orElseThrow();
                resolution = null;
            } else {
                throw new RuntimeException("roll needs either 'resolution' or 'granularity'");
            }
            return Optional.of(UniformNumberRoll.of(minimum, maximum, resolution, granularity, minimumInclusive, maximumInclusive));
        }

        @Override
        public Optional<JsonObject> writeJson(UniformNumberRoll value) {
            if (value == null) {
                return Optional.empty();
            }
            return Optional.of(new JsonObject()).map(json -> {
                Adapters.NUMBER_ROLL.writeJson(value.minimum).ifPresent(tag -> json.add(value.minimumInclusive ? "minimum_inclusive" : "minimum_exclusive", tag));
                Adapters.NUMBER_ROLL.writeJson(value.maximum).ifPresent(tag -> json.add(value.minimumInclusive ? "maximum_inclusive" : "maximum_exclusive", tag));
                if (value.resolution != null) {
                    Rational number;
                    NumberRoll patt0$temp = value.resolution;
                    if (patt0$temp instanceof ConstantNumberRoll) {
                        ConstantNumberRoll constant = (ConstantNumberRoll)patt0$temp;
                        v0 = constant.value;
                    } else {
                        v0 = number = null;
                    }
                    if (Rational.ONE.equals(number)) {
                        json.addProperty("resolution", "integer");
                    } else if (Rational.FLOAT_EPSILON.equals(number)) {
                        json.addProperty("resolution", "float");
                    } else if (Rational.DOUBLE_EPSILON.equals(number)) {
                        json.addProperty("resolution", "double");
                    } else {
                        Adapters.NUMBER_ROLL.writeJson(value.resolution).ifPresent(tag -> json.add("resolution", tag));
                    }
                }
                if (value.granularity != null) {
                    Adapters.NUMBER_ROLL.writeJson(value.granularity).ifPresent(tag -> json.add("granularity", tag));
                }
                return json;
            });
        }

        @Override
        public Optional<UniformNumberRoll> readJson(JsonObject json) {
            NumberRoll granularity;
            NumberRoll resolution;
            boolean maximumInclusive;
            NumberRoll maximum;
            boolean minimumInclusive;
            NumberRoll minimum;
            if (json.has("minimum_inclusive") && json.has("minimum_exclusive")) {
                throw new RuntimeException("roll cannot contain both 'minimum_inclusive' and 'minimum_exclusive'");
            }
            if (json.has("minimum_inclusive")) {
                minimum = Adapters.NUMBER_ROLL.readJson(json.get("minimum_inclusive")).orElseThrow();
                minimumInclusive = true;
            } else if (json.has("minimum_exclusive")) {
                minimum = Adapters.NUMBER_ROLL.readJson(json.get("minimum_exclusive")).orElseThrow();
                minimumInclusive = false;
            } else {
                throw new RuntimeException("roll needs either 'minimum_inclusive' or 'minimum_exclusive'");
            }
            if (json.has("maximum_inclusive") && json.has("maximum_exclusive")) {
                throw new RuntimeException("roll cannot contain both 'maximum_inclusive' and 'maximum_exclusive'");
            }
            if (json.has("maximum_inclusive")) {
                maximum = Adapters.NUMBER_ROLL.readJson(json.get("maximum_inclusive")).orElseThrow();
                maximumInclusive = true;
            } else if (json.has("maximum_exclusive")) {
                maximum = Adapters.NUMBER_ROLL.readJson(json.get("maximum_exclusive")).orElseThrow();
                maximumInclusive = false;
            } else {
                throw new RuntimeException("roll needs either 'maximum_inclusive' or 'maximum_exclusive'");
            }
            if (json.has("resolution") && json.has("granularity")) {
                throw new RuntimeException("roll cannot contain both 'resolution' and 'granularity'");
            }
            if (json.has("resolution")) {
                JsonPrimitive primitive;
                Object object = json.get("resolution");
                if (object instanceof JsonPrimitive && (primitive = (JsonPrimitive)object).isString()) {
                    resolution = switch (primitive.getAsString()) {
                        case "integer" -> NumberRoll.constant(Rational.ONE);
                        case "float" -> NumberRoll.constant(Rational.FLOAT_EPSILON);
                        case "double" -> NumberRoll.constant(Rational.DOUBLE_EPSILON);
                        default -> Adapters.NUMBER_ROLL.readJson((JsonElement)primitive).orElseThrow();
                    };
                } else {
                    resolution = Adapters.NUMBER_ROLL.readJson(json.get("resolution")).orElseThrow();
                }
                granularity = null;
            } else if (json.has("granularity")) {
                granularity = Adapters.NUMBER_ROLL.readJson(json.get("granularity")).orElseThrow();
                resolution = null;
            } else {
                throw new RuntimeException("roll needs either 'resolution' or 'granularity'");
            }
            return Optional.of(UniformNumberRoll.of(minimum, maximum, resolution, granularity, minimumInclusive, maximumInclusive));
        }
    }
}

