/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.math.roll;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.math.Rational;
import abeshutt.staracademy.math.random.RandomSource;
import abeshutt.staracademy.math.roll.ConstantNumberRoll;
import abeshutt.staracademy.math.roll.NumberRoll;
import abeshutt.staracademy.math.roll.UniformNumberRoll;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class TrapezoidalNumberRoll
extends NumberRoll {
    public final NumberRoll minimum;
    public final NumberRoll maximum;
    public final NumberRoll modeMinimum;
    public final NumberRoll modeMaximum;
    public final NumberRoll resolution;
    public final NumberRoll granularity;
    public final NumberRoll precision;
    public final boolean minimumInclusive;
    public final boolean maximumInclusive;

    protected TrapezoidalNumberRoll(NumberRoll minimum, NumberRoll maximum, NumberRoll modeMinimum, NumberRoll modeMaximum, NumberRoll resolution, NumberRoll granularity, NumberRoll precision, boolean minimumInclusive, boolean maximumInclusive) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.modeMinimum = modeMinimum;
        this.modeMaximum = modeMaximum;
        this.resolution = resolution;
        this.granularity = granularity;
        this.precision = precision;
        this.minimumInclusive = minimumInclusive;
        this.maximumInclusive = maximumInclusive;
    }

    public static TrapezoidalNumberRoll of(NumberRoll minimum, NumberRoll maximum, NumberRoll modeMinimum, NumberRoll modeMaximum, NumberRoll resolution, NumberRoll granularity, NumberRoll precision, boolean minimumInclusive, boolean maximumInclusive) {
        return new TrapezoidalNumberRoll(minimum, maximum, modeMinimum, modeMaximum, resolution, granularity, precision, minimumInclusive, maximumInclusive);
    }

    @Override
    public Rational get(RandomSource random) {
        Rational precise;
        Rational minimum = this.minimum.get(random);
        Rational maximum = this.maximum.get(random);
        Rational precision = this.precision.get(random);
        Rational resolution = this.resolution != null ? this.resolution.get(random) : null;
        Rational granularity = this.granularity != null ? this.granularity.get(random) : null;
        Rational modeMinimum = this.modeMinimum.get(random);
        Rational modeMaximum = this.modeMaximum.get(random);
        if (this.resolution != null) {
            granularity = maximum.subtract(minimum).divide(resolution);
        } else if (this.granularity != null) {
            resolution = maximum.subtract(minimum).divide(granularity);
        } else {
            throw new UnsupportedOperationException();
        }
        Rational sample = UniformNumberRoll.of(NumberRoll.constant(minimum), NumberRoll.constant(maximum), NumberRoll.constant(resolution.divide(precision)), NumberRoll.constant(granularity.multiply(precision)), this.minimumInclusive, this.maximumInclusive).get(random);
        Rational areaLeft = modeMinimum.subtract(minimum);
        Rational areaCenter = modeMaximum.subtract(modeMinimum).multiply(Rational.TWO);
        Rational areaRight = maximum.subtract(modeMaximum);
        Rational areaTotal = areaLeft.add(areaCenter).add(areaRight);
        sample = sample.subtract(minimum).divide(maximum.subtract(minimum)).multiply(areaTotal);
        if (sample.compareTo(areaLeft) < 0) {
            UniformNumberRoll left = UniformNumberRoll.of(NumberRoll.constant(minimum), NumberRoll.constant(modeMinimum), NumberRoll.constant(resolution), NumberRoll.constant(granularity), this.minimumInclusive, false);
            precise = ((NumberRoll)left).get(random).max(((NumberRoll)left).get(random));
        } else if (areaTotal.subtract(sample).compareTo(areaRight) < 0) {
            UniformNumberRoll right = UniformNumberRoll.of(NumberRoll.constant(modeMaximum), NumberRoll.constant(maximum), NumberRoll.constant(resolution), NumberRoll.constant(granularity), false, this.maximumInclusive);
            precise = ((NumberRoll)right).get(random).min(((NumberRoll)right).get(random));
        } else {
            UniformNumberRoll center = UniformNumberRoll.of(NumberRoll.constant(modeMaximum), NumberRoll.constant(maximum), NumberRoll.constant(resolution), NumberRoll.constant(granularity), true, true);
            precise = ((NumberRoll)center).get(random);
        }
        Rational scalar = precise.subtract(minimum).divide(resolution).round();
        return minimum.add(resolution.multiply(scalar));
    }

    protected static class Adapter
    implements ISimpleAdapter<TrapezoidalNumberRoll, class_2487, JsonObject> {
        public static final Adapter INSTANCE = new Adapter();

        protected Adapter() {
        }

        @Override
        public void writeBits(TrapezoidalNumberRoll value, BitBuffer buffer) {
            Adapters.NUMBER_ROLL.writeBits(value.minimum, buffer);
            Adapters.NUMBER_ROLL.writeBits(value.maximum, buffer);
            Adapters.NUMBER_ROLL.writeBits(value.modeMinimum, buffer);
            Adapters.NUMBER_ROLL.writeBits(value.modeMaximum, buffer);
            Adapters.NUMBER_ROLL.asNullable().writeBits(value.resolution, buffer);
            Adapters.NUMBER_ROLL.asNullable().writeBits(value.granularity, buffer);
            Adapters.NUMBER_ROLL.writeBits(value.precision, buffer);
            Adapters.BOOLEAN.writeBits(value.minimumInclusive, buffer);
            Adapters.BOOLEAN.writeBits(value.maximumInclusive, buffer);
        }

        @Override
        public Optional<TrapezoidalNumberRoll> readBits(BitBuffer buffer) {
            return Optional.of(TrapezoidalNumberRoll.of(Adapters.NUMBER_ROLL.readBits(buffer).orElseThrow(), Adapters.NUMBER_ROLL.readBits(buffer).orElseThrow(), Adapters.NUMBER_ROLL.readBits(buffer).orElseThrow(), Adapters.NUMBER_ROLL.readBits(buffer).orElseThrow(), Adapters.NUMBER_ROLL.asNullable().readBits(buffer).orElseThrow(), Adapters.NUMBER_ROLL.asNullable().readBits(buffer).orElseThrow(), Adapters.NUMBER_ROLL.readBits(buffer).orElseThrow(), Adapters.BOOLEAN.readBits(buffer).orElseThrow(), Adapters.BOOLEAN.readBits(buffer).orElseThrow()));
        }

        @Override
        public Optional<class_2487> writeNbt(TrapezoidalNumberRoll value) {
            if (value == null) {
                return Optional.empty();
            }
            return Optional.of(new class_2487()).map(nbt -> {
                block16: {
                    block15: {
                        NumberRoll patt0$temp;
                        Adapters.NUMBER_ROLL.writeNbt(value.minimum).ifPresent(tag -> nbt.method_10566(value.minimumInclusive ? "minimum_inclusive" : "minimum_exclusive", tag));
                        Adapters.NUMBER_ROLL.writeNbt(value.maximum).ifPresent(tag -> nbt.method_10566(value.minimumInclusive ? "maximum_inclusive" : "maximum_exclusive", tag));
                        if (value.modeMinimum.equals(value.modeMaximum)) {
                            Adapters.NUMBER_ROLL.writeNbt(value.modeMinimum).ifPresent(tag -> nbt.method_10566("mode", tag));
                        } else {
                            Adapters.NUMBER_ROLL.writeNbt(value.modeMinimum).ifPresent(tag -> nbt.method_10566("mode_minimum", tag));
                            Adapters.NUMBER_ROLL.writeNbt(value.modeMaximum).ifPresent(tag -> nbt.method_10566("mode_maximum", tag));
                        }
                        if (value.resolution != null) {
                            Rational number;
                            NumberRoll patt0$temp2 = value.resolution;
                            if (patt0$temp2 instanceof ConstantNumberRoll) {
                                ConstantNumberRoll constant = (ConstantNumberRoll)patt0$temp2;
                                v0 = constant.value;
                            } else {
                                v0 = number = null;
                            }
                            if (Rational.ONE.equals(number)) {
                                nbt.method_10566("resolution", (class_2520)class_2519.method_23256((String)"integer"));
                            } else if (Rational.FLOAT_EPSILON.equals(number)) {
                                nbt.method_10566("resolution", (class_2520)class_2519.method_23256((String)"float"));
                            } else if (Rational.DOUBLE_EPSILON.equals(number)) {
                                nbt.method_10566("resolution", (class_2520)class_2519.method_23256((String)"double"));
                            } else {
                                Adapters.NUMBER_ROLL.writeNbt(value.resolution).ifPresent(tag -> nbt.method_10566("resolution", tag));
                            }
                        }
                        if (value.granularity != null) {
                            Adapters.NUMBER_ROLL.writeNbt(value.granularity).ifPresent(tag -> nbt.method_10566("granularity", tag));
                        }
                        if (!((patt0$temp = value.precision) instanceof ConstantNumberRoll)) break block15;
                        ConstantNumberRoll precision = (ConstantNumberRoll)patt0$temp;
                        if (precision.value.equals(Rational.of(10L))) break block16;
                    }
                    Adapters.NUMBER_ROLL.writeNbt(value.precision).ifPresent(tag -> nbt.method_10566("precision", tag));
                }
                return nbt;
            });
        }

        @Override
        public Optional<TrapezoidalNumberRoll> readNbt(class_2487 nbt) {
            NumberRoll granularity;
            NumberRoll resolution;
            NumberRoll modeMaximum;
            NumberRoll modeMinimum;
            boolean maximumInclusive;
            NumberRoll maximum;
            boolean minimumInclusive;
            NumberRoll minimum;
            if (nbt.method_10545("minimum_inclusive") && nbt.method_10545("minimum_exclusive")) {
                throw new RuntimeException("roll cannot contain both 'minimum_inclusive' and 'minimum_exclusive'");
            }
            if (nbt.method_10545("minimum_inclusive")) {
                minimum = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("minimum_inclusive")).orElseThrow();
                minimumInclusive = true;
            } else if (nbt.method_10545("minimum_exclusive")) {
                minimum = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("minimum_exclusive")).orElseThrow();
                minimumInclusive = false;
            } else {
                throw new RuntimeException("roll needs either 'minimum_inclusive' or 'minimum_exclusive'");
            }
            if (nbt.method_10545("maximum_inclusive") && nbt.method_10545("maximum_exclusive")) {
                throw new RuntimeException("roll cannot contain both 'maximum_inclusive' and 'maximum_exclusive'");
            }
            if (nbt.method_10545("maximum_inclusive")) {
                maximum = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("maximum_inclusive")).orElseThrow();
                maximumInclusive = true;
            } else if (nbt.method_10545("maximum_exclusive")) {
                maximum = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("maximum_exclusive")).orElseThrow();
                maximumInclusive = false;
            } else {
                throw new RuntimeException("roll needs either 'maximum_inclusive' or 'maximum_exclusive'");
            }
            if (nbt.method_10545("mode")) {
                if (nbt.method_10545("mode_minimum") || nbt.method_10545("mode_maximum")) {
                    throw new RuntimeException("roll already includes 'mode'");
                }
                modeMaximum = modeMinimum = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("mode")).orElseThrow();
            } else {
                if (!nbt.method_10545("mode_minimum") || !nbt.method_10545("mode_maximum")) {
                    throw new RuntimeException("roll needs both 'mode_minimum' and 'mode_maximum'");
                }
                modeMinimum = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("mode_minimum")).orElseThrow();
                modeMaximum = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("mode_maximum")).orElseThrow();
            }
            if (nbt.method_10545("resolution") && nbt.method_10545("granularity")) {
                throw new RuntimeException("roll cannot contain both 'resolution' and 'granularity'");
            }
            if (nbt.method_10545("resolution")) {
                Object object = nbt.method_10580("resolution");
                if (object instanceof class_2519) {
                    class_2519 primitive = (class_2519)object;
                    resolution = switch (primitive.method_10714()) {
                        case "integer" -> NumberRoll.constant(Rational.ONE);
                        case "float" -> NumberRoll.constant(Rational.FLOAT_EPSILON);
                        case "double" -> NumberRoll.constant(Rational.DOUBLE_EPSILON);
                        default -> Adapters.NUMBER_ROLL.readNbt((class_2520)primitive).orElseThrow();
                    };
                } else {
                    resolution = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("resolution")).orElseThrow();
                }
                granularity = null;
            } else if (nbt.method_10545("granularity")) {
                granularity = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("granularity")).orElseThrow();
                resolution = null;
            } else {
                throw new RuntimeException("roll needs either 'resolution' or 'granularity'");
            }
            NumberRoll precision = Adapters.NUMBER_ROLL.readNbt(nbt.method_10580("precision")).orElseGet(() -> NumberRoll.constant(Rational.of(10L)));
            return Optional.of(TrapezoidalNumberRoll.of(minimum, maximum, modeMinimum, modeMaximum, resolution, granularity, precision, minimumInclusive, maximumInclusive));
        }

        @Override
        public Optional<JsonObject> writeJson(TrapezoidalNumberRoll value) {
            if (value == null) {
                return Optional.empty();
            }
            return Optional.of(new JsonObject()).map(json -> {
                block16: {
                    block15: {
                        NumberRoll patt0$temp;
                        Adapters.NUMBER_ROLL.writeJson(value.minimum).ifPresent(tag -> json.add(value.minimumInclusive ? "minimum_inclusive" : "minimum_exclusive", tag));
                        Adapters.NUMBER_ROLL.writeJson(value.maximum).ifPresent(tag -> json.add(value.minimumInclusive ? "maximum_inclusive" : "maximum_exclusive", tag));
                        if (value.modeMinimum.equals(value.modeMaximum)) {
                            Adapters.NUMBER_ROLL.writeJson(value.modeMinimum).ifPresent(tag -> json.add("mode", tag));
                        } else {
                            Adapters.NUMBER_ROLL.writeJson(value.modeMinimum).ifPresent(tag -> json.add("mode_minimum", tag));
                            Adapters.NUMBER_ROLL.writeJson(value.modeMaximum).ifPresent(tag -> json.add("mode_maximum", tag));
                        }
                        if (value.resolution != null) {
                            Rational number;
                            NumberRoll patt0$temp2 = value.resolution;
                            if (patt0$temp2 instanceof ConstantNumberRoll) {
                                ConstantNumberRoll constant = (ConstantNumberRoll)patt0$temp2;
                                v0 = constant.value;
                            } else {
                                v0 = number = null;
                            }
                            if (Rational.ONE.equals(number)) {
                                json.addProperty("resolution", "integer");
                            } else if (Rational.FLOAT_EPSILON.equals(number)) {
                                json.addProperty("resolution", "float");
                            } else if (Rational.DOUBLE_EPSILON.equals(number)) {
                                json.addProperty("resolution", "double");
                            } else {
                                Adapters.NUMBER_ROLL.writeJson(value.resolution).ifPresent(tag -> json.add("resolution", tag));
                            }
                        }
                        if (value.granularity != null) {
                            Adapters.NUMBER_ROLL.writeJson(value.granularity).ifPresent(tag -> json.add("granularity", tag));
                        }
                        if (!((patt0$temp = value.precision) instanceof ConstantNumberRoll)) break block15;
                        ConstantNumberRoll precision = (ConstantNumberRoll)patt0$temp;
                        if (precision.value.equals(Rational.of(10L))) break block16;
                    }
                    Adapters.NUMBER_ROLL.writeJson(value.precision).ifPresent(tag -> json.add("precision", tag));
                }
                return json;
            });
        }

        @Override
        public Optional<TrapezoidalNumberRoll> readJson(JsonObject json) {
            NumberRoll granularity;
            NumberRoll resolution;
            NumberRoll modeMaximum;
            NumberRoll modeMinimum;
            boolean maximumInclusive;
            NumberRoll maximum;
            boolean minimumInclusive;
            NumberRoll minimum;
            if (json.has("minimum_inclusive") && json.has("minimum_exclusive")) {
                throw new RuntimeException("roll cannot contain both 'minimum_inclusive' and 'minimum_exclusive'");
            }
            if (json.has("minimum_inclusive")) {
                minimum = Adapters.NUMBER_ROLL.readJson(json.get("minimum_inclusive")).orElseThrow();
                minimumInclusive = true;
            } else if (json.has("minimum_exclusive")) {
                minimum = Adapters.NUMBER_ROLL.readJson(json.get("minimum_exclusive")).orElseThrow();
                minimumInclusive = false;
            } else {
                throw new RuntimeException("roll needs either 'minimum_inclusive' or 'minimum_exclusive'");
            }
            if (json.has("maximum_inclusive") && json.has("maximum_exclusive")) {
                throw new RuntimeException("roll cannot contain both 'maximum_inclusive' and 'maximum_exclusive'");
            }
            if (json.has("maximum_inclusive")) {
                maximum = Adapters.NUMBER_ROLL.readJson(json.get("maximum_inclusive")).orElseThrow();
                maximumInclusive = true;
            } else if (json.has("maximum_exclusive")) {
                maximum = Adapters.NUMBER_ROLL.readJson(json.get("maximum_exclusive")).orElseThrow();
                maximumInclusive = false;
            } else {
                throw new RuntimeException("roll needs either 'maximum_inclusive' or 'maximum_exclusive'");
            }
            if (json.has("mode")) {
                if (json.has("mode_minimum") || json.has("mode_maximum")) {
                    throw new RuntimeException("roll already includes 'mode'");
                }
                modeMaximum = modeMinimum = Adapters.NUMBER_ROLL.readJson(json.get("mode")).orElseThrow();
            } else {
                if (!json.has("mode_minimum") || !json.has("mode_maximum")) {
                    throw new RuntimeException("roll needs both 'mode_minimum' and 'mode_maximum'");
                }
                modeMinimum = Adapters.NUMBER_ROLL.readJson(json.get("mode_minimum")).orElseThrow();
                modeMaximum = Adapters.NUMBER_ROLL.readJson(json.get("mode_maximum")).orElseThrow();
            }
            if (json.has("resolution") && json.has("granularity")) {
                throw new RuntimeException("roll cannot contain both 'resolution' and 'granularity'");
            }
            if (json.has("resolution")) {
                JsonPrimitive primitive;
                Object object = json.get("resolution");
                if (object instanceof JsonPrimitive && (primitive = (JsonPrimitive)object).isString()) {
                    resolution = switch (primitive.getAsString()) {
                        case "integer" -> NumberRoll.constant(Rational.ONE);
                        case "float" -> NumberRoll.constant(Rational.FLOAT_EPSILON);
                        case "double" -> NumberRoll.constant(Rational.DOUBLE_EPSILON);
                        default -> Adapters.NUMBER_ROLL.readJson((JsonElement)primitive).orElseThrow();
                    };
                } else {
                    resolution = Adapters.NUMBER_ROLL.readJson(json.get("resolution")).orElseThrow();
                }
                granularity = null;
            } else if (json.has("granularity")) {
                granularity = Adapters.NUMBER_ROLL.readJson(json.get("granularity")).orElseThrow();
                resolution = null;
            } else {
                throw new RuntimeException("roll needs either 'resolution' or 'granularity'");
            }
            NumberRoll precision = Adapters.NUMBER_ROLL.readJson(json.get("precision")).orElseGet(() -> NumberRoll.constant(Rational.of(10L)));
            return Optional.of(TrapezoidalNumberRoll.of(minimum, maximum, modeMinimum, modeMaximum, resolution, granularity, precision, minimumInclusive, maximumInclusive));
        }
    }
}

