/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.math.roll;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.math.Rational;
import abeshutt.staracademy.math.random.RandomSource;
import abeshutt.staracademy.math.roll.ConstantNumberRoll;
import abeshutt.staracademy.math.roll.TrapezoidalNumberRoll;
import abeshutt.staracademy.math.roll.UniformNumberRoll;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public abstract class NumberRoll
implements ISerializable<class_2487, JsonObject> {
    public abstract Rational get(RandomSource var1);

    public static NumberRoll constant(Number value) {
        return ConstantNumberRoll.of(Rational.of(value));
    }

    public static NumberRoll constant(Number numerator, Number denominator) {
        return NumberRoll.constant(Rational.of(numerator, denominator));
    }

    public static NumberRoll uniformII(long min, long max) {
        return NumberRoll.uniformResolutionII(min, max, 1);
    }

    public static NumberRoll uniformIE(long min, long max) {
        return NumberRoll.uniformResolutionIE(min, max, 1);
    }

    public static NumberRoll uniformEI(long min, long max) {
        return NumberRoll.uniformResolutionEI(min, max, 1);
    }

    public static NumberRoll uniformEE(long min, long max) {
        return NumberRoll.uniformResolutionEE(min, max, 1);
    }

    public static NumberRoll uniformII(float min, float max) {
        return NumberRoll.uniformResolutionII(Float.valueOf(min), Float.valueOf(max), Rational.FLOAT_EPSILON);
    }

    public static NumberRoll uniformIE(float min, float max) {
        return NumberRoll.uniformResolutionIE(Float.valueOf(min), Float.valueOf(max), Rational.FLOAT_EPSILON);
    }

    public static NumberRoll uniformEI(float min, float max) {
        return NumberRoll.uniformResolutionEI(Float.valueOf(min), Float.valueOf(max), Rational.FLOAT_EPSILON);
    }

    public static NumberRoll uniformEE(float min, float max) {
        return NumberRoll.uniformResolutionEE(Float.valueOf(min), Float.valueOf(max), Rational.FLOAT_EPSILON);
    }

    public static NumberRoll uniformII(double min, double max) {
        return NumberRoll.uniformResolutionII(min, max, Rational.DOUBLE_EPSILON);
    }

    public static NumberRoll uniformIE(double min, double max) {
        return NumberRoll.uniformResolutionIE(min, max, Rational.DOUBLE_EPSILON);
    }

    public static NumberRoll uniformEI(double min, double max) {
        return NumberRoll.uniformResolutionEI(min, max, Rational.DOUBLE_EPSILON);
    }

    public static NumberRoll uniformEE(double min, double max) {
        return NumberRoll.uniformResolutionEE(min, max, Rational.DOUBLE_EPSILON);
    }

    public static NumberRoll uniformResolutionII(Number min, Number max, Number resolution) {
        return NumberRoll.uniformResolution(min, max, resolution, true, true);
    }

    public static NumberRoll uniformResolutionIE(Number min, Number max, Number resolution) {
        return NumberRoll.uniformResolution(min, max, resolution, true, false);
    }

    public static NumberRoll uniformResolutionEI(Number min, Number max, Number resolution) {
        return NumberRoll.uniformResolution(min, max, resolution, false, true);
    }

    public static NumberRoll uniformResolutionEE(Number min, Number max, Number resolution) {
        return NumberRoll.uniformResolution(min, max, resolution, false, false);
    }

    public static NumberRoll uniformResolution(Number min, Number max, Number resolution, boolean minInclusive, boolean maxInclusive) {
        return UniformNumberRoll.of(NumberRoll.constant(min), NumberRoll.constant(max), NumberRoll.constant(resolution), null, minInclusive, maxInclusive);
    }

    public static NumberRoll uniformGranularityII(Number min, Number max, Number resolution) {
        return NumberRoll.uniformGranularity(min, max, resolution, true, true);
    }

    public static NumberRoll uniformGranularityIE(Number min, Number max, Number resolution) {
        return NumberRoll.uniformGranularity(min, max, resolution, true, false);
    }

    public static NumberRoll uniformGranularityEI(Number min, Number max, Number resolution) {
        return NumberRoll.uniformGranularity(min, max, resolution, false, true);
    }

    public static NumberRoll uniformGranularityEE(Number min, Number max, Number resolution) {
        return NumberRoll.uniformGranularity(min, max, resolution, false, false);
    }

    public static NumberRoll uniformGranularity(Number min, Number max, Number granularity, boolean minInclusive, boolean maxInclusive) {
        return UniformNumberRoll.of(NumberRoll.constant(min), NumberRoll.constant(max), null, NumberRoll.constant(granularity), minInclusive, maxInclusive);
    }

    public static class Adapter
    implements ISimpleAdapter<NumberRoll, class_2520, JsonElement> {
        private final boolean nullable;

        public Adapter(boolean nullable) {
            this.nullable = nullable;
        }

        public Adapter asNullable() {
            return new Adapter(true);
        }

        @Override
        public void writeBits(NumberRoll value, BitBuffer buffer) {
            if (this.nullable) {
                Adapters.BOOLEAN.writeBits(value == null, buffer);
            }
            if (value != null) {
                NumberRoll numberRoll = value;
                Objects.requireNonNull(numberRoll);
                NumberRoll numberRoll2 = numberRoll;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantNumberRoll.class, UniformNumberRoll.class, TrapezoidalNumberRoll.class}, (Object)numberRoll2, n)) {
                    case 0: {
                        ConstantNumberRoll constant = (ConstantNumberRoll)numberRoll2;
                        Adapters.BYTE.writeBits((byte)0, buffer);
                        ConstantNumberRoll.Adapter.INSTANCE.writeBits(constant, buffer);
                        break;
                    }
                    case 1: {
                        UniformNumberRoll uniform = (UniformNumberRoll)numberRoll2;
                        Adapters.BYTE.writeBits((byte)1, buffer);
                        UniformNumberRoll.Adapter.INSTANCE.writeBits(uniform, buffer);
                        break;
                    }
                    case 2: {
                        TrapezoidalNumberRoll trapezoid = (TrapezoidalNumberRoll)numberRoll2;
                        Adapters.BYTE.writeBits((byte)2, buffer);
                        TrapezoidalNumberRoll.Adapter.INSTANCE.writeBits(trapezoid, buffer);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }

        @Override
        public Optional<NumberRoll> readBits(BitBuffer buffer) {
            if (this.nullable && Adapters.BOOLEAN.readBits(buffer).orElseThrow().booleanValue()) {
                return Optional.empty();
            }
            return Optional.of(switch ((Byte)Adapters.BYTE.readBits(buffer).orElseThrow()) {
                case 0 -> ConstantNumberRoll.Adapter.INSTANCE.readBits(buffer).orElseThrow();
                case 1 -> UniformNumberRoll.Adapter.INSTANCE.readBits(buffer).orElseThrow();
                case 2 -> TrapezoidalNumberRoll.Adapter.INSTANCE.readBits(buffer).orElseThrow();
                default -> throw new UnsupportedOperationException();
            });
        }

        @Override
        public Optional<class_2520> writeNbt(NumberRoll value) {
            NumberRoll numberRoll = value;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantNumberRoll.class, UniformNumberRoll.class, TrapezoidalNumberRoll.class}, (Object)numberRoll, n)) {
                case -1 -> Optional.empty();
                case 0 -> {
                    ConstantNumberRoll constant = (ConstantNumberRoll)numberRoll;
                    yield ConstantNumberRoll.Adapter.INSTANCE.writeNbt(constant).map(json -> {
                        if (json instanceof class_2487) {
                            class_2487 object = (class_2487)json;
                            object.method_10582("type", "constant");
                        }
                        return json;
                    });
                }
                case 1 -> {
                    UniformNumberRoll uniform = (UniformNumberRoll)numberRoll;
                    yield UniformNumberRoll.Adapter.INSTANCE.writeNbt(uniform).map(json -> {
                        json.method_10582("type", "uniform");
                        return json;
                    });
                }
                case 2 -> {
                    TrapezoidalNumberRoll trapezoid = (TrapezoidalNumberRoll)numberRoll;
                    yield TrapezoidalNumberRoll.Adapter.INSTANCE.writeNbt(trapezoid).map(json -> {
                        if (json.method_10545("mode")) {
                            json.method_10582("type", "triangular");
                        } else {
                            json.method_10582("type", "trapezoidal");
                        }
                        return json;
                    });
                }
                default -> throw new UnsupportedOperationException();
            };
        }

        @Override
        public Optional<NumberRoll> readNbt(class_2520 nbt) {
            if (nbt instanceof class_2487) {
                class_2487 object = (class_2487)nbt;
                return (switch (object.method_10558("type")) {
                    case "constant" -> ConstantNumberRoll.Adapter.INSTANCE.readNbt((class_2520)object);
                    case "uniform" -> UniformNumberRoll.Adapter.INSTANCE.readNbt(object);
                    case "triangular", "trapezoidal" -> TrapezoidalNumberRoll.Adapter.INSTANCE.readNbt(object);
                    default -> throw new UnsupportedOperationException();
                }).map(Function.identity());
            }
            return ConstantNumberRoll.Adapter.INSTANCE.readNbt(nbt).map(Function.identity());
        }

        @Override
        public Optional<JsonElement> writeJson(NumberRoll value) {
            NumberRoll numberRoll = value;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantNumberRoll.class, UniformNumberRoll.class, TrapezoidalNumberRoll.class}, (Object)numberRoll, n)) {
                case -1 -> Optional.empty();
                case 0 -> {
                    ConstantNumberRoll constant = (ConstantNumberRoll)numberRoll;
                    yield ConstantNumberRoll.Adapter.INSTANCE.writeJson(constant).map(json -> {
                        if (json instanceof JsonObject) {
                            JsonObject object = (JsonObject)json;
                            object.addProperty("type", "constant");
                        }
                        return json;
                    });
                }
                case 1 -> {
                    UniformNumberRoll uniform = (UniformNumberRoll)numberRoll;
                    yield UniformNumberRoll.Adapter.INSTANCE.writeJson(uniform).map(json -> {
                        json.addProperty("type", "uniform");
                        return json;
                    });
                }
                case 2 -> {
                    TrapezoidalNumberRoll trapezoid = (TrapezoidalNumberRoll)numberRoll;
                    yield TrapezoidalNumberRoll.Adapter.INSTANCE.writeJson(trapezoid).map(json -> {
                        if (json.has("mode")) {
                            json.addProperty("type", "triangular");
                        } else {
                            json.addProperty("type", "trapezoidal");
                        }
                        return json;
                    });
                }
                default -> throw new UnsupportedOperationException();
            };
        }

        @Override
        public Optional<NumberRoll> readJson(JsonElement json) {
            if (json instanceof JsonObject) {
                JsonObject object = (JsonObject)json;
                return (switch (object.get("type").getAsString()) {
                    case "constant" -> ConstantNumberRoll.Adapter.INSTANCE.readJson((JsonElement)object);
                    case "uniform" -> UniformNumberRoll.Adapter.INSTANCE.readJson(object);
                    case "triangular", "trapezoidal" -> TrapezoidalNumberRoll.Adapter.INSTANCE.readJson(object);
                    default -> throw new UnsupportedOperationException();
                }).map(Function.identity());
            }
            return ConstantNumberRoll.Adapter.INSTANCE.readJson(json).map(Function.identity());
        }
    }
}

