/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.math.random;

import abeshutt.staracademy.math.random.RandomSource;

public abstract class XoroshiroRandom
implements RandomSource {
    public abstract void setSeed(long var1);

    public long nextBits(int bits) {
        return this.nextLong() >>> 64 - bits;
    }

    @Override
    public boolean nextBoolean() {
        return (this.nextLong() & 1L) != 0L;
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }

    @Override
    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("Bound must be positive");
        }
        long i = (long)this.nextInt() & 0xFFFFFFFFL;
        long j = i * (long)bound;
        long k = j & 0xFFFFFFFFL;
        if (k < (long)bound) {
            int l = Integer.remainderUnsigned(~bound + 1, bound);
            while (k < (long)l) {
                i = (long)this.nextInt() & 0xFFFFFFFFL;
                j = i * (long)bound;
                k = j & 0xFFFFFFFFL;
            }
        }
        return (int)(j >> 32);
    }

    @Override
    public float nextFloat() {
        return (float)this.nextBits(24) * 5.9604645E-8f;
    }

    @Override
    public double nextDouble() {
        return (double)this.nextBits(53) * (double)1.110223E-16f;
    }
}

