/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.math.random;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.math.random.RandomSource;
import abeshutt.staracademy.math.random.lcg.Lcg;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class LcgRandom
implements RandomSource {
    protected Lcg lcg;
    protected long seed;

    protected LcgRandom(Lcg lcg, long seed) {
        this.lcg = lcg;
        this.seed = seed;
    }

    public static LcgRandom of(Lcg lcg, long seed) {
        return new LcgRandom(lcg, seed);
    }

    public Lcg getLCG() {
        return this.lcg;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public long nextSeed() {
        this.seed = this.lcg.nextSeed(this.seed);
        return this.seed;
    }

    @Override
    public long nextLong() {
        return this.nextSeed();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.LCG.writeBits(this.lcg, buffer);
        if (this.lcg.modulus == 0L) {
            Adapters.LONG.writeBits(this.seed, buffer);
        } else {
            Adapters.ofBoundedLong(this.lcg.modulus).writeBits(this.seed, buffer);
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.lcg = Adapters.LCG.readBits(buffer).orElseThrow();
        this.seed = this.lcg.modulus == 0L ? ((Long)Adapters.LONG.readBits(buffer).orElseThrow()).longValue() : ((Long)Adapters.ofBoundedLong(this.lcg.modulus).readBits(buffer).orElseThrow()).longValue();
    }

    @Override
    public Optional<class_2487> writeNbt() {
        class_2487 nbt = new class_2487();
        Adapters.LCG.writeNbt(this.lcg).ifPresent(value -> nbt.method_10566("lcg", (class_2520)value));
        Adapters.LONG.writeNbt(this.seed).ifPresent(value -> nbt.method_10566("seed", value));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.lcg = (Lcg)Adapters.LCG.readNbt((class_2487)nbt.method_10580("lcg")).orElseThrow();
        this.seed = (Long)Adapters.LONG.readNbt(nbt.method_10580("seed")).orElseThrow();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.LCG.writeJson(this.lcg).ifPresent(value -> json.add("lcg", (JsonElement)value));
        Adapters.LONG.writeJson(this.seed).ifPresent(value -> json.add("seed", value));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.lcg = (Lcg)Adapters.LCG.readJson((JsonObject)json.get("lcg")).orElseThrow();
        this.seed = (Long)Adapters.LONG.readJson(json.get("seed")).orElseThrow();
    }
}

