/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.math.random;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.math.random.LcgRandom;
import abeshutt.staracademy.math.random.lcg.Lcg;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_2487;

public class JavaRandom
extends LcgRandom {
    public static final long MULTIPLIER = Lcg.JAVA.multiplier;
    public static final long ADDEND = Lcg.JAVA.addend;
    public static final long MASK = Lcg.JAVA.modulus - 1L;
    protected double nextNextGaussian;
    protected boolean haveNextNextGaussian;

    protected JavaRandom(long seed) {
        super(Lcg.JAVA, seed);
    }

    public static JavaRandom ofInternal(long seed) {
        return new JavaRandom(seed);
    }

    public static JavaRandom ofScrambled(long seed) {
        return new JavaRandom(seed ^ MULTIPLIER);
    }

    public static JavaRandom ofNanoTime() {
        return new JavaRandom(new Random().nextLong());
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed ^ MULTIPLIER);
    }

    public int next(int bits) {
        return (int)(this.nextSeed() >>> 48 - bits);
    }

    @Override
    public long nextSeed() {
        this.seed = this.seed * MULTIPLIER + ADDEND & MASK;
        return this.seed;
    }

    @Override
    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    @Override
    public int nextInt() {
        return this.next(32);
    }

    @Override
    public int nextInt(int bound) {
        int value;
        int bits;
        if (bound <= 0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        if ((bound & -bound) == bound) {
            return (int)((long)bound * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (value = bits % bound) + (bound - 1) < 0) {
        }
        return value;
    }

    @Override
    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    @Override
    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) * (double)1.110223E-16f;
    }

    @Override
    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public Random toRandom() {
        return new Random(this.seed ^ MULTIPLIER);
    }

    public Random asRandomView() {
        return new View(this);
    }

    public JavaRandom copy() {
        JavaRandom copy = new JavaRandom(this.seed);
        copy.haveNextNextGaussian = this.haveNextNextGaussian;
        copy.nextNextGaussian = this.nextNextGaussian;
        return copy;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.ofBoundedLong(this.lcg.modulus).writeBits(this.seed, buffer);
        Adapters.BOOLEAN.writeBits(this.haveNextNextGaussian, buffer);
        if (this.haveNextNextGaussian) {
            Adapters.DOUBLE.writeBits(this.nextNextGaussian, buffer);
        }
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.seed = (Long)Adapters.ofBoundedLong(this.lcg.modulus).readBits(buffer).orElseThrow();
        this.haveNextNextGaussian = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
        if (this.haveNextNextGaussian) {
            this.nextNextGaussian = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
        }
    }

    @Override
    public Optional<class_2487> writeNbt() {
        class_2487 nbt = new class_2487();
        Adapters.LONG.writeNbt(this.seed).ifPresent(value -> nbt.method_10566("seed", value));
        Adapters.BOOLEAN.writeNbt(this.haveNextNextGaussian).ifPresent(value -> nbt.method_10566("haveNextNextGaussian", value));
        if (this.haveNextNextGaussian) {
            Adapters.DOUBLE.writeNbt(this.nextNextGaussian).ifPresent(value -> nbt.method_10566("nextNextGaussian", value));
        }
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.seed = (Long)Adapters.LONG.readNbt(nbt.method_10580("seed")).orElseThrow();
        this.haveNextNextGaussian = Adapters.BOOLEAN.readNbt(nbt.method_10580("haveNextNextGaussian")).orElseThrow();
        if (this.haveNextNextGaussian) {
            this.nextNextGaussian = (Double)Adapters.DOUBLE.readNbt(nbt.method_10580("nextNextGaussian")).orElseThrow();
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.LONG.writeJson(this.seed).ifPresent(value -> json.add("seed", value));
        Adapters.BOOLEAN.writeJson(this.haveNextNextGaussian).ifPresent(value -> json.add("haveNextNextGaussian", value));
        if (this.haveNextNextGaussian) {
            Adapters.DOUBLE.writeJson(this.nextNextGaussian).ifPresent(value -> json.add("nextNextGaussian", value));
        }
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.seed = (Long)Adapters.LONG.readJson(json.get("seed")).orElseThrow();
        this.haveNextNextGaussian = Adapters.BOOLEAN.readJson(json.get("haveNextNextGaussian")).orElseThrow();
        if (this.haveNextNextGaussian) {
            this.nextNextGaussian = (Double)Adapters.DOUBLE.readJson(json.get("nextNextGaussian")).orElseThrow();
        }
    }

    protected static class View
    extends Random {
        private final JavaRandom delegate;

        protected View(JavaRandom delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setSeed(long seed) {
            if (this.delegate != null) {
                this.delegate.setSeed(seed);
            }
        }

        @Override
        protected int next(int bits) {
            return this.delegate.next(bits);
        }

        @Override
        public double nextGaussian() {
            return this.delegate.nextGaussian();
        }
    }
}

