/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.math;

import abeshutt.staracademy.attribute.Option;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.IAdapter;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.math.Rational;
import abeshutt.staracademy.math.random.RandomSource;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3545;

public class WeightedList<T>
implements ISerializable<class_2520, JsonElement> {
    private final List<Entry<T>> entries = new ArrayList<Entry<T>>();
    private BigInteger lcm = BigInteger.ONE;
    private BigInteger weight = BigInteger.ZERO;

    protected WeightedList() {
    }

    public static <T> WeightedList<T> empty() {
        return new WeightedList<T>();
    }

    public static <T> WeightedList<T> of(Map<T, Rational> map) {
        return new WeightedList<T>().add(map::forEach);
    }

    public static <T> WeightedList<T> build(Consumer<BiConsumer<T, Rational>> consumer) {
        return new WeightedList<T>().add(consumer);
    }

    public WeightedList<T> add(T value, Rational weight) {
        if (weight.compareTo(Rational.ZERO) <= 0) {
            return this;
        }
        weight.simplify();
        if (!this.lcm.mod(weight.getDenominator()).equals(BigInteger.ZERO)) {
            BigInteger newLcm = this.lcm.divide(this.lcm.gcd(weight.getDenominator())).multiply(weight.getDenominator());
            BigInteger scalar = newLcm.divide(this.lcm);
            for (Entry<T> entry : this.entries) {
                entry.weight = entry.weight.multiply(scalar);
            }
            this.lcm = newLcm;
            this.weight = this.weight.multiply(scalar);
        }
        Entry<T> entry = new Entry<T>(value, weight.getNumerator().multiply(this.lcm.divide(weight.getDenominator())));
        this.entries.add(entry);
        this.weight = this.weight.add(entry.weight);
        return this;
    }

    public WeightedList<T> addAll(Map<T, Rational> map) {
        map.forEach(this::add);
        return this;
    }

    public WeightedList<T> add(Consumer<BiConsumer<T, Rational>> consumer) {
        ArrayList added = new ArrayList();
        consumer.accept((value, weight) -> {
            if (weight.compareTo(Rational.ZERO) > 0) {
                added.add(new class_3545(value, (Object)weight.simplify()));
            }
        });
        if (added.isEmpty()) {
            return this;
        }
        if (added.size() == 1) {
            return this.add(((class_3545)added.getFirst()).method_15442(), (Rational)((class_3545)added.getFirst()).method_15441());
        }
        BigInteger total = BigInteger.ONE;
        for (class_3545 pair : added) {
            total = total.divide(total.gcd(((Rational)pair.method_15441()).getDenominator())).multiply(((Rational)pair.method_15441()).getDenominator());
        }
        if (!this.lcm.mod(total).equals(BigInteger.ZERO)) {
            BigInteger newLcm = this.lcm.divide(this.lcm.gcd(total)).multiply(total);
            BigInteger scalar = newLcm.divide(this.lcm);
            for (Entry<T> entry : this.entries) {
                entry.weight = entry.weight.multiply(scalar);
            }
            this.lcm = newLcm;
            this.weight = this.weight.multiply(scalar);
        }
        for (class_3545 pair : added) {
            Entry<Object> entry = new Entry<Object>(pair.method_15442(), ((Rational)pair.method_15441()).getNumerator().multiply(this.lcm.divide(((Rational)pair.method_15441()).getDenominator())));
            this.entries.add(entry);
            this.weight = this.weight.add(entry.weight);
        }
        return this;
    }

    public Option<T> getRandom(RandomSource random) {
        if (this.entries.isEmpty()) {
            return Option.absent();
        }
        if (this.entries.size() == 1) {
            return Option.present(this.entries.getFirst().value);
        }
        BigInteger index = random.nextBigInteger(this.weight);
        for (Entry<T> entry : this.entries) {
            if (index.compareTo(entry.weight) < 0) {
                return Option.present(entry.value);
            }
            index = index.subtract(entry.weight);
        }
        return Option.absent();
    }

    private static class Entry<T> {
        private final T value;
        private BigInteger weight;

        public Entry(T value, BigInteger weight) {
            this.value = value;
            this.weight = weight;
        }
    }

    public static class Adapter<T>
    implements ISimpleAdapter<WeightedList<T>, class_2520, JsonElement> {
        private final IAdapter<T, class_2520, JsonElement, ?> element;
        private final boolean nullable;

        public Adapter(IAdapter<T, ?, ?, ?> element, boolean nullable) {
            this.element = element;
            this.nullable = nullable;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public Adapter<T> asNullable() {
            return new Adapter<T>(this.element, this.nullable);
        }

        @Override
        public void writeBits(WeightedList<T> value, BitBuffer buffer) {
            if (this.nullable) {
                Adapters.BOOLEAN.writeBits(value != null, buffer);
            }
            if (value != null) {
                Adapters.INT_SEGMENTED_3.writeBits(value.entries.size(), buffer);
                for (Entry entry : value.entries) {
                    this.element.writeBits(entry.value, buffer, null);
                    Adapters.BIG_INTEGER.writeBits(entry.weight, buffer);
                }
            }
        }

        @Override
        public Optional<WeightedList<T>> readBits(BitBuffer buffer) {
            if (!this.nullable || Adapters.BOOLEAN.readBits(buffer).orElseThrow().booleanValue()) {
                ArrayList<class_3545> entries = new ArrayList<class_3545>();
                int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
                for (int i = 0; i < size; ++i) {
                    entries.add(new class_3545(this.element.readBits(buffer, null).orElseThrow(), (Object)Rational.of((BigInteger)Adapters.BIG_INTEGER.readBits(buffer).orElseThrow())));
                }
                return Optional.of(WeightedList.build(consumer -> entries.forEach(pair -> consumer.accept(pair.method_15442(), (Rational)pair.method_15441()))));
            }
            return Optional.empty();
        }

        @Override
        public Optional<class_2520> writeNbt(WeightedList<T> value) {
            if (value == null) {
                return Optional.empty();
            }
            ArrayList serialized = new ArrayList();
            for (Entry entry : value.entries) {
                this.element.writeNbt(entry.value, null).ifPresent(tag -> serialized.add(new class_3545(tag, (Object)((class_2520)Adapters.RATIONAL.writeNbt(Rational.of((Number)entry.weight, 1), (Object)null).orElseThrow()))));
            }
            if (serialized.size() == 1) {
                return Optional.of((class_2520)((class_3545)serialized.getFirst()).method_15442());
            }
            class_2499 list = new class_2499();
            for (class_3545 pair : serialized) {
                class_2487 object;
                Object object2 = pair.method_15442();
                if (object2 instanceof class_2487 && !(object = (class_2487)object2).method_10545("weight")) {
                    object.method_10566("weight", (class_2520)pair.method_15441());
                    list.add((Object)((class_2520)pair.method_15442()));
                    continue;
                }
                class_2487 object3 = new class_2487();
                object3.method_10566("value", (class_2520)pair.method_15442());
                object3.method_10566("weight", (class_2520)pair.method_15441());
                list.add((Object)object3);
            }
            return Optional.of(list);
        }

        @Override
        public Optional<WeightedList<T>> readNbt(class_2520 nbt) {
            if (nbt == null) {
                return Optional.empty();
            }
            ArrayList entries = new ArrayList();
            if (nbt instanceof class_2499) {
                class_2487 object;
                class_2499 list = (class_2499)nbt;
                boolean weightedList = true;
                for (class_2520 child : list) {
                    if (child instanceof class_2487 && (object = (class_2487)child).method_10545("weight")) continue;
                    weightedList = false;
                    break;
                }
                if (weightedList) {
                    for (class_2520 child : list) {
                        object = (class_2487)child;
                        if (object.method_10545("value") && object.method_10546() == 2) {
                            this.element.readNbt(object.method_10580("value"), null).ifPresent(value -> entries.add(new class_3545(value, (Object)Adapters.RATIONAL.readNbt(object.method_10580("weight")).orElseThrow())));
                            continue;
                        }
                        this.element.readNbt((class_2520)object, null).ifPresent(value -> entries.add(new class_3545(value, (Object)Adapters.RATIONAL.readNbt(object.method_10580("weight")).orElseThrow())));
                    }
                } else {
                    this.element.readNbt(nbt, null).ifPresent(value -> entries.add(new class_3545(value, (Object)Rational.ONE)));
                }
            } else {
                this.element.readNbt(nbt, null).ifPresent(value -> entries.add(new class_3545(value, (Object)Rational.ONE)));
            }
            return Optional.of(WeightedList.build(consumer -> entries.forEach(pair -> consumer.accept(pair.method_15442(), (Rational)pair.method_15441()))));
        }

        @Override
        public Optional<JsonElement> writeJson(WeightedList<T> value) {
            if (value == null) {
                return Optional.empty();
            }
            ArrayList serialized = new ArrayList();
            for (Entry entry : value.entries) {
                this.element.writeJson(entry.value, null).ifPresent(tag -> serialized.add(new class_3545(tag, (Object)((JsonElement)Adapters.RATIONAL.writeJson(Rational.of((Number)entry.weight, 1), (Object)null).orElseThrow()))));
            }
            if (serialized.size() == 1) {
                return Optional.of((JsonElement)((class_3545)serialized.getFirst()).method_15442());
            }
            JsonArray array = new JsonArray();
            for (class_3545 pair : serialized) {
                JsonObject object;
                Object object2 = pair.method_15442();
                if (object2 instanceof JsonObject && !(object = (JsonObject)object2).has("weight")) {
                    object.add("weight", (JsonElement)pair.method_15441());
                    array.add((JsonElement)pair.method_15442());
                    continue;
                }
                JsonObject object3 = new JsonObject();
                object3.add("value", (JsonElement)pair.method_15442());
                object3.add("weight", (JsonElement)pair.method_15441());
                array.add((JsonElement)object3);
            }
            return Optional.of(array);
        }

        @Override
        public Optional<WeightedList<T>> readJson(JsonElement json) {
            if (json == null) {
                return Optional.empty();
            }
            ArrayList entries = new ArrayList();
            if (json instanceof JsonArray) {
                JsonObject object;
                JsonArray array = (JsonArray)json;
                boolean weightedList = true;
                for (JsonElement child : array) {
                    if (child instanceof JsonObject && (object = (JsonObject)child).has("weight")) continue;
                    weightedList = false;
                    break;
                }
                if (weightedList) {
                    for (JsonElement child : array) {
                        object = child.getAsJsonObject();
                        if (object.has("value") && object.size() == 2) {
                            this.element.readJson(object.get("value"), null).ifPresent(value -> entries.add(new class_3545(value, (Object)Adapters.RATIONAL.readJson(object.get("weight")).orElseThrow())));
                            continue;
                        }
                        this.element.readJson((JsonElement)object, null).ifPresent(value -> entries.add(new class_3545(value, (Object)Adapters.RATIONAL.readJson(object.get("weight")).orElseThrow())));
                    }
                } else {
                    this.element.readJson(json, null).ifPresent(value -> entries.add(new class_3545(value, (Object)Rational.ONE)));
                }
            } else {
                this.element.readJson(json, null).ifPresent(value -> entries.add(new class_3545(value, (Object)Rational.ONE)));
            }
            return Optional.of(WeightedList.build(consumer -> entries.forEach(pair -> consumer.accept(pair.method_15442(), (Rational)pair.method_15441()))));
        }
    }
}

