/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.math;

import java.math.BigInteger;

public class MathUtils {
    public static final int MASK_8 = (int)MathUtils.getMask(8);
    public static final int MASK_16 = (int)MathUtils.getMask(16);
    public static final long MASK_32 = MathUtils.getMask(32);
    public static final long MASK_48 = MathUtils.getMask(48);

    public static boolean isPowerOf2(long value) {
        return value != 0L && (value & -value) == value;
    }

    public static boolean isPowerOf2(BigInteger value) {
        return value.and(value.subtract(BigInteger.ONE)).equals(BigInteger.ZERO);
    }

    public static long getPow2(int bits) {
        return 1L << bits;
    }

    public static BigInteger getBigPow2(int bits) {
        return BigInteger.ONE.shiftLeft(bits);
    }

    public static long getMask(int bits) {
        return bits >= 64 ? -1L : MathUtils.getPow2(bits) - 1L;
    }

    public static BigInteger getBigMask(int bits) {
        return MathUtils.getBigPow2(bits).subtract(BigInteger.ONE);
    }

    public static long mask(long value, int bits) {
        return value & MathUtils.getMask(bits);
    }

    public static BigInteger bigMask(BigInteger value, int bits) {
        return value.and(MathUtils.getBigMask(bits));
    }

    public static long maskSigned(long value, int bits) {
        return value << 64 - bits >> 64 - bits;
    }

    public static long modInverse(long value) {
        return MathUtils.modInverse(value, 64);
    }

    public static long modInverse(long value, int k) {
        long x = ((value << 1 ^ value) & 4L) << 1 ^ value;
        x += x - value * x * x;
        x += x - value * x * x;
        x += x - value * x * x;
        x += x - value * x * x;
        return MathUtils.mask(x, k);
    }

    public static int min(int ... values2) {
        int min = values2[0];
        for (int i = 1; i < values2.length; ++i) {
            min = Math.min(min, values2[i]);
        }
        return min;
    }

    public static float min(float ... values2) {
        float min = values2[0];
        for (int i = 1; i < values2.length; ++i) {
            min = Math.min(min, values2[i]);
        }
        return min;
    }

    public static long min(long ... values2) {
        long min = values2[0];
        for (int i = 1; i < values2.length; ++i) {
            min = Math.min(min, values2[i]);
        }
        return min;
    }

    public static double min(double ... values2) {
        double min = values2[0];
        for (int i = 1; i < values2.length; ++i) {
            min = Math.min(min, values2[i]);
        }
        return min;
    }

    public static <T extends Comparable<T>> T getMin(T ... values2) {
        T min = values2[0];
        for (int i = 1; i < values2.length; ++i) {
            min = min.compareTo(values2[i]) <= 0 ? min : values2[i];
        }
        return min;
    }

    public static int max(int ... values2) {
        int max = values2[0];
        for (int i = 1; i < values2.length; ++i) {
            max = Math.max(max, values2[i]);
        }
        return max;
    }

    public static float max(float ... values2) {
        float max = values2[0];
        for (int i = 1; i < values2.length; ++i) {
            max = Math.max(max, values2[i]);
        }
        return max;
    }

    public static long max(long ... values2) {
        long max = values2[0];
        for (int i = 1; i < values2.length; ++i) {
            max = Math.max(max, values2[i]);
        }
        return max;
    }

    public static double max(double ... values2) {
        double max = values2[0];
        for (int i = 1; i < values2.length; ++i) {
            max = Math.max(max, values2[i]);
        }
        return max;
    }

    public static <T extends Comparable<T>> T getMax(T ... values2) {
        T max = values2[0];
        for (int i = 1; i < values2.length; ++i) {
            max = max.compareTo(values2[i]) >= 0 ? max : values2[i];
        }
        return max;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static <T extends Comparable<T>> T clamp(T value, T min, T max) {
        if (value.compareTo(min) < 0) {
            return min;
        }
        return value.compareTo(max) <= 0 ? value : max;
    }
}

