/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.item.data.card;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.basic.EnumAdapter;
import abeshutt.staracademy.item.data.card.AttributeStyle;
import abeshutt.staracademy.math.Rational;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;

public class DecimalAttributeStyle
extends AttributeStyle<Rational> {
    private int scale;
    private RoundingMode rounding;
    private boolean stripped;

    protected DecimalAttributeStyle() {
    }

    public DecimalAttributeStyle(int scale, RoundingMode rounding, boolean stripped) {
        this.scale = scale;
        this.rounding = rounding;
        this.stripped = stripped;
    }

    @Override
    public String format(Rational rational) {
        BigDecimal rounded = rational.toBigDecimal(this.scale, this.rounding);
        return this.stripped ? rounded.stripTrailingZeros().toPlainString() : rounded.toPlainString();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.scale).ifPresent(tag -> json.add("scale", tag));
            Adapters.ofEnum(RoundingMode.class, EnumAdapter.Mode.NAME).writeJson(this.rounding).ifPresent(tag -> json.add("rounding", tag));
            Adapters.BOOLEAN.writeJson(this.stripped).ifPresent(tag -> json.add("stripped", tag));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.scale = (Integer)Adapters.INT.readJson(json.get("scale")).orElseThrow();
        this.rounding = Adapters.ofEnum(RoundingMode.class, EnumAdapter.Mode.NAME).readJson(json.get("rounding")).orElseThrow();
        this.stripped = Adapters.BOOLEAN.readJson(json.get("stripped")).orElseThrow();
    }
}

