/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.item.data.card;

import abeshutt.staracademy.attribute.AddAttribute;
import abeshutt.staracademy.attribute.AssignAttribute;
import abeshutt.staracademy.attribute.Attribute;
import abeshutt.staracademy.attribute.AttributeContext;
import abeshutt.staracademy.attribute.CardScalarAttribute;
import abeshutt.staracademy.attribute.MultiplyAttribute;
import abeshutt.staracademy.attribute.NodeAttribute;
import abeshutt.staracademy.attribute.NumberConstantAttribute;
import abeshutt.staracademy.attribute.Option;
import abeshutt.staracademy.attribute.type.AttributeType;
import abeshutt.staracademy.attribute.type.AttributeTypes;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.item.CardAlbumItem;
import abeshutt.staracademy.item.data.card.CardDisplayEntry;
import abeshutt.staracademy.math.Rational;
import abeshutt.staracademy.math.roll.ConstantNumberRoll;
import abeshutt.staracademy.math.roll.NumberRoll;
import abeshutt.staracademy.math.roll.TrapezoidalNumberRoll;
import abeshutt.staracademy.math.roll.UniformNumberRoll;
import com.google.gson.JsonObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class CardModifier
implements ISerializable<class_2487, JsonObject> {
    private String source;
    private Attribute<?> attribute;

    public CardModifier() {
    }

    public CardModifier(String source2, Attribute<?> attribute) {
        this.source = source2;
        this.attribute = attribute;
    }

    public Attribute<?> getAttribute() {
        return this.attribute;
    }

    public void attach(Attribute<?> root) {
        ModConfigs.CARD_MODIFIERS.get(this.source).ifPresent(mod -> root.path(mod.getPath()).ifPresent(target -> {
            if (target instanceof NodeAttribute) {
                NodeAttribute node = (NodeAttribute)target;
                node.add(CardAlbumItem.REFERENCE, mod.getOrder(), this.attribute);
            }
        }));
    }

    public void setGrade(int grade) {
        this.attribute.iterate(child -> {
            if (child instanceof CardScalarAttribute) {
                CardScalarAttribute scalar = (CardScalarAttribute)child;
                scalar.setGrade(grade);
            }
        });
    }

    public void appendTooltip(class_1799 stack, int grade, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        class_5250 text = class_2561.method_43473();
        Attribute<?> attribute = this.attribute;
        if (attribute instanceof AddAttribute) {
            AddAttribute given = (AddAttribute)attribute;
            this.setGrade(0);
            Object rawValue = given.getValue().get(Option.absent(), new AttributeContext(null)).orElse(null);
            this.setGrade(grade);
            Object gradedValue = given.getValue().get(Option.absent(), new AttributeContext(null)).orElse(null);
            ModConfigs.CARD_MODIFIERS.get(this.source).ifPresent(mod -> {
                AddAttribute original;
                Attribute patt1$temp;
                Attribute<?> patt0$temp = mod.getAttribute();
                if (patt0$temp instanceof AddAttribute && (patt1$temp = (original = (AddAttribute)patt0$temp).getValue()) instanceof NodeAttribute) {
                    NodeAttribute node = (NodeAttribute)patt1$temp;
                    ModConfigs.ATTRIBUTE.getRoot().path(mod.getPath()).ifPresent(target -> ModConfigs.CARD_DISPLAYS.get((Attribute<?>)target).ifPresent(entry -> {
                        text.method_10852((class_2561)class_2561.method_43470((String)"+"));
                        if (class_437.method_25442()) {
                            text.method_27693("(");
                            ArrayList<Attribute> modifiers = new ArrayList<Attribute>(node.getModifiers().stream().map(NodeAttribute.Modifier::getAttribute).map(Attribute::copy).toList());
                            modifiers.removeIf(modifier -> {
                                if (modifier instanceof CardScalarAttribute) {
                                    CardScalarAttribute scalar = (CardScalarAttribute)modifier;
                                    if (grade == 0) {
                                        return true;
                                    }
                                    scalar.setGrade(grade);
                                }
                                return false;
                            });
                            for (int i = 0; i < modifiers.size(); ++i) {
                                text.method_10852(this.getPartText((Attribute)modifiers.get(i), rawValue, (CardDisplayEntry)entry, true));
                                if (i == modifiers.size() - 1) continue;
                                text.method_27693(" ");
                            }
                            text.method_27693(")");
                        } else {
                            text.method_10852((class_2561)class_2561.method_43470((String)entry.getStyle().format(gradedValue)));
                        }
                        text.method_10852((class_2561)class_2561.method_43470((String)" "));
                        text.method_10852((class_2561)class_2561.method_43471((String)entry.getName()));
                        text.method_10862(text.method_10866().method_36139(entry.getColor()));
                    }));
                }
            });
        }
        tooltip.add((class_2561)text);
    }

    public class_2561 getPartText(Attribute<?> attribute, Object value, CardDisplayEntry display, boolean advanced) {
        if (attribute instanceof NumberConstantAttribute) {
            NumberConstantAttribute constant = (NumberConstantAttribute)attribute;
            Rational min = this.getMin((NumberRoll)constant.getConfig());
            Rational max = this.getMax((NumberRoll)constant.getConfig());
            if (!advanced || min.equals(max)) {
                if (value.equals(min)) {
                    return class_2561.method_43470((String)display.getStyle().format(value)).method_10862(class_2583.field_24360.method_36139(display.getColor()));
                }
                return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)display.getStyle().format(value)).method_10862(class_2583.field_24360.method_36139(display.getColor()))).method_10852((class_2561)class_2561.method_43470((String)(" [" + display.getStyle().format(min) + "]"))).method_27692(class_124.field_1080);
            }
            return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)display.getStyle().format(value)).method_10862(class_2583.field_24360.method_36139(display.getColor()))).method_10852((class_2561)class_2561.method_43470((String)(" [" + display.getStyle().format(min) + "-" + display.getStyle().format(max) + "]"))).method_27692(class_124.field_1080);
        }
        if (attribute instanceof AssignAttribute) {
            AssignAttribute assign = (AssignAttribute)attribute;
            return this.getPartText(assign.getValue(), value, display, advanced);
        }
        if (attribute instanceof AddAttribute) {
            AddAttribute add = (AddAttribute)attribute;
            return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"+ ")).method_10862(class_2583.field_24360.method_36139(display.getColor())).method_10852(this.getPartText(add.getValue(), value, display, advanced));
        }
        if (attribute instanceof MultiplyAttribute) {
            MultiplyAttribute multiply = (MultiplyAttribute)attribute;
            return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00d7 ")).method_10862(class_2583.field_24360.method_36139(display.getColor())).method_10852(this.getPartText(multiply.getValue(), value, display, advanced));
        }
        if (attribute instanceof CardScalarAttribute) {
            CardScalarAttribute scalar = (CardScalarAttribute)attribute;
            Rational value2 = scalar.getScalar().orElse(null);
            return class_2561.method_43470((String)("\u00d7 " + (value2 == null ? "1" : display.getStyle().format(value2)))).method_10862(class_2583.field_24360.method_36139(display.getColor()));
        }
        throw new UnsupportedOperationException();
    }

    private Rational getMin(NumberRoll roll) {
        NumberRoll numberRoll = roll;
        Objects.requireNonNull(numberRoll);
        NumberRoll numberRoll2 = numberRoll;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantNumberRoll.class, UniformNumberRoll.class, TrapezoidalNumberRoll.class}, (Object)numberRoll2, n)) {
            case 0 -> {
                ConstantNumberRoll r = (ConstantNumberRoll)numberRoll2;
                yield r.value;
            }
            case 1 -> {
                UniformNumberRoll r = (UniformNumberRoll)numberRoll2;
                yield this.getMin(r.minimum);
            }
            case 2 -> {
                TrapezoidalNumberRoll r = (TrapezoidalNumberRoll)numberRoll2;
                yield this.getMin(r.minimum);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(roll));
        };
    }

    private Rational getMax(NumberRoll roll) {
        NumberRoll numberRoll = roll;
        Objects.requireNonNull(numberRoll);
        NumberRoll numberRoll2 = numberRoll;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantNumberRoll.class, UniformNumberRoll.class, TrapezoidalNumberRoll.class}, (Object)numberRoll2, n)) {
            case 0 -> {
                ConstantNumberRoll r = (ConstantNumberRoll)numberRoll2;
                yield r.value;
            }
            case 1 -> {
                UniformNumberRoll r = (UniformNumberRoll)numberRoll2;
                yield this.getMin(r.maximum);
            }
            case 2 -> {
                TrapezoidalNumberRoll r = (TrapezoidalNumberRoll)numberRoll2;
                yield this.getMin(r.maximum);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(roll));
        };
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            Adapters.UTF_8.writeNbt(this.source).ifPresent(tag -> nbt.method_10566("source", tag));
            Adapters.ATTRIBUTE.writeNbt(this.attribute, (AttributeType<?>)AttributeTypes.any()).ifPresent(tag -> nbt.method_10566("attribute", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.source = Adapters.UTF_8.readNbt(nbt.method_10580("source")).orElseThrow();
        this.attribute = Adapters.ATTRIBUTE.readNbt(nbt.method_10580("attribute"), (AttributeType<?>)AttributeTypes.any()).orElseThrow();
    }
}

