/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.item.data.card;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.item.data.card.CardRarity;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class CardIconEntry
implements ISerializable<class_2487, JsonObject> {
    private String name;
    private final Map<String, Entry> entries;

    public CardIconEntry() {
        this.entries = new LinkedHashMap<String, Entry>();
    }

    public CardIconEntry(String name, Map<String, Entry> entries) {
        this.name = name;
        this.entries = new LinkedHashMap<String, Entry>(entries);
    }

    public Optional<Entry> get(CardRarity rarity) {
        return Optional.ofNullable(this.entries.getOrDefault(rarity.name(), this.entries.get("*")));
    }

    public Optional<class_2960> getModel(CardRarity rarity) {
        return this.get(rarity).map(Entry::getModel);
    }

    public Optional<int[]> getColors(CardRarity rarity) {
        return this.get(rarity).map(Entry::getColors);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return Optional.of(new JsonObject()).map(json -> {
            Adapters.UTF_8.writeJson(this.name).ifPresent(tag -> json.add("name", tag));
            this.entries.forEach((rarity, entry) -> entry.writeJson().ifPresent(object -> json.add(rarity, (JsonElement)object)));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        this.name = Adapters.UTF_8.readJson(json.get("name")).orElseThrow();
        this.entries.clear();
        for (String key : json.keySet()) {
            if (key.equals("name")) continue;
            Entry entry = new Entry();
            entry.readJson(json.get(key).getAsJsonObject());
            this.entries.put(key, entry);
        }
    }

    public static class Entry
    implements ISerializable<class_2487, JsonObject> {
        private class_2960 model;
        private int[] colors;

        private Entry() {
        }

        public Entry(class_2960 model, int ... colors) {
            this.model = model;
            this.colors = colors;
        }

        public class_2960 getModel() {
            return this.model;
        }

        public int[] getColors() {
            return this.colors;
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject()).map(json -> {
                Adapters.IDENTIFIER.writeJson(this.model).ifPresent(tag -> json.add("model", tag));
                JsonArray colors = new JsonArray();
                for (int color : this.colors) {
                    Adapters.INT.writeJson(color).ifPresent(arg_0 -> ((JsonArray)colors).add(arg_0));
                }
                json.add("colors", (JsonElement)colors);
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            this.model = Adapters.IDENTIFIER.readJson(json.get("model")).orElseThrow();
            JsonArray colors = json.get("colors").getAsJsonArray();
            this.colors = new int[colors.size()];
            for (int i = 0; i < colors.size(); ++i) {
                this.colors[i] = (Integer)Adapters.INT.readJson(colors.get(i)).orElseThrow();
            }
        }
    }
}

