/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.item.data.card;

import abeshutt.staracademy.attribute.Attribute;
import abeshutt.staracademy.attribute.AttributeContext;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.item.data.card.CardData;
import abeshutt.staracademy.item.data.card.CardModifier;
import abeshutt.staracademy.item.data.card.CardRarity;
import abeshutt.staracademy.math.random.RandomSource;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2487;

public class CardEntry
implements ISerializable<class_2487, JsonObject> {
    private String icon;
    private String rarity;
    private final List<Entry> modifiers;

    public CardEntry() {
        this.modifiers = new ArrayList<Entry>();
    }

    public CardEntry(String icon, String rarity, Entry ... modifiers) {
        this.icon = icon;
        this.rarity = rarity;
        this.modifiers = new ArrayList<Entry>(Arrays.asList(modifiers));
    }

    public CardData generate(RandomSource random) {
        String icon = ModConfigs.CARD_ICONS.flatten(this.icon, random).orElse(this.icon);
        CardRarity rarity = ModConfigs.CARD_RARITIES.generate(this.rarity, random).orElse(CardRarity.COMMON);
        ArrayList<CardModifier> modifiers = new ArrayList<CardModifier>();
        this.modifiers.forEach(modifier -> modifier.generate(rarity, random).ifPresent(modifiers::add));
        return new CardData(icon, rarity, 0, modifiers);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return Optional.of(new JsonObject()).map(object -> {
            Adapters.UTF_8.writeJson(this.icon).ifPresent(tag -> object.add("icon", tag));
            Adapters.UTF_8.writeJson(this.rarity).ifPresent(tag -> object.add("rarity", tag));
            JsonArray modifiers = new JsonArray();
            for (Entry modifier : this.modifiers) {
                modifier.writeJson().ifPresent(arg_0 -> ((JsonArray)modifiers).add(arg_0));
            }
            object.add("modifiers", (JsonElement)modifiers);
            return object;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        this.icon = Adapters.UTF_8.readJson(json.get("icon")).orElseThrow();
        this.rarity = Adapters.UTF_8.readJson(json.get("rarity")).orElseThrow();
        this.modifiers.clear();
        JsonElement jsonElement = json.get("modifiers");
        if (jsonElement instanceof JsonArray) {
            JsonArray array = (JsonArray)jsonElement;
            for (JsonElement element : array) {
                if (!(element instanceof JsonObject)) continue;
                JsonObject object = (JsonObject)element;
                Entry entry = new Entry();
                entry.readJson(object);
                this.modifiers.add(entry);
            }
        }
    }

    public static class Entry
    implements ISerializable<class_2487, JsonObject> {
        private String modifier;
        private Set<CardRarity> rarities;
        private float probability;

        public Entry() {
        }

        public Entry(String modifier, Set<CardRarity> rarities, float probability) {
            this.modifier = modifier;
            this.rarities = rarities;
            this.probability = probability;
        }

        public Optional<CardModifier> generate(CardRarity rarity, RandomSource random) {
            if (random.nextFloat() >= this.probability) {
                return Optional.empty();
            }
            if (this.rarities != null && !this.rarities.contains((Object)rarity)) {
                return Optional.empty();
            }
            String source2 = ModConfigs.CARD_MODIFIERS.flatten(this.modifier, random).orElse(this.modifier);
            return ModConfigs.CARD_MODIFIERS.get(source2).map(value -> {
                Attribute<?> attribute = value.getAttribute().copy();
                attribute.populate(new AttributeContext(random));
                return new CardModifier(source2, attribute);
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject()).map(object -> {
                Adapters.UTF_8.writeJson(this.modifier).ifPresent(tag -> object.add("modifier", tag));
                if (this.rarities != null) {
                    JsonArray array = new JsonArray();
                    this.rarities.forEach(rarity -> Adapters.CARD_RARITY.writeJson((CardRarity)((Object)((Object)rarity))).ifPresent(arg_0 -> ((JsonArray)array).add(arg_0)));
                    object.add("rarities", (JsonElement)array);
                }
                Adapters.FLOAT.writeJson(Float.valueOf(this.probability)).ifPresent(tag -> object.add("probability", tag));
                return object;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            this.modifier = Adapters.UTF_8.readJson(json.get("modifier")).orElseThrow();
            JsonElement jsonElement = json.get("rarities");
            if (jsonElement instanceof JsonArray) {
                JsonArray array = (JsonArray)jsonElement;
                this.rarities = new LinkedHashSet<CardRarity>();
                for (JsonElement child : array) {
                    Adapters.CARD_RARITY.readJson(child).ifPresent(this.rarities::add);
                }
            } else {
                this.rarities = null;
            }
            this.probability = ((Float)Adapters.FLOAT.readJson(json.get("probability")).orElseThrow()).floatValue();
        }
    }
}

