/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.item.data.card;

import abeshutt.staracademy.attribute.Attribute;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.item.data.card.CardModifier;
import abeshutt.staracademy.item.data.card.CardRarity;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public class CardData
implements ISerializable<class_2487, JsonObject> {
    private String icon;
    private CardRarity rarity;
    private int grade;
    private final List<CardModifier> modifiers;

    public CardData() {
        this.modifiers = new ArrayList<CardModifier>();
    }

    public CardData(String icon, CardRarity rarity, int grade, List<CardModifier> modifiers) {
        this.modifiers = modifiers;
        this.grade = grade;
        this.rarity = rarity;
        this.icon = icon;
    }

    public String getIcon() {
        return this.icon;
    }

    public CardRarity getRarity() {
        return this.rarity;
    }

    public int getGrade() {
        return this.grade;
    }

    public void setGrade(int grade) {
        this.grade = grade;
        for (CardModifier modifier : this.modifiers) {
            modifier.setGrade(this.grade);
        }
    }

    public void attach(Attribute<?> root) {
        for (CardModifier modifier : this.modifiers) {
            modifier.attach(root);
            modifier.setGrade(this.grade);
        }
    }

    public void appendTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        tooltip.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"text.academy.card.rarity")).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43471((String)("text.academy.card.rarity." + this.rarity.method_15434())).method_10862(class_2583.field_24360.method_36139(this.rarity.getColor()))));
        if (this.grade == 0) {
            tooltip.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"text.academy.card.grade").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)": ???").method_27692(class_124.field_1080)));
        } else {
            tooltip.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"text.academy.card.grade")).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43471((String)("text.academy.card.grade." + this.grade))));
        }
        for (CardModifier modifier : this.modifiers) {
            modifier.appendTooltip(stack, this.grade, context, tooltip, type);
        }
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            Adapters.UTF_8.writeNbt(this.icon).ifPresent(tag -> nbt.method_10566("icon", tag));
            Adapters.CARD_RARITY.writeNbt(this.rarity).ifPresent(tag -> nbt.method_10566("rarity", tag));
            if (this.grade != 0) {
                Adapters.INT.writeNbt(this.grade).ifPresent(tag -> nbt.method_10566("grade", tag));
            }
            class_2499 modifiers = new class_2499();
            for (CardModifier modifier : this.modifiers) {
                modifier.writeNbt().ifPresent(arg_0 -> modifiers.add(arg_0));
            }
            nbt.method_10566("modifiers", (class_2520)modifiers);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.icon = Adapters.UTF_8.readNbt(nbt.method_10580("icon")).orElseThrow();
        this.rarity = Adapters.CARD_RARITY.readNbt(nbt.method_10580("rarity")).orElseThrow();
        this.grade = Adapters.INT.readNbt(nbt.method_10580("grade")).orElse(0);
        this.modifiers.clear();
        class_2520 class_25202 = nbt.method_10580("modifiers");
        if (class_25202 instanceof class_2499) {
            class_2499 modifiers = (class_2499)class_25202;
            for (class_2520 element : modifiers) {
                if (!(element instanceof class_2487)) continue;
                class_2487 entry = (class_2487)element;
                CardModifier modifier = new CardModifier();
                modifier.readNbt(entry);
                this.modifiers.add(modifier);
            }
        }
    }
}

