/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.item.data.card;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.item.data.card.CardData;
import abeshutt.staracademy.math.random.RandomSource;
import abeshutt.staracademy.math.roll.NumberRoll;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class BoosterPackEntry
implements ISerializable<class_2487, JsonObject> {
    private class_2960 modelBase;
    private class_2960 modelRipped;
    private int color;
    private final List<Pool> pools;

    public BoosterPackEntry() {
        this.pools = new ArrayList<Pool>();
    }

    public BoosterPackEntry(class_2960 modelBase, class_2960 modelRipped, int color, Pool ... pools) {
        this.modelBase = modelBase;
        this.modelRipped = modelRipped;
        this.color = color;
        this.pools = new ArrayList<Pool>(Arrays.asList(pools));
    }

    public class_2960 getModelBase() {
        return this.modelBase;
    }

    public class_2960 getModelRipped() {
        return this.modelRipped;
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return Optional.of(new JsonObject()).map(json -> {
            Adapters.IDENTIFIER.writeJson(this.modelBase).ifPresent(tag -> json.add("modelBase", tag));
            Adapters.IDENTIFIER.writeJson(this.modelRipped).ifPresent(tag -> json.add("modelRipped", tag));
            Adapters.INT.writeJson(this.color).ifPresent(tag -> json.add("color", tag));
            JsonArray array = new JsonArray();
            for (Pool pool : this.pools) {
                pool.writeJson().ifPresent(arg_0 -> ((JsonArray)array).add(arg_0));
            }
            json.add("pools", (JsonElement)array);
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        this.modelBase = Adapters.IDENTIFIER.readJson(json.get("modelBase")).orElseThrow();
        this.modelRipped = Adapters.IDENTIFIER.readJson(json.get("modelRipped")).orElseThrow();
        this.color = (Integer)Adapters.INT.readJson(json.get("color")).orElseThrow();
        JsonArray pools = json.get("pools").getAsJsonArray();
        this.pools.clear();
        for (JsonElement element : pools) {
            Pool pool = new Pool();
            pool.readJson(element.getAsJsonObject());
            this.pools.add(pool);
        }
    }

    public List<CardData> generate(RandomSource random) {
        ArrayList<CardData> cards = new ArrayList<CardData>();
        for (Pool pool : this.pools) {
            if (random.nextFloat() >= pool.probability) continue;
            int count = pool.count.get(random).intValue();
            for (int i = 0; i < count; ++i) {
                String id = ModConfigs.CARD_ENTRIES.flatten(pool.entry, random).orElse(null);
                if (id == null) continue;
                ModConfigs.CARD_ENTRIES.get(id).ifPresent(entry -> cards.add(entry.generate(random)));
            }
        }
        return cards;
    }

    public static class Pool
    implements ISerializable<class_2487, JsonObject> {
        private String entry;
        private NumberRoll count;
        private float probability;

        public Pool() {
        }

        public Pool(String entry, NumberRoll count, float probability) {
            this.entry = entry;
            this.count = count;
            this.probability = probability;
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject()).map(json -> {
                Adapters.UTF_8.writeJson(this.entry).ifPresent(tag -> json.add("entry", tag));
                Adapters.NUMBER_ROLL.writeJson(this.count).ifPresent(tag -> json.add("count", tag));
                Adapters.FLOAT.writeJson(Float.valueOf(this.probability)).ifPresent(tag -> json.add("probability", tag));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            this.entry = Adapters.UTF_8.readJson(json.get("entry")).orElseThrow();
            this.count = Adapters.NUMBER_ROLL.readJson(json.get("count")).orElseThrow();
            this.probability = ((Float)Adapters.FLOAT.readJson(json.get("probability")).orElseThrow()).floatValue();
        }
    }
}

