/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.item;

import abeshutt.staracademy.config.SafariConfig;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.init.ModDataComponents;
import abeshutt.staracademy.init.ModItems;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.item.SafariTicketEntry;
import abeshutt.staracademy.item.renderer.SafariTicketItemRenderer;
import abeshutt.staracademy.item.renderer.SpecialItemRenderer;
import abeshutt.staracademy.math.random.JavaRandom;
import abeshutt.staracademy.math.roll.IntRoll;
import abeshutt.staracademy.util.ISpecialItemModel;
import abeshutt.staracademy.world.data.save.SafariData;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1091;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_9331;

public class SafariTicketItem
extends class_1792
implements ISpecialItemModel {
    public SafariTicketItem() {
        super(new class_1792.class_1793());
    }

    public class_2561 method_7864(class_1799 stack) {
        return SafariTicketItem.getEntry(stack, true).map(entry -> class_2561.method_43470((String)entry.getName()).method_10862(class_2583.field_24360.method_36139(entry.getColor()))).orElseGet(() -> super.method_7864(stack));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (user.method_37908().method_8608() || user.method_5682() == null || world.method_8503() == null) {
            return class_1271.method_22427((Object)stack);
        }
        SafariData data = ModWorldData.SAFARI.getGlobal(world.method_8503());
        SafariTicketItem.getEntry(stack, false).ifPresent(value -> {
            int time = value.getTime().get(JavaRandom.ofNanoTime());
            SafariData.Entry entry = data.getOrCreate(user.method_5667());
            entry.setTimeLeft(entry.getTimeLeft() + (long)time);
            user.method_43496(SafariTicketItem.getTimeMessage(user, time, true));
            if (!user.method_7337()) {
                stack.method_7934(1);
            }
        });
        return class_1271.method_22427((Object)stack);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        SafariTicketItem.getEntry(stack, true).ifPresent(entry -> {
            int max;
            int min = IntRoll.getMin(entry.getTime());
            if (min == (max = IntRoll.getMax(entry.getTime()))) {
                tooltip.add((class_2561)class_2561.method_43470((String)("Adds " + SafariTicketItem.formatTimeString(min) + " to your Safari timer.")).method_27692(class_124.field_1080));
            } else {
                tooltip.add((class_2561)class_2561.method_43470((String)("Adds between " + SafariTicketItem.formatTimeString(min) + " and " + SafariTicketItem.formatTimeString(max) + " to your Safari timer.")).method_27692(class_124.field_1080));
            }
        });
    }

    public static class_1799 create(String id) {
        class_1799 stack = new class_1799((class_1935)ModItems.SAFARI_TICKET.get());
        stack.method_57379((class_9331)ModDataComponents.SAFARI_TICKET_ENTRY.get(), (Object)id);
        return stack;
    }

    public static Optional<SafariTicketEntry> getEntry(class_1799 stack, boolean client) {
        String id = (String)stack.method_57824((class_9331)ModDataComponents.SAFARI_TICKET_ENTRY.get());
        if (id == null) {
            return Optional.empty();
        }
        return client ? SafariConfig.CLIENT.getTicket(id) : ModConfigs.SAFARI.getTicket(id);
    }

    @Override
    public void loadModels(Stream<class_2960> unbakedModels, Consumer<class_1091> loader) {
        ModConfigs.SAFARI.getTickets().forEach((id, entry) -> loader.accept(entry.getModelId()));
    }

    @Override
    public SpecialItemRenderer getRenderer() {
        return SafariTicketItemRenderer.INSTANCE;
    }

    public static class_2561 getTimeMessage(class_1657 target, long ticks, boolean personal) {
        if (ticks >= 0L) {
            return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Added ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)SafariTicketItem.formatTimeString(ticks)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1080)).method_10852((class_2561)(personal ? class_2561.method_43470((String)"your").method_27692(class_124.field_1080) : target.method_5477())).method_10852((class_2561)class_2561.method_43470((String)(personal ? " Safari." : "'s Safari timer.")).method_27692(class_124.field_1080));
        }
        return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Removed ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)SafariTicketItem.formatTimeString(-ticks)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" from ").method_27692(class_124.field_1080)).method_10852((class_2561)(personal ? class_2561.method_43470((String)"your").method_27692(class_124.field_1080) : target.method_5477())).method_10852((class_2561)class_2561.method_43470((String)(personal ? " Safari." : "'s Safari timer.")).method_27692(class_124.field_1080));
    }

    protected static String formatTimeString(long remainingTicks) {
        long seconds = remainingTicks / 20L % 60L;
        long minutes = remainingTicks / 20L / 60L % 60L;
        long hours = remainingTicks / 20L / 60L / 60L;
        return hours > 0L ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%02d:%02d", minutes, seconds);
    }
}

