/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.item;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.init.ModDataComponents;
import abeshutt.staracademy.init.ModItems;
import abeshutt.staracademy.item.CardItem;
import abeshutt.staracademy.item.data.card.BoosterPackEntry;
import abeshutt.staracademy.item.data.card.CardData;
import abeshutt.staracademy.item.renderer.BoosterPackItemRenderer;
import abeshutt.staracademy.item.renderer.SpecialItemRenderer;
import abeshutt.staracademy.math.random.JavaRandom;
import abeshutt.staracademy.screen.BoosterPackScreen;
import abeshutt.staracademy.util.ISpecialItemModel;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1091;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_9288;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class BoosterPackItem
extends class_1792
implements ISpecialItemModel {
    public BoosterPackItem() {
        super(new class_1792.class_1793().method_24359().method_7889(1));
    }

    public static Optional<BoosterPackEntry> get(class_1799 stack, boolean client) {
        return Optional.ofNullable((String)stack.method_57825((class_9331)ModDataComponents.BOOSTER_PACK.get(), null)).flatMap(id -> ModConfigs.CARD_BOOSTERS.get((String)id));
    }

    public static void set(class_1799 stack, String id) {
        stack.method_57379((class_9331)ModDataComponents.BOOSTER_PACK.get(), (Object)id);
    }

    public static class_1799 create(String id) {
        class_1799 stack = new class_1799((class_1935)ModItems.BOOSTER_PACK.get());
        stack.method_57379((class_9331)ModDataComponents.BOOSTER_PACK.get(), (Object)id);
        return stack;
    }

    public class_2561 method_7864(class_1799 stack) {
        class_2561 text = super.method_7864(stack);
        Integer color = BoosterPackItem.get(stack, Platform.getEnv() == EnvType.CLIENT).map(BoosterPackEntry::getColor).orElse(null);
        if (color != null) {
            text = text.method_27661().method_10862(class_2583.field_24360.method_36139(color.intValue()));
        }
        return text;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        user.method_6019(hand);
        if (!world.method_8608() && !stack.method_57826(class_9334.field_49622)) {
            BoosterPackItem.get(stack, false).ifPresent(entry -> {
                ArrayList<class_1799> items = new ArrayList<class_1799>();
                for (CardData data : entry.generate(JavaRandom.ofNanoTime())) {
                    items.add(CardItem.of(data));
                }
                stack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(new ArrayList(items)));
            });
        }
        if (world.method_8608()) {
            this.openScreen();
        }
        return class_1271.method_22428((Object)stack);
    }

    @Environment(value=EnvType.CLIENT)
    public void openScreen() {
        class_310.method_1551().method_1507((class_437)new BoosterPackScreen());
    }

    public String method_7866(class_1799 stack) {
        String id = (String)stack.method_57825((class_9331)ModDataComponents.BOOSTER_PACK.get(), null);
        return super.method_7866(stack) + (String)(id == null ? "" : "." + id);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void loadModels(Stream<class_2960> unbakedModels, Consumer<class_1091> loader) {
        unbakedModels.forEach(id -> {
            if (id.method_12836().equals("academy") && id.method_12832().startsWith("booster_pack")) {
                loader.accept(StarAcademyMod.mid(id, "inventory"));
            }
        });
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public SpecialItemRenderer getRenderer() {
        return BoosterPackItemRenderer.INSTANCE;
    }
}

