/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class Event<INVOKER, LISTENER extends Listener> {
    protected final Map<Object, List<LISTENER>> keyedListeners = new HashMap<Object, List<LISTENER>>();
    protected final List<LISTENER> orderedListeners = new ArrayList<LISTENER>();

    protected Event() {
    }

    public abstract INVOKER invoker();

    public void register(LISTENER listener) {
        int index;
        List keyed = this.keyedListeners.computeIfAbsent(((Listener)listener).getOwner(), key -> new ArrayList());
        keyed.add(listener);
        List<LISTENER> ordered = this.orderedListeners;
        if (index >= 0) {
            for (index = Collections.binarySearch(ordered, listener); index < ordered.size() - 1 && ((Listener)ordered.get(index + 1)).compareTo((Listener)listener) == 0; ++index) {
            }
            ++index;
        } else {
            index = -index - 1;
        }
        ordered.add(index, listener);
    }

    public void release(Object owner) {
        List<LISTENER> listeners = this.keyedListeners.remove(owner);
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        this.orderedListeners.removeAll(new HashSet<LISTENER>(listeners));
    }

    public void clear() {
        this.keyedListeners.clear();
        this.orderedListeners.clear();
    }

    public static class Listener
    implements Comparable<Listener> {
        private final Object owner;
        private final int order;

        public Listener(Object owner, int order) {
            this.owner = owner;
            this.order = order;
        }

        public Object getOwner() {
            return this.owner;
        }

        public int getOrder() {
            return this.order;
        }

        @Override
        public int compareTo(Listener other) {
            return Integer.compare(this.order, other.getOrder());
        }
    }
}

