/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.event;

import abeshutt.staracademy.event.Event;
import abeshutt.staracademy.util.collection.MappingIterable;
import com.google.common.reflect.AbstractInvocationHandler;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class CallbackEvent<CALLBACK>
extends Event<CALLBACK, Listener<CALLBACK>> {
    protected final Class<CALLBACK> type;
    protected final Invoker<Listener<CALLBACK>, CALLBACK> invoker;

    protected CallbackEvent(Class<CALLBACK> type, Invoker<Listener<CALLBACK>, CALLBACK> invoker) {
        this.type = type;
        this.invoker = invoker;
    }

    public static <CALLBACK> CallbackEvent<CALLBACK> ofComplex(Class<CALLBACK> type, Invoker<Listener<CALLBACK>, CALLBACK> invoker) {
        return new CallbackEvent<CALLBACK>(type, invoker);
    }

    public static <CALLBACK> CallbackEvent<CALLBACK> ofComplex(Invoker<Listener<CALLBACK>, CALLBACK> invoker, CALLBACK ... unused) {
        return CallbackEvent.ofComplex(unused.getClass().getComponentType(), invoker);
    }

    public static <CALLBACK> CallbackEvent<CALLBACK> ofSimple(Class<CALLBACK> type, Invoker<CALLBACK, CALLBACK> invoker) {
        return CallbackEvent.ofComplex(type, listeners -> invoker.invoke(new MappingIterable<Listener, Object>(listeners, Listener::getCallback)));
    }

    public static <CALLBACK> CallbackEvent<CALLBACK> ofSimple(Invoker<CALLBACK, CALLBACK> invoker, CALLBACK ... unused) {
        return CallbackEvent.ofSimple(unused.getClass().getComponentType(), invoker);
    }

    public static <CALLBACK> CallbackEvent<CALLBACK> ofVoid(Class<CALLBACK> type) {
        return CallbackEvent.ofSimple(type, listeners -> Proxy.newProxyInstance(CallbackEvent.class.getClassLoader(), new Class[]{type}, new VoidInvocation(type, listeners)));
    }

    public static <CALLBACK> CallbackEvent<CALLBACK> ofVoid(CALLBACK ... unused) {
        return CallbackEvent.ofVoid(unused.getClass().getComponentType());
    }

    public Class<CALLBACK> getType() {
        return this.type;
    }

    @Override
    public CALLBACK invoker() {
        return this.invoker.invoke(this.orderedListeners);
    }

    @Override
    public void register(CALLBACK callback) {
        this.register(null, callback, 0);
    }

    public void register(Object owner, CALLBACK callback) {
        this.register(owner, callback, 0);
    }

    public void register(CALLBACK callback, int order) {
        this.register(null, callback, order);
    }

    public void register(Object owner, CALLBACK callback, int order) {
        this.register((CALLBACK)new Listener<CALLBACK>(owner, order, callback));
    }

    @FunctionalInterface
    public static interface Invoker<INPUT, OUTPUT> {
        public OUTPUT invoke(Iterable<INPUT> var1);
    }

    public static class Listener<CALLBACK>
    extends Event.Listener {
        private final CALLBACK callback;

        public Listener(Object owner, int order, CALLBACK callback) {
            super(owner, order);
            this.callback = callback;
        }

        public CALLBACK getCallback() {
            return this.callback;
        }
    }

    protected static class VoidInvocation<CALLBACK>
    extends AbstractInvocationHandler {
        private final Class<CALLBACK> type;
        private final Iterable<CALLBACK> listeners;

        public VoidInvocation(Class<CALLBACK> type, Iterable<CALLBACK> listeners) {
            this.type = type;
            this.listeners = listeners;
        }

        protected Object handleInvocation(Object proxy, Method method, Object[] args2) throws Throwable {
            for (CALLBACK listener : this.listeners) {
                MethodHandles.lookup().unreflect(method).bindTo(listener).invokeWithArguments(args2);
            }
            if (!this.type.isPrimitive()) {
                return null;
            }
            if (this.type == Boolean.TYPE) {
                return false;
            }
            if (this.type == Byte.TYPE) {
                return (byte)0;
            }
            if (this.type == Short.TYPE) {
                return (short)0;
            }
            if (this.type == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            if (this.type == Integer.TYPE) {
                return 0;
            }
            if (this.type == Long.TYPE) {
                return 0L;
            }
            if (this.type == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (this.type == Double.TYPE) {
                return 0.0;
            }
            return null;
        }
    }
}

