/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.tile;

import abeshutt.staracademy.data.nbt.PartialCompoundNbt;
import abeshutt.staracademy.data.tile.PartialBlockProperties;
import abeshutt.staracademy.data.tile.PartialBlockState;
import abeshutt.staracademy.data.tile.TilePlacement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class PartialBlockTag
implements TilePlacement<PartialBlockTag> {
    private class_2960 id;
    private PartialBlockProperties properties;
    private PartialCompoundNbt entity;

    public PartialBlockTag(class_2960 id, PartialBlockProperties properties, PartialCompoundNbt entity) {
        this.id = id;
        this.properties = properties;
        this.entity = entity;
    }

    public static PartialBlockTag of(class_2960 id, PartialBlockProperties properties, PartialCompoundNbt entity) {
        return new PartialBlockTag(id, properties, entity);
    }

    @Override
    public boolean isSubsetOf(PartialBlockTag other) {
        return (this.id == null || this.id.equals((Object)other.id)) && this.properties.isSubsetOf(other.properties) && this.entity.isSubsetOf(other.entity);
    }

    @Override
    public boolean isSubsetOf(class_1922 world, class_2338 pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fillInto(PartialBlockTag other) {
        if (this.id != null) {
            other.id = this.id;
        }
        this.properties.fillInto(other.properties);
        this.entity.fillInto(other.entity);
    }

    @Override
    public void place(class_1936 world, class_2338 pos, int flags) {
        this.properties.place(world, pos, flags);
        this.entity.place(world, pos, flags);
    }

    @Override
    public boolean test(PartialBlockState state, PartialCompoundNbt nbt) {
        return this.properties.isSubsetOf(state.getProperties()) && this.entity.isSubsetOf(nbt) && state.asWhole().map(other -> class_7923.field_41175.method_47983((Object)other.method_26204()).method_40228().anyMatch(tag -> tag.comp_327().equals((Object)this.id))).orElse(false) != false;
    }

    @Override
    public PartialBlockTag copy() {
        return new PartialBlockTag(this.id, this.properties.copy(), this.entity.copy());
    }

    public String toString() {
        return (String)(this.id != null ? "#" + String.valueOf(this.id) : "") + this.properties.toString() + this.entity.toString();
    }

    public static Optional<PartialBlockTag> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialBlockTag.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialBlockTag parse(String string) throws CommandSyntaxException {
        return PartialBlockTag.parse(new StringReader(string));
    }

    public static PartialBlockTag parse(StringReader reader) throws CommandSyntaxException {
        if (reader.peek() != '#') {
            throw new IllegalArgumentException("Invalid block tag '" + reader.getString() + "' does not modeMinimum with #");
        }
        reader.skip();
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialBlockTag.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialBlockTag.of(class_2960.method_60654((String)string), PartialBlockProperties.parse(reader), PartialCompoundNbt.parse(reader));
        }
        catch (class_151 e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid tag identifier '" + string + "' in block tag '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }
}

