/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.item;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.item.ItemPlacement;
import abeshutt.staracademy.data.item.PartialItem;
import abeshutt.staracademy.data.nbt.PartialCompoundNbt;
import abeshutt.staracademy.util.ItemUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class PartialStack
implements ItemPlacement<PartialStack> {
    protected PartialItem item;
    protected PartialCompoundNbt nbt;

    protected PartialStack(PartialItem item, PartialCompoundNbt nbt) {
        this.item = item;
        this.nbt = nbt;
    }

    public static PartialStack of(PartialItem item, PartialCompoundNbt nbt) {
        return new PartialStack(item, nbt);
    }

    public static PartialStack of(class_1799 stack) {
        return new PartialStack(PartialItem.of(stack), PartialCompoundNbt.of(stack));
    }

    public PartialItem getItem() {
        return this.item;
    }

    public PartialCompoundNbt getNbt() {
        return this.nbt;
    }

    public void setItem(PartialItem item) {
        this.item = item;
    }

    public void setNbt(PartialCompoundNbt nbt) {
        this.nbt = nbt;
    }

    @Override
    public boolean isSubsetOf(PartialStack other) {
        if (!this.item.isSubsetOf(other.item)) {
            return false;
        }
        return this.nbt.isSubsetOf(other.nbt);
    }

    @Override
    public boolean isSubsetOf(class_1799 stack) {
        if (!this.item.isSubsetOf(stack)) {
            return false;
        }
        return this.nbt.isSubsetOf(stack);
    }

    @Override
    public void fillInto(PartialStack other) {
        this.item.fillInto(other.item);
        this.nbt.fillInto(other.nbt);
    }

    @Override
    public Optional<class_1799> generate(int count) {
        return this.item.generate(count).map(stack -> {
            ItemUtils.setNbt(stack, this.nbt.asWhole().orElse(null));
            return stack;
        });
    }

    @Override
    public boolean test(PartialItem item, PartialCompoundNbt nbt) {
        return this.isSubsetOf(PartialStack.of(item, nbt));
    }

    @Override
    public void validate(String path) {
        this.item.validate(path);
        this.nbt.validate(path);
    }

    @Override
    public PartialStack copy() {
        return new PartialStack(this.item.copy(), this.nbt.copy());
    }

    public String toString() {
        return this.item.toString() + this.nbt.toString();
    }

    public static Optional<PartialStack> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialStack.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialStack parse(String string) throws CommandSyntaxException {
        return PartialStack.parse(new StringReader(string));
    }

    public static PartialStack parse(StringReader reader) throws CommandSyntaxException {
        return PartialStack.of(PartialItem.parse(reader), PartialCompoundNbt.parse(reader));
    }

    public static class Adapter
    implements ISimpleAdapter<PartialStack, class_2520, JsonElement> {
        @Override
        public void writeBits(PartialStack value, BitBuffer buffer) {
            buffer.writeBoolean(value != null);
            if (value != null) {
                Adapters.PARTIAL_ITEM.writeBits(value.item, buffer);
                Adapters.PARTIAL_NBT.writeBits(value.nbt, buffer);
            }
        }

        @Override
        public Optional<PartialStack> readBits(BitBuffer buffer) {
            if (buffer.readBoolean()) {
                return Optional.of(new PartialStack(Adapters.PARTIAL_ITEM.readBits(buffer).orElse(null), Adapters.PARTIAL_NBT.readBits(buffer).orElse(null)));
            }
            return Optional.empty();
        }

        @Override
        public Optional<class_2520> writeNbt(PartialStack value) {
            if (value == null) {
                return Optional.empty();
            }
            class_2487 nbt = new class_2487();
            Adapters.PARTIAL_ITEM.writeNbt(value.item).ifPresent(tag -> nbt.method_10566("item", tag));
            Adapters.PARTIAL_NBT.writeNbt(value.nbt).ifPresent(tag -> nbt.method_10566("nbt", tag));
            return Optional.of(nbt);
        }

        @Override
        public Optional<PartialStack> readNbt(class_2520 nbt) {
            if (nbt instanceof class_2487) {
                class_2487 compound = (class_2487)nbt;
                PartialItem item = Adapters.PARTIAL_ITEM.readNbt(compound.method_10580("item")).orElseThrow();
                PartialCompoundNbt tag = Adapters.PARTIAL_NBT.readNbt(compound.method_10580("nbt")).orElseGet(PartialCompoundNbt::empty);
                return Optional.of(PartialStack.of(item, tag));
            }
            return Optional.empty();
        }

        @Override
        public Optional<JsonElement> writeJson(PartialStack value) {
            if (value == null) {
                return Optional.empty();
            }
            JsonObject json = new JsonObject();
            Adapters.PARTIAL_ITEM.writeJson(value.item).ifPresent(tag -> json.add("item", tag));
            Adapters.PARTIAL_NBT.writeJson(value.nbt).ifPresent(tag -> json.add("nbt", tag));
            return Optional.of(json);
        }

        @Override
        public Optional<PartialStack> readJson(JsonElement json) {
            if (json instanceof JsonObject) {
                JsonObject object = (JsonObject)json;
                PartialItem item = (PartialItem)Adapters.PARTIAL_ITEM.readJson(object.get("item")).orElseThrow();
                PartialCompoundNbt tag = Adapters.PARTIAL_NBT.readJson(object.get("nbt")).orElseGet(PartialCompoundNbt::empty);
                return Optional.of(PartialStack.of(item, tag));
            }
            return Optional.empty();
        }
    }
}

