/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.item;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.item.ItemPlacement;
import abeshutt.staracademy.data.nbt.PartialCompoundNbt;
import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class PartialItem
implements ItemPlacement<PartialItem> {
    protected class_2960 id;

    protected PartialItem(class_2960 id) {
        this.id = id;
    }

    public static PartialItem empty() {
        return new PartialItem(null);
    }

    public static PartialItem of(class_2960 id) {
        return new PartialItem(id);
    }

    public static PartialItem of(class_1792 item) {
        return new PartialItem(class_7923.field_41178.method_10221((Object)item));
    }

    public static PartialItem of(class_1799 stack) {
        return new PartialItem(class_7923.field_41178.method_10221((Object)stack.method_7909()));
    }

    @Override
    public boolean isSubsetOf(PartialItem other) {
        return this.id == null || this.id.equals((Object)other.id);
    }

    @Override
    public boolean isSubsetOf(class_1799 stack) {
        return this.isSubsetOf(PartialItem.of(stack));
    }

    @Override
    public void fillInto(PartialItem other) {
        if (this.id == null) {
            return;
        }
        other.id = this.id;
    }

    @Override
    public Optional<class_1799> generate(int count) {
        return this.asWhole().map(item -> new class_1799((class_1935)item, count));
    }

    @Override
    public boolean test(PartialItem item, PartialCompoundNbt nbt) {
        return this.isSubsetOf(item);
    }

    @Override
    public void validate(String path) {
        if (this.asWhole().isEmpty()) {
            StarAcademyMod.LOGGER.error("%s: Unregistered item <%s>".formatted(path, this.id));
        }
    }

    public Optional<class_1792> asWhole() {
        return class_7923.field_41178.method_17966(this.id);
    }

    @Override
    public PartialItem copy() {
        return new PartialItem(this.id);
    }

    public String toString() {
        return this.id == null ? "" : this.id.toString();
    }

    public static Optional<PartialItem> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialItem.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialItem parse(String string) throws CommandSyntaxException {
        return PartialItem.parse(new StringReader(string));
    }

    public static PartialItem parse(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead() || !PartialItem.isCharValid(reader.peek())) {
            return PartialItem.empty();
        }
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialItem.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialItem.of(class_2960.method_60654((String)string));
        }
        catch (class_151 e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid item identifier '" + string + "' in stack '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }

    public static class Adapter
    implements ISimpleAdapter<PartialItem, class_2520, JsonElement> {
        @Override
        public Optional<class_2520> writeNbt(PartialItem value) {
            return value == null ? Optional.empty() : Adapters.IDENTIFIER.writeNbt(value.id);
        }

        @Override
        public Optional<PartialItem> readNbt(class_2520 nbt) {
            return nbt == null ? Optional.empty() : Adapters.IDENTIFIER.readNbt(nbt).map(PartialItem::of);
        }
    }
}

