/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.item;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.adapter.array.ArrayAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.item.PartialItem;
import abeshutt.staracademy.data.item.PartialItemGroup;
import abeshutt.staracademy.data.item.PartialItemTag;
import abeshutt.staracademy.data.item.PartialStack;
import abeshutt.staracademy.data.nbt.PartialCompoundNbt;
import abeshutt.staracademy.data.tile.OrItemPredicate;
import abeshutt.staracademy.util.ItemUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

@FunctionalInterface
public interface ItemPredicate {
    public static final ItemPredicate FALSE = (item, nbt) -> false;
    public static final ItemPredicate TRUE = (item, nbt) -> true;

    public boolean test(PartialItem var1, PartialCompoundNbt var2);

    default public void validate(String path) {
    }

    default public boolean test(PartialStack stack) {
        return this.test(stack.getItem(), stack.getNbt());
    }

    default public boolean test(class_1799 stack) {
        return this.test(PartialItem.of(stack.method_7909()), PartialCompoundNbt.of(ItemUtils.getNbt(stack)));
    }

    public static Optional<ItemPredicate> of(String string, boolean logErrors) {
        if (string.isEmpty()) {
            return Optional.of(TRUE);
        }
        return (switch (string.charAt(0)) {
            case '#' -> PartialItemTag.parse(string, logErrors);
            case '@' -> PartialItemGroup.parse(string, logErrors);
            default -> PartialStack.parse(string, logErrors);
        }).map(o -> o);
    }

    public static class Adapter
    implements ISimpleAdapter<ItemPredicate, class_2520, JsonElement> {
        private static ArrayAdapter<ItemPredicate> LIST = Adapters.ofArray(ItemPredicate[]::new, new Adapter());

        @Override
        public void writeBits(ItemPredicate value, BitBuffer buffer) {
            buffer.writeBoolean(value == null);
            if (value != null) {
                if (value instanceof OrItemPredicate) {
                    OrItemPredicate or = (OrItemPredicate)value;
                    buffer.writeBoolean(true);
                    LIST.writeBits((ItemPredicate)or.getChildren(), buffer);
                } else {
                    buffer.writeBoolean(false);
                    Adapters.UTF_8.writeBits(value.toString(), buffer);
                }
            }
        }

        @Override
        public final Optional<ItemPredicate> readBits(BitBuffer buffer) {
            if (buffer.readBoolean()) {
                return Optional.empty();
            }
            if (buffer.readBoolean()) {
                return LIST.readBits(buffer).map(OrItemPredicate::new);
            }
            return Adapters.UTF_8.readBits(buffer).map(string -> ItemPredicate.of(string, true).orElse(FALSE));
        }

        @Override
        public Optional<class_2520> writeNbt(ItemPredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrItemPredicate) {
                OrItemPredicate or = (OrItemPredicate)value;
                return LIST.writeNbt((ItemPredicate)or.getChildren());
            }
            return Optional.of(class_2519.method_23256((String)value.toString()));
        }

        @Override
        public Optional<ItemPredicate> readNbt(class_2520 nbt) {
            if (nbt == null) {
                return Optional.empty();
            }
            if (nbt instanceof class_2499) {
                class_2499 list = (class_2499)nbt;
                return LIST.readNbt(list).map(OrItemPredicate::new);
            }
            if (nbt instanceof class_2519) {
                class_2519 string = (class_2519)nbt;
                return Optional.of(ItemPredicate.of(string.method_10714(), true).orElse(FALSE));
            }
            return Optional.empty();
        }

        @Override
        public Optional<JsonElement> writeJson(ItemPredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrItemPredicate) {
                OrItemPredicate or = (OrItemPredicate)value;
                return LIST.writeJson((ItemPredicate)or.getChildren());
            }
            return Optional.of(new JsonPrimitive(value.toString()));
        }

        @Override
        public Optional<ItemPredicate> readJson(JsonElement json) {
            JsonPrimitive primitive;
            if (json == null) {
                return Optional.empty();
            }
            if (json instanceof JsonArray) {
                JsonArray array = (JsonArray)json;
                return LIST.readJson(array).map(OrItemPredicate::new);
            }
            if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
                return Optional.of(ItemPredicate.of(json.getAsString(), true).orElse(FALSE));
            }
            return Optional.empty();
        }
    }
}

