/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.entity;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.adapter.array.ArrayAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.entity.OrEntityPredicate;
import abeshutt.staracademy.data.entity.PartialEntity;
import abeshutt.staracademy.data.entity.PartialEntityGroup;
import abeshutt.staracademy.data.entity.PartialEntityTag;
import abeshutt.staracademy.data.nbt.PartialCompoundNbt;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

@FunctionalInterface
public interface EntityPredicate {
    public static final EntityPredicate FALSE = (pos, blockPos, nbt) -> false;
    public static final EntityPredicate TRUE = (pos, blockPos, nbt) -> true;

    public boolean test(class_243 var1, class_2338 var2, PartialCompoundNbt var3);

    default public boolean test(PartialEntity entity) {
        return this.test(entity.getPos(), entity.getBlockPos(), entity.getNbt());
    }

    default public boolean test(class_1297 entity) {
        class_2487 nbt = new class_2487();
        entity.method_5786(nbt);
        return this.test(entity.method_19538(), entity.method_24515(), PartialCompoundNbt.of(nbt));
    }

    public static Optional<EntityPredicate> of(String string, boolean logErrors) {
        if (string.isEmpty()) {
            return Optional.of(TRUE);
        }
        return (switch (string.charAt(0)) {
            case '#' -> PartialEntityTag.parse(string, logErrors);
            case '@' -> PartialEntityGroup.parse(string, logErrors);
            default -> PartialEntity.parse(string, logErrors);
        }).map(o -> o);
    }

    public static class Adapter
    implements ISimpleAdapter<EntityPredicate, class_2520, JsonElement> {
        private static ArrayAdapter<EntityPredicate> LIST = Adapters.ofArray(EntityPredicate[]::new, new Adapter());

        @Override
        public void writeBits(EntityPredicate value, BitBuffer buffer) {
            buffer.writeBoolean(value == null);
            if (value != null) {
                if (value instanceof OrEntityPredicate) {
                    OrEntityPredicate or = (OrEntityPredicate)value;
                    buffer.writeBoolean(true);
                    LIST.writeBits((EntityPredicate)or.getChildren(), buffer);
                } else {
                    buffer.writeBoolean(false);
                    Adapters.UTF_8.writeBits(value.toString(), buffer);
                }
            }
        }

        @Override
        public final Optional<EntityPredicate> readBits(BitBuffer buffer) {
            if (buffer.readBoolean()) {
                return Optional.empty();
            }
            if (buffer.readBoolean()) {
                return LIST.readBits(buffer).map(OrEntityPredicate::new);
            }
            return Adapters.UTF_8.readBits(buffer).map(string -> EntityPredicate.of(string, true).orElse(FALSE));
        }

        @Override
        public Optional<class_2520> writeNbt(EntityPredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrEntityPredicate) {
                OrEntityPredicate or = (OrEntityPredicate)value;
                return LIST.writeNbt((EntityPredicate)or.getChildren());
            }
            return Optional.of(class_2519.method_23256((String)value.toString()));
        }

        @Override
        public Optional<EntityPredicate> readNbt(class_2520 nbt) {
            if (nbt == null) {
                return Optional.empty();
            }
            if (nbt instanceof class_2499) {
                class_2499 list = (class_2499)nbt;
                return LIST.readNbt(list).map(OrEntityPredicate::new);
            }
            if (nbt instanceof class_2519) {
                class_2519 string = (class_2519)nbt;
                return Optional.of(EntityPredicate.of(string.method_10714(), true).orElse(FALSE));
            }
            return Optional.empty();
        }

        @Override
        public Optional<JsonElement> writeJson(EntityPredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrEntityPredicate) {
                OrEntityPredicate or = (OrEntityPredicate)value;
                return LIST.writeJson((EntityPredicate)or.getChildren());
            }
            return Optional.of(new JsonPrimitive(value.toString()));
        }

        @Override
        public Optional<EntityPredicate> readJson(JsonElement json) {
            JsonPrimitive primitive;
            if (json == null) {
                return Optional.empty();
            }
            if (json instanceof JsonArray) {
                JsonArray array = (JsonArray)json;
                return LIST.readJson(array).map(OrEntityPredicate::new);
            }
            if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
                return Optional.of(EntityPredicate.of(json.getAsString(), true).orElse(FALSE));
            }
            return Optional.empty();
        }
    }
}

