/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.biome;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.biome.BiomePlacement;
import com.google.gson.JsonElement;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class PartialBiome
implements BiomePlacement<PartialBiome> {
    protected class_2960 id;

    protected PartialBiome(class_2960 id) {
        this.id = id;
    }

    public static PartialBiome empty() {
        return new PartialBiome(null);
    }

    public static PartialBiome of(class_2960 id) {
        return new PartialBiome(id);
    }

    public static PartialBiome of(class_2248 block) {
        return new PartialBiome(class_7923.field_41175.method_10221((Object)block));
    }

    public static PartialBiome of(class_2680 state) {
        return new PartialBiome(class_7923.field_41175.method_10221((Object)state.method_26204()));
    }

    @Override
    public boolean isSubsetOf(PartialBiome other) {
        return this.id == null || this.id.equals((Object)other.id);
    }

    @Override
    public boolean isSubsetOf(class_1922 world, class_2338 pos) {
        return this.isSubsetOf(PartialBiome.of(world.method_8320(pos).method_26204()));
    }

    @Override
    public void fillInto(PartialBiome other) {
        if (this.id == null) {
            return;
        }
        other.id = this.id;
    }

    @Override
    public boolean test(class_6880<class_1959> biome) {
        return this.isSubsetOf(PartialBiome.of(biome.method_40230().map(class_5321::method_29177).orElse(null)));
    }

    @Override
    public PartialBiome copy() {
        return new PartialBiome(this.id);
    }

    public String toString() {
        return this.id == null ? "" : this.id.toString();
    }

    public static Optional<PartialBiome> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialBiome.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialBiome parse(String string) throws CommandSyntaxException {
        return PartialBiome.parse(new StringReader(string));
    }

    public static PartialBiome parse(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead() || !PartialBiome.isCharValid(reader.peek())) {
            return PartialBiome.empty();
        }
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialBiome.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialBiome.of(class_2960.method_60654((String)string));
        }
        catch (class_151 e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid biome identifier '" + string + "' in '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }

    public static class Adapter
    implements ISimpleAdapter<PartialBiome, class_2520, JsonElement> {
        @Override
        public Optional<class_2520> writeNbt(PartialBiome value) {
            return value == null ? Optional.empty() : Adapters.IDENTIFIER.writeNbt(value.id);
        }

        @Override
        public Optional<PartialBiome> readNbt(class_2520 nbt) {
            return nbt == null ? Optional.empty() : Adapters.IDENTIFIER.readNbt(nbt).map(PartialBiome::of);
        }
    }
}

