/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.biome;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.adapter.array.ArrayAdapter;
import abeshutt.staracademy.data.biome.OrBiomePredicate;
import abeshutt.staracademy.data.biome.PartialBiome;
import abeshutt.staracademy.data.biome.PartialBiomeGroup;
import abeshutt.staracademy.data.biome.PartialBiomeTag;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

@FunctionalInterface
public interface BiomePredicate {
    public static final BiomePredicate FALSE = biome -> false;
    public static final BiomePredicate TRUE = biome -> true;

    public boolean test(class_6880<class_1959> var1);

    default public boolean test(class_1959 biome, class_5455 registries) {
        return this.test((class_6880<class_1959>)registries.method_30530(class_7924.field_41236).method_47983((Object)biome));
    }

    public static Optional<BiomePredicate> of(String string, boolean logErrors) {
        if (string.isEmpty()) {
            return Optional.of(TRUE);
        }
        return (switch (string.charAt(0)) {
            case '#' -> PartialBiomeTag.parse(string, logErrors);
            case '@' -> PartialBiomeGroup.parse(string, logErrors);
            default -> PartialBiome.parse(string, logErrors);
        }).map(o -> o);
    }

    public static class Adapter
    implements ISimpleAdapter<BiomePredicate, class_2520, JsonElement> {
        private static ArrayAdapter<BiomePredicate> LIST = Adapters.ofArray(BiomePredicate[]::new, new Adapter());

        @Override
        public void writeBits(BiomePredicate value, BitBuffer buffer) {
            buffer.writeBoolean(value == null);
            if (value != null) {
                if (value instanceof OrBiomePredicate) {
                    OrBiomePredicate or = (OrBiomePredicate)value;
                    buffer.writeBoolean(true);
                    LIST.writeBits((BiomePredicate)or.getChildren(), buffer);
                } else {
                    buffer.writeBoolean(false);
                    Adapters.UTF_8.writeBits(value.toString(), buffer);
                }
            }
        }

        @Override
        public final Optional<BiomePredicate> readBits(BitBuffer buffer) {
            if (buffer.readBoolean()) {
                return Optional.empty();
            }
            if (buffer.readBoolean()) {
                return LIST.readBits(buffer).map(OrBiomePredicate::new);
            }
            return Adapters.UTF_8.readBits(buffer).map(string -> BiomePredicate.of(string, true).orElse(FALSE));
        }

        @Override
        public Optional<class_2520> writeNbt(BiomePredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrBiomePredicate) {
                OrBiomePredicate or = (OrBiomePredicate)value;
                return LIST.writeNbt((BiomePredicate)or.getChildren());
            }
            return Optional.of(class_2519.method_23256((String)value.toString()));
        }

        @Override
        public Optional<BiomePredicate> readNbt(class_2520 nbt) {
            if (nbt == null) {
                return Optional.empty();
            }
            if (nbt instanceof class_2499) {
                class_2499 list = (class_2499)nbt;
                return LIST.readNbt(list).map(OrBiomePredicate::new);
            }
            if (nbt instanceof class_2519) {
                class_2519 string = (class_2519)nbt;
                return Optional.of(BiomePredicate.of(string.method_10714(), true).orElse(FALSE));
            }
            return Optional.empty();
        }

        @Override
        public Optional<JsonElement> writeJson(BiomePredicate value) {
            if (value == null) {
                return Optional.empty();
            }
            if (value instanceof OrBiomePredicate) {
                OrBiomePredicate or = (OrBiomePredicate)value;
                return LIST.writeJson((BiomePredicate)or.getChildren());
            }
            return Optional.of(new JsonPrimitive(value.toString()));
        }

        @Override
        public Optional<BiomePredicate> readJson(JsonElement json) {
            JsonPrimitive primitive;
            if (json == null) {
                return Optional.empty();
            }
            if (json instanceof JsonArray) {
                JsonArray array = (JsonArray)json;
                return LIST.readJson(array).map(OrBiomePredicate::new);
            }
            if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
                return Optional.of(BiomePredicate.of(json.getAsString(), true).orElse(FALSE));
            }
            return Optional.empty();
        }
    }
}

