/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.util;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.IAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.proxy.ProxySpeciesDexRecord;
import com.cobblemon.mod.common.api.pokedex.AbstractPokedexManager;
import com.cobblemon.mod.common.api.pokedex.FormDexRecord;
import com.cobblemon.mod.common.api.pokedex.SpeciesDexRecord;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class SpeciesDexRecordAdapter
implements IAdapter<SpeciesDexRecord, class_2487, JsonObject, AbstractPokedexManager> {
    private final boolean nullable;

    public SpeciesDexRecordAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public SpeciesDexRecordAdapter asNullable() {
        return new SpeciesDexRecordAdapter(true);
    }

    @Override
    public void writeBits(SpeciesDexRecord value, BitBuffer buffer, AbstractPokedexManager context) {
        if (this.nullable) {
            Adapters.BOOLEAN.writeBits(value == null, buffer);
            if (value == null) {
                return;
            }
        }
        Adapters.IDENTIFIER.writeBits(value.id, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(value.getAspects().size(), buffer);
        for (String aspect : value.getAspects()) {
            Adapters.UTF_8.writeBits(aspect, buffer);
        }
        Map<String, FormDexRecord> formRecords = ProxySpeciesDexRecord.of(value).orElseThrow().getFormRecords();
        Adapters.INT_SEGMENTED_3.writeBits(formRecords.size(), buffer);
        for (Map.Entry<String, FormDexRecord> entry : formRecords.entrySet()) {
            Adapters.UTF_8.writeBits(entry.getKey(), buffer);
            Adapters.FORM_DEX_RECORD.writeBits(entry.getValue(), buffer, value);
        }
    }

    @Override
    public Optional<SpeciesDexRecord> readBits(BitBuffer buffer, AbstractPokedexManager context) {
        if (this.nullable && Adapters.BOOLEAN.readBits(buffer).orElseThrow().booleanValue()) {
            return Optional.empty();
        }
        SpeciesDexRecord record = new SpeciesDexRecord();
        record.initialize(context, Adapters.IDENTIFIER.readBits(buffer).orElseThrow());
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            record.getAspects().add(Adapters.UTF_8.readBits(buffer).orElseThrow());
        }
        Map<String, FormDexRecord> formRecords = ProxySpeciesDexRecord.of(record).orElseThrow().getFormRecords();
        formRecords.clear();
        size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            formRecords.put(Adapters.UTF_8.readBits(buffer).orElseThrow(), Adapters.FORM_DEX_RECORD.readBits(buffer, record).orElseThrow());
        }
        return Optional.of(record);
    }

    @Override
    public Optional<class_2487> writeNbt(SpeciesDexRecord value, AbstractPokedexManager context) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(new class_2487()).map(nbt -> {
            Adapters.IDENTIFIER.writeNbt(value.id).ifPresent(tag -> nbt.method_10566("id", tag));
            class_2499 aspects = new class_2499();
            for (String aspect : value.getAspects()) {
                Adapters.UTF_8.writeNbt(aspect).ifPresent(arg_0 -> aspects.add(arg_0));
            }
            nbt.method_10566("aspects", (class_2520)aspects);
            Map<String, FormDexRecord> formRecords = ProxySpeciesDexRecord.of(value).orElseThrow().getFormRecords();
            class_2487 records = new class_2487();
            formRecords.forEach((id, record) -> Adapters.FORM_DEX_RECORD.writeNbt((FormDexRecord)record, value).ifPresent(tag -> records.method_10566(id, (class_2520)tag)));
            nbt.method_10566("records", (class_2520)records);
            return nbt;
        });
    }

    @Override
    public Optional<SpeciesDexRecord> readNbt(class_2487 nbt, AbstractPokedexManager context) {
        if (nbt == null) {
            return Optional.empty();
        }
        SpeciesDexRecord record = new SpeciesDexRecord();
        record.initialize(context, Adapters.IDENTIFIER.readNbt(nbt.method_10580("id")).orElseThrow());
        Map<String, FormDexRecord> formRecords = ProxySpeciesDexRecord.of(record).orElseThrow().getFormRecords();
        record.getAspects().clear();
        formRecords.clear();
        class_2520 class_25202 = nbt.method_10580("aspects");
        if (class_25202 instanceof class_2499) {
            class_2499 aspects = (class_2499)class_25202;
            for (class_2520 aspect : aspects) {
                Adapters.UTF_8.readNbt(aspect).ifPresent(record.getAspects()::add);
            }
        }
        class_2487 records = nbt.method_10562("records");
        for (String id : records.method_10541()) {
            Adapters.FORM_DEX_RECORD.readNbt(records.method_10562(id), record).ifPresent(child -> formRecords.put(id, (FormDexRecord)child));
        }
        return Optional.of(record);
    }
}

