/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.util;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_1091;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class ModelIdentifierAdapter
implements ISimpleAdapter<class_1091, class_2520, JsonElement> {
    private final boolean nullable;

    public ModelIdentifierAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public ModelIdentifierAdapter asNullable() {
        return new ModelIdentifierAdapter(true);
    }

    @Override
    public void writeBits(class_1091 value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.IDENTIFIER.writeBits(value.comp_2875(), buffer);
            Adapters.UTF_8.writeBits(value.method_4740(), buffer);
        }
    }

    @Override
    public Optional<class_1091> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(new class_1091(Adapters.IDENTIFIER.readBits(buffer).orElseThrow(), Adapters.UTF_8.readBits(buffer).orElseThrow()));
    }

    @Override
    public void writeBytes(class_1091 value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.IDENTIFIER.writeBytes(value.comp_2875(), buffer);
            Adapters.UTF_8.writeBytes(value.method_4740(), buffer);
        }
    }

    @Override
    public Optional<class_1091> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(new class_1091(Adapters.IDENTIFIER.readBytes(buffer).orElseThrow(), Adapters.UTF_8.readBytes(buffer).orElseThrow()));
    }

    @Override
    public void writeData(class_1091 value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.IDENTIFIER.writeData(value.comp_2875(), data);
            Adapters.UTF_8.writeData(value.method_4740(), data);
        }
    }

    @Override
    public Optional<class_1091> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(new class_1091(Adapters.IDENTIFIER.readData(data).orElseThrow(), Adapters.UTF_8.readData(data).orElseThrow()));
    }

    @Override
    public Optional<class_2520> writeNbt(class_1091 value) {
        if (value == null) {
            return Optional.empty();
        }
        return Adapters.UTF_8.writeNbt(value.toString());
    }

    @Override
    public Optional<class_1091> readNbt(class_2520 nbt) {
        class_2960 id;
        class_2519 string;
        String[] parts;
        if (nbt instanceof class_2519 && (parts = (string = (class_2519)nbt).method_10714().split(Pattern.quote("#"))).length == 2 && (id = class_2960.method_12829((String)parts[0])) != null) {
            return Optional.of(new class_1091(id, parts[1]));
        }
        return Optional.empty();
    }

    @Override
    public Optional<JsonElement> writeJson(class_1091 value) {
        if (value == null) {
            return Optional.empty();
        }
        return Adapters.UTF_8.writeJson(value.toString());
    }

    @Override
    public Optional<class_1091> readJson(JsonElement json) {
        class_2960 id;
        String[] parts;
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString() && (parts = primitive.getAsString().split(Pattern.quote("#"))).length == 2 && (id = class_2960.method_12829((String)parts[0])) != null) {
            return Optional.of(new class_1091(id, parts[1]));
        }
        return Optional.empty();
    }
}

