/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.util;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.class_2483;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class IdentifierAdapter
implements ISimpleAdapter<class_2960, class_2520, JsonElement> {
    private final boolean nullable;

    public IdentifierAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public IdentifierAdapter asNullable() {
        return new IdentifierAdapter(true);
    }

    @Override
    public void writeBits(class_2960 value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            buffer.writeIdentifier(value);
        }
    }

    @Override
    public Optional<class_2960> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(buffer.readIdentifier());
    }

    @Override
    public void writeBytes(class_2960 value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            String string = value.method_12836().equals("minecraft") ? value.method_12832() : value.toString();
            Adapters.UTF_8.writeBytes(string, buffer);
        }
    }

    @Override
    public Optional<class_2960> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(class_2960.method_60654((String)Adapters.UTF_8.readBytes(buffer).orElseThrow()));
    }

    @Override
    public void writeData(class_2960 value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            String string = value.method_12836().equals("minecraft") ? value.method_12832() : value.toString();
            Adapters.UTF_8.writeData(string, data);
        }
    }

    @Override
    public Optional<class_2960> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(class_2960.method_60654((String)Adapters.UTF_8.readData(data).orElseThrow()));
    }

    @Override
    public Optional<class_2520> writeNbt(class_2960 value) {
        if (value == null) {
            return Optional.empty();
        }
        String string = value.method_12836().equals("minecraft") ? value.method_12832() : value.toString();
        return Optional.of(class_2519.method_23256((String)string));
    }

    @Override
    public Optional<class_2960> readNbt(class_2520 nbt) {
        class_2483 array;
        class_2483 array2;
        if (nbt instanceof class_2519) {
            class_2519 string = (class_2519)nbt;
            return Optional.ofNullable(class_2960.method_12829((String)string.method_10714()));
        }
        if (nbt instanceof class_2483 && (array2 = (class_2483)nbt).size() == 1) {
            return this.readNbt((class_2520)array2.get(0));
        }
        if (nbt instanceof class_2483 && (array = (class_2483)nbt).size() == 2) {
            String namespace = Adapters.UTF_8.readNbt((class_2520)array.get(0)).orElse(null);
            String path = Adapters.UTF_8.readNbt((class_2520)array.get(1)).orElse(null);
            if (namespace == null || path == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(class_2960.method_12829((String)(namespace + ":" + path)));
        }
        return Optional.empty();
    }

    @Override
    public Optional<JsonElement> writeJson(class_2960 value) {
        if (value == null) {
            return Optional.empty();
        }
        String string = value.method_12836().equals("minecraft") ? value.method_12832() : value.toString();
        return Optional.of(new JsonPrimitive(string));
    }

    @Override
    public Optional<class_2960> readJson(JsonElement json) {
        JsonArray array;
        JsonArray array2;
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            return Optional.ofNullable(class_2960.method_12829((String)primitive.getAsString()));
        }
        if (json instanceof JsonArray && (array2 = (JsonArray)json).size() == 1) {
            return this.readJson(array2.get(0));
        }
        if (json instanceof JsonArray && (array = (JsonArray)json).size() == 2) {
            String namespace = Adapters.UTF_8.readJson(array.get(0)).orElse(null);
            String path = Adapters.UTF_8.readJson(array.get(1)).orElse(null);
            if (namespace == null || path == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(class_2960.method_12829((String)(namespace + ":" + path)));
        }
        return Optional.empty();
    }
}

