/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.util;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class GameProfileAdapter
implements ISimpleAdapter<GameProfile, class_2520, JsonElement> {
    private final boolean nullable;

    public GameProfileAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public GameProfileAdapter asNullable() {
        return new GameProfileAdapter(true);
    }

    @Override
    public void writeBits(GameProfile value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.UUID.writeBits(value.getId(), buffer);
            Adapters.UTF_8.writeBits(value.getName(), buffer);
            Adapters.INT_SEGMENTED_3.writeBits(value.getProperties().size(), buffer);
            value.getProperties().forEach((key, property) -> {
                Adapters.UTF_8.asNullable().writeBits((String)key, buffer);
                Adapters.UTF_8.asNullable().writeBits(property.name(), buffer);
                Adapters.UTF_8.asNullable().writeBits(property.value(), buffer);
                Adapters.UTF_8.asNullable().writeBits(property.signature(), buffer);
            });
        }
    }

    @Override
    public Optional<GameProfile> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        GameProfile profile = new GameProfile(Adapters.UUID.readBits(buffer).orElseThrow(), Adapters.UTF_8.readBits(buffer).orElseThrow());
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            String key = Adapters.UTF_8.asNullable().readBits(buffer).orElse(null);
            String name = Adapters.UTF_8.asNullable().readBits(buffer).orElse(null);
            String value = Adapters.UTF_8.asNullable().readBits(buffer).orElse(null);
            String signature = Adapters.UTF_8.asNullable().readBits(buffer).orElse(null);
            profile.getProperties().put((Object)key, (Object)new Property(name, value, signature));
        }
        return Optional.of(profile);
    }

    @Override
    public Optional<class_2520> writeNbt(GameProfile value) {
        return Optional.of(new class_2487()).map(nbt -> {
            Adapters.UUID.writeNbt(value.getId()).ifPresent(tag -> nbt.method_10566("id", tag));
            Adapters.UTF_8.writeNbt(value.getName()).ifPresent(tag -> nbt.method_10566("name", tag));
            if (!value.getProperties().isEmpty()) {
                class_2487 properties = new class_2487();
                value.getProperties().forEach((key, property) -> {
                    class_2487 entry = new class_2487();
                    Adapters.UTF_8.writeNbt(property.name()).ifPresent(tag -> entry.method_10566("name", tag));
                    Adapters.UTF_8.writeNbt(property.value()).ifPresent(tag -> entry.method_10566("value", tag));
                    Adapters.UTF_8.writeNbt(property.signature()).ifPresent(tag -> entry.method_10566("signature", tag));
                    properties.method_10566(key, (class_2520)entry);
                });
                nbt.method_10566("properties", (class_2520)properties);
            }
            return nbt;
        });
    }

    @Override
    public Optional<GameProfile> readNbt(class_2520 nbt) {
        if (!(nbt instanceof class_2487)) {
            return Optional.empty();
        }
        class_2487 value = (class_2487)nbt;
        GameProfile profile = new GameProfile((UUID)Adapters.UUID.readNbt(value.method_10580("id")).orElse(null), (String)Adapters.UTF_8.readNbt(value.method_10580("name")).orElse(null));
        class_2487 properties = value.method_10562("properties");
        for (String key : properties.method_10541()) {
            class_2487 entry = properties.method_10562(key);
            profile.getProperties().put((Object)key, (Object)new Property((String)Adapters.UTF_8.readNbt(entry.method_10580("name")).orElse(null), (String)Adapters.UTF_8.readNbt(entry.method_10580("value")).orElse(null), (String)Adapters.UTF_8.readNbt(entry.method_10580("signature")).orElse(null)));
        }
        return Optional.of(profile);
    }
}

